/*
 * timeout.c
 *
 * Test front-end for generic NASD timeout mechanism
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_getopt.h>
#include <nasd/nasd_timeout.h>
#include <nasd/nasd_pdev.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_sys.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>

char *progname;

int use_kernel = 0;

nasd_timespec_t delta = { 0, 1000000 };

#if NASD_TIMEOUT_TEST == 0
nasd_status_t
nasd_timeout_test()
{
  return(NASD_OP_NOT_SUPPORTED);
}
#endif /* NASD_TIMEOUT_TEST == 0 */

void
usage()
{
  fprintf(stderr, "USAGE: %s [options]\n", progname);
  fprintf(stderr, "Options:\n");
  fprintf(stderr, "  -d delta (seconds, decimals allowed)\n");
  fprintf(stderr, "  -k test kernel\n");
  fflush(stderr);
  exit(1);
}

int
main(
  int     argc,
  char  **argv)
{
  nasd_status_t rc;
  double dd, d2;
  char c;

  progname = argv[0];

  while (nasd_getopt(argc, argv, "d:k", &c)) {
    switch(c) {
      case 'd':
        if (sscanf(nasd_optarg, "%lf", &dd) != 1)
          usage();
        if (dd < (double)0.0)
          usage();
        delta.ts_sec = (nasd_int32)dd;
        d2 = dd - (double)delta.ts_sec;
        d2 *= (double)NASD_NSEC_PER_SEC;
        delta.ts_nsec = (nasd_int32)d2;
        break;
      case 'k':
        use_kernel = 1;
        break;
      default:
        fprintf(stderr, "Unknown option '%c'\n", nasd_optopt);
        usage();
    }
  }

  if (nasd_optind < argc)
    usage();

  if (use_kernel == 0) {
    rc = nasd_timeout_test(delta);
  }
  else {
    rc = nasd_kernel_timeout_test(delta);
  }

  if (rc) {
    fprintf(stderr, "ERROR: failed timeout test with 0x%x (%s)\n",
      rc, nasd_error_string(rc));
    exit(1);
  }

  if (use_kernel == 0)
    printf("Passed timeout test\n");
  else
    printf("Passed kernel timeout test\n");

  fflush(stderr);
  fflush(stdout);

  exit(0);
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
