/*
 * nasd_linux_drive_client_syms.h
 *
 * NASD Drive Client API Linux Kernel Symbols
 *
 * Authors: Jim Zelenka, Sean Levy
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_timer.h>
#include <nasd/nasd_timeout.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_marshall.h>
#include <nasd/nasd_pdrive_client.h>

NASD_EXPORT_SYMBOL(nasd_cl_p_init);
NASD_EXPORT_SYMBOL(nasd_cl_p_shutdown);

NASD_EXPORT_SYMBOL(nasd_bind_to_drive);
NASD_EXPORT_SYMBOL(nasd_unbind_drive);
NASD_EXPORT_SYMBOL(_nasd_cl_error_string);

/* drive ops */
NASD_EXPORT_SYMBOL(nasd_cl_p_null_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_sync_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_part_creat_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_create_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_create_dr__otw_provided);
NASD_EXPORT_SYMBOL(nasd_cl_p_getattr_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_write_simple_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_read_simple_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_tread_simple_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_range_read_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_range_tread_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_range_write_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_setattr_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_setattr_dr__otw_provided);
NASD_EXPORT_SYMBOL(nasd_cl_p_flush_obj_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_eject_obj_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_remove_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_initialize_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_strt_iread_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_stop_iread_dr);
NASD_EXPORT_SYMBOL(nasd_cl_p_rshutdown_dr);

NASD_EXPORT_SYMBOL(nasd_cl_p_rdwr_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_get_drive_info);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_put_drive_info);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_get_drive_cache_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_put_drive_cache_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_get_drive_op_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_put_drive_op_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_get_drive_io_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_put_drive_io_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_get_drive_io_read_size_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_put_drive_io_read_size_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_get_drive_io_write_size_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_put_drive_io_write_size_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_get_drive_layout_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_put_drive_layout_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_get_drive_ioqueue_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_put_drive_ioqueue_stats);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_get_part_info);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_get_drive_trace_basic);
NASD_EXPORT_SYMBOL(nasd_cl_p_ctrl_put_drive_trace_basic);


/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
