/*
 * nasd_linux_common_syms.h
 *
 * NASD Common API Linux Kernel Module Symbols
 *
 * Authors: Sean Levy, Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>

#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_timer.h>
#include <nasd/nasd_timeout.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_marshall.h>
#include <nasd/nasd_security.h>
#include <nasd/nasd_pipe.h>

/* basics */
NASD_EXPORT_SYMBOL(_nasd_timestr);
NASD_EXPORT_SYMBOL(_nasd_timestr_r);
NASD_EXPORT_SYMBOL(nasd_timestr_r);
NASD_EXPORT_SYMBOL(nasd_printstat);
NASD_EXPORT_SYMBOL(nasd_str_to_nasd_id);
NASD_EXPORT_SYMBOL(nasd_gettime);

/* memory */
#if NASD_MEM_FILL
NASD_EXPORT_SYMBOL(nasd_mem_filler);
NASD_EXPORT_SYMBOL(nasd_mem_do_fill);
#endif /* NASD_MEM_FILL */
#if NASD_MEM_COUNT_ALLOC > 0
NASD_EXPORT_SYMBOL(nasd_mem_allocated);
#endif /* NASD_MEM_COUNT_ALLOC > 0 */
NASD_EXPORT_SYMBOL(nasd_mem_dump_unfreed);
NASD_EXPORT_SYMBOL(nasd_mem_init);
NASD_EXPORT_SYMBOL(nasd_mem_shutdown);
NASD_EXPORT_SYMBOL(nasd_mem_track_alloc);
NASD_EXPORT_SYMBOL(nasd_mem_track_dealloc);
NASD_EXPORT_SYMBOL(nasd_mem_gettrack);
NASD_EXPORT_SYMBOL(nasd_mem_freetrack);

/* error reporting */
NASD_EXPORT_SYMBOL(nasd_error_string);

/* shutdown lists */
NASD_EXPORT_SYMBOL(nasd_shutdown_sys_init);
NASD_EXPORT_SYMBOL(nasd_shutdown_cleanup);
NASD_EXPORT_SYMBOL(nasd_shutdown_list_init);
NASD_EXPORT_SYMBOL(nasd_shutdown_list_shutdown);
NASD_EXPORT_SYMBOL(_nasd_shutdown_proc);
NASD_EXPORT_SYMBOL(_nasd_shutdown_mem);
NASD_EXPORT_SYMBOL(_nasd_shutdown_mutex);
NASD_EXPORT_SYMBOL(_nasd_shutdown_cond);
NASD_EXPORT_SYMBOL(_nasd_shutdown_rwlock);

/* security */
NASD_EXPORT_SYMBOL(nasd_security_generate_integrity_key);
NASD_EXPORT_SYMBOL(nasd_security_generate_privacy_key);
NASD_EXPORT_SYMBOL(nasd_security_get_drive_time);

/* timeouts */
NASD_EXPORT_SYMBOL(nasd_timeout_init);
NASD_EXPORT_SYMBOL(nasd_timeout_shutdown);
NASD_EXPORT_SYMBOL(nasd_timeout_add);
NASD_EXPORT_SYMBOL(nasd_timeout_get_status);
NASD_EXPORT_SYMBOL(nasd_timeout_cancel);
NASD_EXPORT_SYMBOL(nasd_timeout_suspend);
NASD_EXPORT_SYMBOL(nasd_timeout_resume);

/* pipes */
NASD_EXPORT_SYMBOL(nasd_co_pull);
NASD_EXPORT_SYMBOL(nasd_co_push);

NASD_EXPORT_SYMBOL(nasd_sys_init);
NASD_EXPORT_SYMBOL(nasd_sys_shutdown);
NASD_EXPORT_SYMBOL(nasd_get_clock_speed);
#if NASD_IDLE_SUPPORT > 0
NASD_EXPORT_SYMBOL(nasd_get_total_idle_time);
#endif /* NASD_IDLE_SUPPORT > 0 */
/* threads */
NASD_EXPORT_SYMBOL(_nasd_once);
NASD_EXPORT_SYMBOL(nasd_threads_init);
NASD_EXPORT_SYMBOL(nasd_threads_shutdown);
#if NASD_DEBUG_ATOMIC > 0
NASD_EXPORT_SYMBOL(_nasd_mutex_init);
NASD_EXPORT_SYMBOL(_nasd_mutex_destroy)
NASD_EXPORT_SYMBOL(_nasd_cond_init);
NASD_EXPORT_SYMBOL(_nasd_cond_destroy);
NASD_EXPORT_SYMBOL(_nasd_atent_try_lock_mutex);
#endif /* NASD_DEBUG_ATOMIC > 0 */
NASD_EXPORT_SYMBOL(nasd_sys_mutex_init);
NASD_EXPORT_SYMBOL(nasd_sys_mutex_destroy);
NASD_EXPORT_SYMBOL(nasd_sys_cond_init);
NASD_EXPORT_SYMBOL(nasd_sys_cond_destroy);
NASD_EXPORT_SYMBOL(nasd_sys_threadattr_create);
NASD_EXPORT_SYMBOL(nasd_sys_threadattr_destroy);
NASD_EXPORT_SYMBOL(nasd_sys_threadattr_setstacksize);
NASD_EXPORT_SYMBOL(nasd_sys_threadattr_getstacksize);
NASD_EXPORT_SYMBOL(nasd_sys_thread_create_attr);
NASD_EXPORT_SYMBOL(nasd_sys_thread_create);
NASD_EXPORT_SYMBOL(nasd_sys_thread_create_w_name);
NASD_EXPORT_SYMBOL(_nasd_init_threadgroup);
NASD_EXPORT_SYMBOL(_nasd_destroy_threadgroup);
#if NASD_TS_RWLOCK_DECLARED == 0 /* always for Linux, but what the hell */
NASD_EXPORT_SYMBOL(nasd_rwlock_read);
NASD_EXPORT_SYMBOL(nasd_rwlock_read_done);
NASD_EXPORT_SYMBOL(nasd_rwlock_write);
NASD_EXPORT_SYMBOL(nasd_rwlock_write_done);
NASD_EXPORT_SYMBOL(_nasd_rwlock_init);
NASD_EXPORT_SYMBOL(_nasd_rwlock_destroy);
#endif /* NASD_TS_RWLOCK_DECLARED == 0 */
/* random stuff */
NASD_EXPORT_SYMBOL(nasd_printf);
NASD_EXPORT_SYMBOL(nasd_atomic_add64);
NASD_EXPORT_SYMBOL(nasd_atomic_sub64);
NASD_EXPORT_SYMBOL(nasd_atomic_inc64);
NASD_EXPORT_SYMBOL(nasd_atomic_add_timespec);

NASD_EXPORT_SYMBOL(nasd_sys_copyin);
NASD_EXPORT_SYMBOL(nasd_sys_copyout);

NASD_EXPORT_SYMBOL(nasd_sys_wire_buf);
NASD_EXPORT_SYMBOL(nasd_sys_unwire_buf);

NASD_EXPORT_SYMBOL(nasd_linux_set_kpdev_support);
NASD_EXPORT_SYMBOL(nasd_linux_set_drive_launch);
NASD_EXPORT_SYMBOL(nasd_linux_set_edrfs_launch);

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
NASD_EXPORT_SYMBOL(nasd_dce_direct_bind_to_server);
NASD_EXPORT_SYMBOL(nasd_dce_direct_unbind_server);
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#if NASD_SECURITY_PRINT_STATS > 0
NASD_EXPORT_SYMBOL(nasd_SHA1_print_stats);
NASD_EXPORT_SYMBOL(nasd_SHA1_init_stats);
NASD_EXPORT_SYMBOL(nasd_SHA1_zero_stats);
NASD_EXPORT_SYMBOL(nasd_HMAC_print_stats);
NASD_EXPORT_SYMBOL(nasd_HMAC_init_stats);
#endif /* NASD_SECURITY_PRINT_STATS > 0 */
NASD_EXPORT_SYMBOL(SHA1_Init);
NASD_EXPORT_SYMBOL(SHA1_Update);
NASD_EXPORT_SYMBOL(SHA1_Transform);
NASD_EXPORT_SYMBOL(SHA1_Final);
NASD_EXPORT_SYMBOL(HMAC_SHA1_Init);
NASD_EXPORT_SYMBOL(HMAC_SHA1_Update);
NASD_EXPORT_SYMBOL(HMAC_SHA1_Final);

#if NASD_COMMON_TEST > 0
NASD_EXPORT_SYMBOL(nasd_atomic_test);
#endif /* NASD_COMMON_TEST > 0 */


#include <nasd/nasd_linux_common_marshall.h> /* automatically generated */
					/* from include/nasd/nasd_marshall.h */
					/* look in NASD.tmpl for how */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
