/*
 * nasd_security_cl.h
 *
 * Definitions for client security module.
 *
 * Author: Howard Gobioff
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_SECURITY_CL_H_
#define _NASD_SECURITY_CL_H_ 

#include <nasd/nasd_options.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_pdrive_client.h>

void nasd_pack_args(
		    nasd_drive_handle_t handle,
		    nasd_security_param_t *sec_param,
		    nasd_capability_t *capability,
		    void *args,
		    nasd_security_param_otw_t sec_param_otw,
		    nasd_capability_otw_t capability_otw,
		    nasd_digest_nonce_otw_t digest_otw,
		    void *args_otw,
		    int args_otw_len,
		    void (*marshall_fn)(),
		    nasd_iv_t icv,
		    nasd_key_t op_key,
		    nasd_security_context_t *context);
nasd_status_t nasd_unpack_res(
			      nasd_drive_handle_t handle,
			      nasd_security_param_t *sec_param,
			      nasd_capability_t *capability,
			      void *res_otw,
			      int res_otw_len,
			      nasd_digest_nonce_otw_t digest_otw,
			      void *res,
			      void (*unmarshall_fn)(),
			      nasd_iv_t icv,
			      nasd_key_t op_key,
			      nasd_security_context_t *context);
nasd_status_t nasd_sec_verify_res(
				  nasd_drive_handle_t handle,
				  nasd_security_param_t *sec_param,
				  nasd_capability_t *capability,
				  nasd_digest_nonce_otw_t digest_otw,
				  void *res_otw,
				  int res_otw_len,
				  nasd_key_t op_key,
				  nasd_security_context_t *context);

#endif /* !_NASD_SECURITY_CL_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
