/*
 * nasd_edrfs_pipe.h
 *
 * Structures and definitions for pipes with EDRFS
 *
 * Authors: Jim Zelenka, Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_EDRFS_PIPE_H_
#define _NASD__NASD_EDRFS_PIPE_H_

typedef struct nasd_edrfs_readdir_pipe_state_s {
  nasd_edrfs_dirent_t      *dir_buf;
  nasd_edrfs_dirent_otw_t   partial_buf;
  unsigned int              dir_buf_ents;        /* dirent size, not byte offset. */
  unsigned int              dir_buf_ents_filled; /* dirent offset, not byte offset. */
  unsigned int              partial_buf_offset;  /* byte offset */
  unsigned int              dir_ents_pushed;     /* number of ents pushed */
} nasd_edrfs_readdir_pipe_state_t;

nasd_status_t
nasd_copipe_readdir_push(void *state_arg, void *buf, nasd_len_t in_len,
                         nasd_byte_t *ign1, nasd_byte_t *ign2, int *ign3);

#endif /* !_NASD__NASD_EDRFS_PIPE_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
