/*
 * nasd_edrfs_client.h
 *
 * Include for EDRFS clients.
 *
 * Authors: Jim Zelenka, Nat Lanza
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_EDRFS_CLIENT_H_
#define _NASD__NASD_EDRFS_CLIENT_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_shutdown.h>
#include <nasd/nasd_pipe.h>
#include <nasd/nasd_pdrive_client.h> /* errors and handle types */
#include <nasd/nasd_edrfs_types.h>
#include <nasd/nasd_edrfs_server.h>
#include <nasd/nasd_edrfs_pipe.h>

typedef  struct nasd_edrfs_default_bindings_s   nasd_edrfs_default_bindings_t;
typedef  struct nasd_edrfs_handle_s            *nasd_edrfs_handle_t;
typedef  struct nasd_edrfscli_rpcmod_tab_s      nasd_edrfscli_rpcmod_tab_t;

#define NASD_EDRFSCLI_ERROR_STRING_LEN 160
typedef char nasd_edrfscli_error_string_t[NASD_EDRFSCLI_ERROR_STRING_LEN];

#define nasd_edrfscli_error_string(_handle_,_status_,_str_) \
  _nasd_edrfscli_error_string(_handle_,_status_,_str_,__FILE__,__LINE__)

/*
 * init/shutdown
 */
nasd_status_t nasd_edrfscli_real_init(void);
void nasd_edrfscli_real_shutdown(void);
void nasd_edrfscli_sys_init(void);
nasd_status_t nasd_edrfscli_init(void);
void nasd_edrfscli_shutdown(void);

/*
 * Switch table types
 */

typedef nasd_status_t (*nasd_edrfscli_init_t)(
  nasd_shutdown_list_t  *sl);

typedef nasd_status_t (*nasd_edrfscli_bind_t)(
  nasd_edrfs_handle_t   handle,
  char                 *server_name,
  char                 *portnum,
  int                   binding_type,
  void                 *binding_param,
  int                   binding_param_len);

typedef nasd_status_t (*nasd_edrfscli_unbind_t)(
  nasd_edrfs_handle_t  handle);

typedef void (*nasd_edrfscli_null_t)(
  nasd_edrfs_handle_t   handle,
  nasd_res_t           *res,
  nasd_rpc_status_t    *status);

typedef void (*nasd_edrfscli_mount_t)(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_mount_args_t  *in_args,
  nasd_edrfs_mount_res_t   *out_res,
  nasd_rpc_status_t        *out_status);

typedef void (*nasd_edrfscli_fsstat_t)(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_fsstat_args_t  *in_args,
  nasd_edrfs_fsstat_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_edrfscli_fsinfo_t)(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_fsinfo_args_t  *in_args,
  nasd_edrfs_fsinfo_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_edrfscli_lookup_otw_provided_t)(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_lookup_args_t  *in_args,
  nasd_edrfs_lookup_res_t   *out_res,
  nasd_otw_base_t           *args_otw_p,
  nasd_otw_base_t           *res_otw_p,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_edrfscli_lookup_t)(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_lookup_args_t  *in_args,
  nasd_edrfs_lookup_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_edrfscli_readdir_t)(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_readdir_args_t  *in_args,
  nasd_edrfs_dirent_t        *out_entries,
  nasd_edrfs_readdir_res_t   *out_res,
  nasd_rpc_status_t          *op_status);

typedef void (*nasd_edrfscli_access_t)(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_access_args_t  *in_args,
  nasd_edrfs_access_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_edrfscli_setattr_t)(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_setattr_args_t  *in_args,
  nasd_edrfs_setattr_res_t   *out_res,
  nasd_rpc_status_t          *out_status);

typedef void (*nasd_edrfscli_create_otw_provided_t)(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_create_args_t  *in_args,
  nasd_edrfs_create_res_t   *out_res,
  nasd_otw_base_t           *args_otw_p,
  nasd_otw_base_t           *res_otw_p,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_edrfscli_create_t)(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_create_args_t  *in_args,
  nasd_edrfs_create_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_edrfscli_symlink_t)(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_symlink_args_t  *in_args,
  nasd_edrfs_symlink_res_t   *out_res,
  nasd_rpc_status_t          *out_status);

typedef void (*nasd_edrfscli_remove_t)(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_remove_args_t  *in_args,
  nasd_edrfs_remove_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_edrfscli_mkdir_t)(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_mkdir_args_t  *in_args,
  nasd_edrfs_mkdir_res_t   *out_res,
  nasd_rpc_status_t        *out_status);

typedef void (*nasd_edrfscli_rmdir_t)(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_rmdir_args_t  *in_args,
  nasd_edrfs_rmdir_res_t   *out_res,
  nasd_rpc_status_t        *out_status);

typedef void (*nasd_edrfscli_newcookie_t)(
  nasd_edrfs_handle_t           handle,
  nasd_edrfs_newcookie_args_t  *in_args,
  nasd_edrfs_newcookie_res_t   *out_res,
  nasd_rpc_status_t            *out_status);

typedef void (*nasd_edrfscli_rename_t)(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_rename_args_t  *in_args,
  nasd_edrfs_rename_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

typedef void (*nasd_edrfscli_getstats_t)(
  nasd_edrfs_handle_t          handle,
  nasd_edrfs_getstats_res_t   *out_res,
  nasd_rpc_status_t           *out_status);

typedef void (*nasd_edrfscli_resetstats_t)(
  nasd_edrfs_handle_t          handle,
  nasd_res_t                  *out_res,
  nasd_rpc_status_t           *out_status);

typedef void (*nasd_edrfscli_xlate_error_t)(
  nasd_edrfs_handle_t     handle,
  nasd_rpc_status_t       status,
  nasd_error_string_t     str,
  char                   *file,
  int                     line);

struct nasd_edrfscli_rpcmod_tab_s {
  nasd_edrfscli_init_t                  init;
  nasd_status_t                         init_status;

  nasd_edrfscli_bind_t                  bind;
  nasd_edrfscli_unbind_t                unbind;

  nasd_edrfscli_null_t                  null;
  nasd_edrfscli_mount_t                 mount;
  nasd_edrfscli_fsstat_t                fsstat;
  nasd_edrfscli_fsinfo_t                fsinfo;
  nasd_edrfscli_lookup_t                lookup;
  nasd_edrfscli_readdir_t               readdir;
  nasd_edrfscli_access_t                access;
  nasd_edrfscli_setattr_t               setattr;
  nasd_edrfscli_create_t                create;
  nasd_edrfscli_symlink_t               symlink;
  nasd_edrfscli_remove_t                remove;
  nasd_edrfscli_mkdir_t                 mkdir;
  nasd_edrfscli_rmdir_t                 rmdir;
  nasd_edrfscli_newcookie_t             newcookie;
  nasd_edrfscli_rename_t                rename;
  nasd_edrfscli_getstats_t              getstats;
  nasd_edrfscli_resetstats_t            resetstats;

  nasd_edrfscli_lookup_otw_provided_t   lookup_otw_provided;
  nasd_edrfscli_create_otw_provided_t   create_otw_provided;

  nasd_edrfscli_xlate_error_t           xlate_error;

  int                                   binding_type;
  char                                 *name;
  int                                   spec_size;

  nasd_edrfscli_rpcmod_tab_t           *next;
};

/*
 * handle management
 */
extern nasd_status_t nasd_bind_to_edrfs_server(char *servername, char *portnum,
  int binding_type, void *binding_param, int binding_param_len,
  nasd_edrfs_handle_t *handle);

extern nasd_status_t nasd_unbind_edrfs_server(nasd_edrfs_handle_t *handle);

struct nasd_edrfs_default_bindings_s {
  int  *bindings;
  int   nbindings;
};

extern nasd_edrfs_default_bindings_t *nasd_edrfs_default_bindings;

/*
 * !!! note that nasd_edrfs_handle_t is a pointer
 * to the structure, not the structure itself, which
 * is not the NASD standard. This is for dealing with
 * older client code, and code which isn't aware of the
 * structured nature of this type. This also allows
 * NULL/non-NULL checks, and lets us more easily pass
 * pointers to the structure on the stack without
 * changing legacy code.
 */
struct nasd_edrfs_handle_s {
  int                          type;
  void                        *rpc_specific_handle;
  int                          rpc_specific_handle_size;
  nasd_edrfscli_rpcmod_tab_t  *rpc_tab;
  nasd_edrfs_handle_t          next;
  nasd_edrfs_handle_t          prev;
};

/*
 * module management
 */
extern nasd_status_t nasd_edrfscli_mods_init(nasd_shutdown_list_t *sl);

extern void nasd_edrfscli_mods_load();

extern void nasd_edrfscli_mod_register(nasd_edrfscli_rpcmod_tab_t *tab,
  int counter_lock_held);
extern void nasd_edrfscli_mod_unregister(nasd_edrfscli_rpcmod_tab_t *tab,
  int counter_lock_held);

/*
 * RPC error wrappers
 */
extern char *_nasd_edrfscli_error_string(nasd_edrfs_handle_t handle,
  nasd_rpc_status_t status, nasd_edrfscli_error_string_t str,
  char *file, int line);

/*
 * RPC wrappers
 */

extern void nasd_edrfscli_null(nasd_edrfs_handle_t handle,
  nasd_status_t *nasd_status, nasd_rpc_status_t *status);

extern void nasd_edrfscli_mount(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_mount_args_t  *in_args,
  nasd_edrfs_mount_res_t   *out_res,
  nasd_rpc_status_t        *out_status);

extern void nasd_edrfscli_fsstat(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_fsstat_args_t  *in_args,
  nasd_edrfs_fsstat_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfscli_fsinfo(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_fsinfo_args_t  *in_args,
  nasd_edrfs_fsinfo_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfscli_lookup_otw_provided(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_lookup_args_t  *in_args,
  nasd_edrfs_lookup_res_t   *out_res,
  nasd_otw_base_t           *args_otw_p,
  nasd_otw_base_t           *res_otw_p,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfscli_lookup(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_lookup_args_t  *in_args,
  nasd_edrfs_lookup_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfscli_readdir(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_readdir_args_t  *in_args,
  nasd_edrfs_dirent_t        *out_entries,
  nasd_edrfs_readdir_res_t   *out_res,
  nasd_rpc_status_t          *op_status);

extern void nasd_edrfscli_access(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_access_args_t  *in_args,
  nasd_edrfs_access_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfscli_setattr(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_setattr_args_t  *in_args,
  nasd_edrfs_setattr_res_t   *out_res,
  nasd_rpc_status_t          *out_status);

extern void nasd_edrfscli_create_otw_provided(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_create_args_t  *in_args,
  nasd_edrfs_create_res_t   *out_res,
  nasd_otw_base_t           *args_otw_p,
  nasd_otw_base_t           *res_otw_p,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfscli_create(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_create_args_t  *in_args,
  nasd_edrfs_create_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfscli_symlink(
  nasd_edrfs_handle_t         handle,
  nasd_edrfs_symlink_args_t  *in_args,
  nasd_edrfs_symlink_res_t   *out_res,
  nasd_rpc_status_t          *out_status);

extern void nasd_edrfscli_remove(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_remove_args_t  *in_args,
  nasd_edrfs_remove_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfscli_mkdir(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_mkdir_args_t  *in_args,
  nasd_edrfs_mkdir_res_t   *out_res,
  nasd_rpc_status_t        *out_status);

extern void nasd_edrfscli_rmdir(
  nasd_edrfs_handle_t       handle,
  nasd_edrfs_rmdir_args_t  *in_args,
  nasd_edrfs_rmdir_res_t   *out_res,
  nasd_rpc_status_t        *out_status);

extern void nasd_edrfscli_newcookie(
  nasd_edrfs_handle_t           handle,
  nasd_edrfs_newcookie_args_t  *in_args,
  nasd_edrfs_newcookie_res_t   *out_res,
  nasd_rpc_status_t            *out_status);

extern void nasd_edrfscli_rename(
  nasd_edrfs_handle_t        handle,
  nasd_edrfs_rename_args_t  *in_args,
  nasd_edrfs_rename_res_t   *out_res,
  nasd_rpc_status_t         *out_status);

extern void nasd_edrfscli_getstats(
  nasd_edrfs_handle_t          handle,
  nasd_edrfs_getstats_res_t   *out_res,
  nasd_rpc_status_t           *out_status);

extern void nasd_edrfscli_resetstats(
  nasd_edrfs_handle_t   handle,
  nasd_res_t           *out_res,
  nasd_rpc_status_t    *out_status);

#ifdef DEC_OSF
#include <nasd/dux/nasd_edrfs_client_dux.h>
#endif /* DEC_OSF */

#endif /* !_NASD__NASD_EDRFS_CLIENT_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
