/*
 * nasd_linux_platform.h
 *
 * Authors: Jim Zelenka, Sean Levy
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_LINUX_PLATFORM_H_
# define _NASD__NASD_LINUX_PLATFORM_H_

# ifdef KERNEL
#  ifndef __KERNEL__
#   define __KERNEL__
#  endif /* __KERNEL__ */
#  ifndef MODULE
#   define MODULE
#  endif /* MODULE */
#if 0
#  ifndef MODVERSIONS
#   define MODVERSIONS
#  endif /* MODVERSIONS */
#endif /* 0 */
#  ifndef EXPORT_SYMTAB
#   define EXPORT_SYMTAB
#  endif /* EXPORT_SYMTAB */

#  include <linux/config.h>
#  include <linux/kernel.h>
#  include <linux/mm.h>

/* A few functions that a lot of code in NASD presumes it has in the kernel
   aren't there in Linux, so let's try a macrological fix... */
asmlinkage int printf(const char *fmt, ...) /* in nasd_linux_basic.c */
     __attribute__ ((format (printf, 1, 2)));
asmlinkage int nasd_srv(int cmd, void *arg);

# endif /* KERNEL */

# if defined(__LANGUAGE_C__) && defined(KERNEL)
#  if (NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE)
#   define _SELECTBITS_H 666            /* THE D3VIL!110911 m4D3 m33 d00 1+! */
#   define _SYS_SELECT_H 666
#   define _SYS_TIME_H   666
#   define _SYS_TYPES_H  666
#   define _SOCKETBITS_H 666
#   define _NETINET_IN_H 666
#   define _FCNTLBITS_H  666
#   include <linux/time.h>               /* preempt sys/select.h */
#   include <linux/posix_types.h>        /* no, really, i hate you to death */
#   define ssize_t __ssize_t
#   undef __NFDBITS
#   undef __FDMASK
#   undef __BIT_TYPES_DEFINED__
#   include <gnu/types.h>                /* i hate you milkman glibc */
typedef unsigned long long int u_quad_t;
#  endif /* NASD_RPC_PACKAGE == DCE */
#  define KERNEL_STACK_SIZE      (1024*100) /* XXX WRONG WRONG WRONG */
#  include <linux/vmalloc.h>
#  define NASD_LINUX_KERNEL_PRINTF_BUF_LEN 2048
/*#  include <asm/smplock.h>*/
# endif /* C && KERNEL  */

#ifdef __LANGUAGE_C__
#ifndef KERNEL
#define nasd_printf printf
#else /* !KERNEL */
extern int nasd_printf(const char *fmt, ...);
#endif /* !KERNEL */
#endif /* __LANGUAGE_C__ */

# if __i386__
#  ifdef KERNEL
#   define nasd_int64cast(_n_)   _n_##LL
#   define nasd_uint64cast(_n_)  _n_##ULL
#   define NASD_64s_FMT          "Qd"
#   define NASD_64u_FMT          "Qu"
#   define NASD_64x_FMT          "Qx"
#   define NASD_64X_FMT          "QX"
#   define NASD_ID_FMT           "016Qx"
#  else /* !KERNEL *//
#   define nasd_int64cast(_n_)   _n_##LL
#   define nasd_uint64cast(_n_)  _n_##ULL
#   define NASD_64s_FMT          "Ld"
#   define NASD_64u_FMT          "Lu"
#   define NASD_64x_FMT          "Lx"
#   define NASD_64X_FMT          "LX"
#   define NASD_ID_FMT           "016Lx"
#  endif /* KERNEL */
# endif /* __i386__ */

# if __alpha
#  define nasd_int64cast(_n_)   _n_##L
#  define nasd_uint64cast(_n_)  _n_##UL
#  define NASD_64s_FMT          "ld"
#  define NASD_64u_FMT          "lu"
#  define NASD_64x_FMT          "lx"
#  define NASD_64X_FMT          "lX"
#  define NASD_ID_FMT           "016lx"
# endif /* __alpha */

typedef const void * nasd_qsort_arg_type_t;

# define NASD_INLINE __inline

#endif /* !_NASD__NASD_LINUX_PLATFORM_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
