/*
 * nasd_dux_timeout_kernel.h
 *
 * Structures and definitions for NASD timeout mechanism
 * inside the dux kernel.
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_DUX_TIMEOUT_KERNEL_H_
#define _NASD__NASD_DUX_TIMEOUT_KERNEL_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_threadstuff.h>

typedef struct nasd_timeout_s  nasd_timeout_t;
typedef nasd_uint64            nasd_timeout_handle_t;

#define NASD_TIMEOUT_HANDLE_NULL 0

struct nasd_timeout_s {
  nasd_timespec_t          tm_time;
  nasd_timespec_t          tm_interval;
  nasd_timeout_status_t    tm_status;
  nasd_timeout_handle_t    tm_handle;
  void                   (*tm_proc)(nasd_timeout_handle_t, void *, void *);
  void                    *tm_arg1;
  void                    *tm_arg2;
  nasd_timeout_t          *tm_bprev;
  nasd_timeout_t          *tm_bnext;
  nasd_timeout_t          *tm_prev;
  nasd_timeout_t          *tm_next;
};

#endif /* !_NASD__NASD_DUX_TIMEOUT_KERNEL_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
