/*
 * nasd_dux_mem.h
 *
 * dux-specific memory allocation
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_DUX_MEM_H_
#define _NASD__NASD_DUX_MEM_H_

#ifdef KERNEL
#include <sys/types.h>
#include <io/common/iotypes.h>
#include <sys/malloc.h>

extern vm_map_t kernel_map;

#define NASD_SYS_MALLOC(_p_,_cast_,_size_) { \
  kern_return_t ret; \
  vm_offset_t kaddr; \
  if ((_size_)%PAGE_SIZE == 0) { \
    ret = vm_allocate(kernel_map, &kaddr, _size_, TRUE); \
    if (ret != KERN_SUCCESS) { \
      _p_ = _cast_ 0; \
    } \
    else { \
      _p_ = _cast_ kaddr; \
    } \
  } \
  else { \
    _p_ = _cast_ malloc((u_long)_size_, BUCKETINDEX(_size_), M_DEVBUF, M_WAITOK); \
  } \
}

#define NASD_SYS_VALLOC(_p_,_cast_,_size_) NASD_SYS_MALLOC(_p_,_cast_,_size_)

#define NASD_SYS_FREE(_p_,_size_) { \
  if ((_size_)%PAGE_SIZE == 0) { \
    vm_deallocate(kernel_map, (vm_offset_t)(_p_), _size_); \
  } \
  else { \
    free((void *)(_p_), M_DEVBUF); \
  } \
}

#endif /* KERNEL */

#endif /* !_NASD__NASD_DUX_MEM_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
