/*
 * nasd_dux_general_simple.h
 *
 * Generic definitions useful to pretty much all NASD code
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_DUX_GENERAL_SIMPLE_H_
#define _NASD__NASD_DUX_GENERAL_SIMPLE_H_

#if !defined(KERNEL) && NASD_NOASSERT == 0
#include <assert.h>
#endif /* !KERNEL && NASD_NOASSERT == 0 */

#ifndef KERNEL
#include <stdio.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#endif /* !KERNEL */

#ifdef _KERNEL
#include <sys/kernel.h>
#define NULL 0L
#endif /* _KERNEL */

#include <sys/time.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/uio.h>

#ifndef KERNEL

#include <stdio.h>

#if NASD_NOASSERT == 0
#define NASD_ASSERT(_x_) { \
  if (!(_x_)) { \
    printf("Assertion check at file %s line %d\n", __FILE__, __LINE__); \
    printf("Assertion failed: %s\n", NASD_STRING(_x_)); \
    fflush(stdout); \
    abort(); \
    exit(1); \
  } \
}
#else /* NASD_NOASSERT == 0 */
#define NASD_ASSERT(x)   {/*noop*/}
#endif /* NASD_NOASSERT == 0 */
#define NASD_PANIC() { \
  printf("D'oh! Fatal error file %s line %d\n", __FILE__, __LINE__); \
  fflush(stdout); \
  fprintf(stderr, "D'oh! Fatal error file %s line %d\n", __FILE__, __LINE__); \
  fflush(stderr); \
  abort(); \
  exit(1); \
}

#endif /* !KERNEL */

#ifdef KERNEL

#ifdef NASD_ASSERT
#undef NASD_ASSERT
#endif /* NASD_ASSERT */

#define NASD_PANIC() { \
  sprintf(nasd_panicbuf, "Fatal NASD error file %s line %d", \
    __FILE__, __LINE__); \
  printf("%s\n", nasd_panicbuf); \
  panic(nasd_panicbuf); \
}

#define NASD_PANICBUF_LEN 2048
extern char nasd_panicbuf[NASD_PANICBUF_LEN];

#if NASD_NOASSERT == 0
#define NASD_ASSERT(_x_) { \
  if (!(_x_)) { \
    sprintf(nasd_panicbuf, \
        "NASD error at line %d file %s (failed asserting %s)", \
        __LINE__, __FILE__, #_x_); \
    printf("%s\n", nasd_panicbuf); \
    thread_block(); \
    panic(nasd_panicbuf); \
  } \
}
#else /* NASD_NOASSERT == 0 */
#define NASD_ASSERT(x) {/*noop*/}
#endif /* NASD_NOASSERT == 0 */

#endif /* KERNEL */

#define NASD_MAXPATHLEN  MAXPATHLEN

#define NASD_UIO_MAXIOV UIO_MAXIOV

#endif /* !_NASD__NASD_DUX_GENERAL_SIMPLE_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
