/*
 * nasd_linux_gethostbyname.c
 *
 * gethostbyname() front-end for linux userland
 *
 * Authors: Marc Unangst, Jim Zelenka, Sean Levy
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_sys.h>
#include <nasd/nasd_general.h>
#include <nasd/nasd_threadstuff.h>
#include <fcntl.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <ctype.h>

nasd_status_t
nasd_gethostbyname_r(
  char            *hostname,
  struct hostent  *hep)
{
  struct hostent *lhep;
  /* XXXmju - I have no idea if this is an appropriate size, but there
     is no system constant or documented guideline.  It should be "big
     enough." */
  char hd[1024];
  int herr, ret;
  int rc;

  rc = NASD_SUCCESS;
  bzero((char *)&hd, sizeof(hd));
#if __GLIBC__
  ret = gethostbyname_r(hostname, hep, hd, sizeof(hd), &lhep, &herr);
  if (ret) {
    rc = NASD_FAIL;
  }
#else /* __GLIBC__ */
  lhep = gethostbyname_r(hostname, hep, hd, sizeof(hd), &herr);
  if (lhep == NULL) {
    rc = NASD_FAIL;
  }
#endif /* __GLIBC__ */
  return rc;
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
