/*
 * nasd_dux_addts.s
 *
 * Atomically add nasd timespecs
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifdef __LANGUAGE_C__
#undef __LANGUAGE_C__
#endif /* __LANGUAGE_C__ */
#include <nasd/nasd_options.h>

    .globl  nasd_atomic_add_timespec
    .ent    nasd_atomic_add_timespec 2
nasd_atomic_add_timespec:
    ldgp    $gp, 0($27)
    lda     $sp, -32($sp)
    .frame  $sp, 32, $26, 0

1:
    ldq_l   $1, 0($16)
    stq     $1, 0($sp)

    ldq     $18, 0($sp)

    ldl     $2, 0($sp)
    ldl     $3, 0($17)
    addl    $2, $3, $4
    stl     $4, 0($sp)

    ldl     $5, 4($sp)
    ldl     $6, 4($17)
    addl    $5, $6, $7
    stl     $7, 4($sp)

    bis     $7, $7, $0
    cmpult  $0, 1000000000, $8
    bne     $8, $32

    addl    $0, -1000000000, $22
    stl     $22, 4($sp)

    addl    $4, 1, $23
    stl     $23, 0($sp)

$32:
    ldq     $24, 0($sp)
    stq_c   $24, 0($16)

    beq     $24, 2f

    bis     $18, $18, $0

    lda     $sp, 32($sp)
    ret     $31, ($26), 1
2:
    br      $31,1b

.end  nasd_atomic_add_timespec




#if 0

/*
 * Derived from:
 */

unsigned long
nasd_atomic_add_timespec(
  unsigned long  *tsp1,
  unsigned long  *tsp2)
{
  unsigned int *itsp1, *itsp2;
  unsigned long ots, oots;

  oots = *tsp1;

  itsp1 = (unsigned int *)&oots;
  itsp2 = (unsigned int *)tsp2;

  ots = oots;

  itsp1[0] += itsp2[0];
  itsp1[1] += itsp2[1];
  if (itsp1[1] >= 1000000000) {
    itsp1[1] -= 1000000000;
    itsp1[0]++;
  }

  *tsp1 = oots;

  return(ots);
}
#endif

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
