/*
 * _sio_iodesc.c
 *
 * Internal I/O Descriptor Processing (worker thread)
 *
 * Authors: Khalil Amiri, CMU SCS/ECE, July 18 1997
 *          Sean Levy, CMU SCS, July 1999
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#include "_sio_internal.h"

sio_return_t
_sio_iodesc_create(struct _sio_fdesc *fdesc, int flags, 
    const sio_file_io_list_t *fl, sio_count_t fllen,
    const sio_mem_io_list_t *ml, sio_count_t mllen,
    struct _sio_iodesc **iodescp)
{
	struct _sio_iodesc *iodesc;

	/* XXX sanity check file & memory lists */

	iodesc = _sio_rcobj_create(sizeof *iodesc);
	iodesc->iod_flags = flags;
	iodesc->iod_transferlen = 0;
	iodesc->iod_result = SIO_SUCCESS;

	iodesc->iod_fdesc = fdesc;
	_sio_rcobj_ref(fdesc);

	iodesc->iod_fl = fl;
	iodesc->iod_fllen = fllen;
	iodesc->iod_ml = ml;
	iodesc->iod_mllen = mllen;

	*iodescp = iodesc;
	return (SIO_SUCCESS);
}

void
_sio_iodesc_doio(nasd_threadarg_t iodescv)
{
	struct _sio_iodesc *iodesc = iodescv;
	struct _sio_mntpoint *mp;
	void *mp_cookie;

	mp = iodesc->iod_fdesc->fd_mp;
	mp_cookie = iodesc->iod_fdesc->fd_mp_cookie;

	(*mp->mnt_doio)(mp_cookie, iodesc);
}

void
_sio_iodesc_collect_status(struct _sio_iodesc *iodesc,
	sio_transfer_len_t *transferlenp, sio_return_t *resultp)
{

	_sio_rcobj_waitrefcnt(iodesc, 1);

	if ((iodesc->iod_flags & _SIO_IOD_CANCELED) != 0) {
		*transferlenp = 0;
		*resultp = SIO_ERR_IO_CANCELED;
	} else {
		*transferlenp = iodesc->iod_transferlen;
		*resultp = iodesc->iod_result;
	}
	_sio_iodesc_destroy(iodesc);
}

void
_sio_iodesc_destroy(struct _sio_iodesc *iodesc)
{

	_sio_rcobj_unref(iodesc->iod_fdesc);
	_sio_rcobj_destroy(iodesc);
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
