/*
 * nasd_cheops_cl_drive.h
 *
 * cheops drive access routines
 *
 * Authors: Khalil Amiri, CMU SCS/ECE, July 18 1997
 *          Sean Levy, CMU SCS, July 1999
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#ifndef _NASD_CHEOPS_CL_DRIVE_H_
#define _NASD_CHEOPS_CL_DRIVE_H_

#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_pdrive.h>
#include <nasd/nasd_pdrive_client.h>
#include <nasd/nasd_general.h>

#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_common.h>
#include <nasd/nasd_cheops_cache.h>
#include <nasd/nasd_cheops_mgr_structs.h>
#include <nasd/nasd_cheops_mgr_common.h>

int
_nasd_cheops_null_dr(int di, nasd_status_t *nasd_status, nasd_rpc_status_t *status);

int
_nasd_cheops_null_h_dr(nasd_drive_handle_t h, nasd_status_t *nasd_status, nasd_rpc_status_t *status);

/* XXXmju: this does not seem to be defined anywhere in the Cheops source. */
int
_nasd_cheops_part_create_dr(int di, nasd_partnum_t in_partnum, 
			    nasd_key_t in_key, int in_nblocks,
			    nasd_status_t *nasd_status, nasd_rpc_status_t *status);
int
_nasd_cheops_part_create_h_dr(nasd_drive_handle_t h, nasd_partnum_t in_partnum, 
			      nasd_key_t in_key, int in_nblocks,
			      nasd_status_t *nasd_status, nasd_rpc_status_t *status);
int
_nasd_cheops_create_dr(int di, nasd_partnum_t in_partnum,
		      nasd_key_t req_key, nasd_identifier_t *out_identifier,
		      nasd_status_t *nasd_status, nasd_rpc_status_t *status);

int
_nasd_cheops_create_h_dr(nasd_drive_handle_t h, nasd_partnum_t in_partnum,
		      nasd_key_t req_key, nasd_identifier_t *out_identifier,
		      nasd_status_t *nasd_status, nasd_rpc_status_t *status);

int 
_nasd_cheops_remove_dr(int di,  nasd_partnum_t partnum, 
		      nasd_key_t req_key, nasd_identifier_t in_identifier,
		      nasd_status_t *nasd_status, nasd_rpc_status_t *status);

int 
_nasd_cheops_remove_h_dr(nasd_drive_handle_t h,  nasd_partnum_t partnum, 
		      nasd_key_t req_key, nasd_identifier_t in_identifier,
		      nasd_status_t *nasd_status, nasd_rpc_status_t *status);

int 
_nasd_cheops_getattr_dr(int di, nasd_partnum_t partnum, 
		       nasd_key_t req_key, nasd_identifier_t in_id, 
		       nasd_attribute_t *out_attribute,
		       nasd_status_t *nasd_status, nasd_rpc_status_t *status);
int 
_nasd_cheops_getattr_h_dr(nasd_drive_handle_t h, nasd_partnum_t partnum, 
		       nasd_key_t req_key, nasd_identifier_t in_id, 
		       nasd_attribute_t *out_attribute,
		       nasd_status_t *nasd_status, nasd_rpc_status_t *status);

int
_nasd_cheops_setattr_dr(int di, nasd_partnum_t partnum, 
		       nasd_key_t req_key, nasd_identifier_t in_identifier, 
		       nasd_attribute_t *in_attribute,
		       nasd_status_t *nasd_status, nasd_rpc_status_t *status);

int
_nasd_cheops_setattr_h_dr(nasd_drive_handle_t h, nasd_partnum_t partnum, 
			  nasd_key_t req_key, nasd_identifier_t in_identifier, 
			  nasd_attribute_t *in_attribute,
			  nasd_status_t *nasd_status, nasd_rpc_status_t *status);

int
_nasd_cheops_read_dr(int di, nasd_partnum_t in_partnum, 
		    nasd_key_t req_key, nasd_identifier_t in_identifier,
		    nasd_byte_t *buf, nasd_offset_t in_offset, nasd_len_t in_len, 
		    nasd_uint64 bms_targ, nasd_len_t *out_len,
		    nasd_status_t *nasd_status, nasd_rpc_status_t *status);

int
_nasd_cheops_write_dr(int di, nasd_partnum_t in_partnum, 
		     nasd_key_t req_key, nasd_identifier_t in_identifier,
		     nasd_byte_t *buf, nasd_offset_t in_offset, nasd_len_t in_len, 
		     nasd_len_t *out_len, nasd_status_t *nasd_status, nasd_rpc_status_t *status);

int
_nasd_cheops_tswrite_dr(int di, nasd_partnum_t in_partnum, 
			nasd_key_t req_key, nasd_identifier_t in_identifier,
			nasd_byte_t *buf, nasd_offset_t in_offset, nasd_len_t in_len, nasd_host_tag_t host_tag,
			nasd_len_t *out_len, nasd_status_t *nasd_status, nasd_rpc_status_t *status);

#endif /*  _NASD_CHEOPS_CL_DRIVE_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
