/*
 * nasd_cheops_mgr_server.c
 *
 * Service routines for the CHEOPS storage manager
 */
/*
 * Copyright (c) 1996,1997,1998,1999 Carnegie Mellon University.
 * All rights reserved.
 *
 * Author: Khalil Amiri, CMU SCS/ECE, July 18 1997
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <stdio.h>
#include <stdlib.h>
#include <dce/dce_error.h>
#include <errno.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <malloc.h>

#include <nasd/nasd_general.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_common.h>
#include <nasd/nasd_cheops_mgr_common.h>
#include <nasd/nasd_cheops_mgr_structs.h>
#include <nasd/nasd_cheops_mgr.h>
#include <nasd/nasd_cheops_mgr_internal.h>

/* debugging */
#define NASD_CHEOPS_OP_DEBUG 1


void 
nasd_cheops_null_cm (handle_t         client_handle, 
                     nasd_status_t   *nasd_status,
                     error_status_t  *op_status)
{

  *nasd_status = 0;
  *op_status = 0;          /* always successful */
#if NASD_CHEOPS_OP_DEBUG > 0
  (cheops_Msg "Cheops storage manager: Handled %s\n","nasd_cheops_NULL_cm");
#endif /* CHEOPS_OP_DEBUG */
}

void
nasd_cheops_bs_create_cm (handle_t                     client_handle,
                          nasd_cookie_t                in_cookie,
                          nasd_cheops_bs_handle_t     *bs_handle,
                          nasd_status_t               *nasd_status,
                          error_status_t              *op_status)
{
  int  failures = 0;
	int  rc=0;                   
	nasd_cheops_qos_req_t qos_req; /* default qos struct */
	nasd_boolean_t do_qos = NASD_FALSE;

	rc = nasd_cheops_mgr_check_cookie (client_handle, in_cookie, 0,
                                     NASD_CHEOPS_OP_BS_CREATE); 
	if (rc) {
	  *nasd_status = NASD_AUTHCHECK_FAILED;
	  *op_status = 0;
	}
	bzero((char *)bs_handle, sizeof(nasd_cheops_bs_handle_t));
	rc = nasd_cheops_bs_create(do_qos, &qos_req, bs_handle); 
	if (rc) {
	  *nasd_status = rc;
	  *op_status = 0;
	}


out:
	*op_status = 0;
	*nasd_status=0;

#if NASD_CHEOPS_OP_DEBUG > 0
  (cheops_Msg "Cheops storage manager: Handled %s (new id=0x%"
   NASD_ID_FMT ")\n",
	 "nasd_cheops_BS_CREATE_cm", bs_handle->bsid);
#endif /* CHEOPS_OP_DEBUG */

}

void
nasd_cheops_bs_qos_create_cm (handle_t                     client_handle,
                              nasd_cookie_t                in_cookie,
                              nasd_cheops_qos_req_t        in_qos_req,
                              nasd_cheops_bs_handle_t     *bs_handle,
                              nasd_status_t               *nasd_status,
                              error_status_t              *op_status)
{
  int  failures = 0;
	int  rc=0;                   
	nasd_boolean_t do_qos = NASD_TRUE;

	rc = nasd_cheops_mgr_check_cookie (client_handle, in_cookie, 0,
                                     NASD_CHEOPS_OP_BS_CREATE); 
	if (rc) {
	  *nasd_status = NASD_AUTHCHECK_FAILED;
	  *op_status = 0;
	}
	bzero((char *)bs_handle, sizeof(nasd_cheops_bs_handle_t));
	rc = nasd_cheops_bs_create(do_qos, in_qos_req, bs_handle);
	if (rc) {
	  *nasd_status = rc;
	  *op_status = 0;
	  return;
	} 
out:
	*op_status = 0;
	*nasd_status=0;
#if NASD_CHEOPS_OP_DEBUG > 0
  (cheops_Msg "Cheops storage manager: Handled %s\n",
   "nasd_cheops_BS_QOSCREATE_cm");
#endif /* CHEOPS_OP_DEBUG */
}

void 
nasd_cheops_bs_lookup_cm(handle_t                        client_handle,
                         nasd_cookie_t                   in_cookie,
                         nasd_identifier_t               in_bsid,
                         nasd_cheops_bs_handle_t        *bs_handle,
                         nasd_status_t                  *nasd_status,
                         error_status_t                 *op_status)
{
  int rc;

	rc = nasd_cheops_mgr_check_cookie (client_handle, in_cookie, in_bsid,
                                     NASD_CHEOPS_OP_BS_LOOKUP);
	if (rc) {
	  *nasd_status = NASD_AUTHCHECK_FAILED;
	  *op_status = 0;
	}
	rc = nasd_cheops_bs_lookup(in_bsid, bs_handle); 
	if (rc) {
	  *nasd_status = rc;
	  *op_status = 0;
	} else {
	  *nasd_status = 0;
	  *op_status = 0;
	}
#if NASD_CHEOPS_OP_DEBUG > 0
  (cheops_Msg "Cheops storage manager: Handled %s(rc=%d)\n",
   "nasd_cheops_BS_LOOKUP_cm",rc);
#endif /* CHEOPS_OP_DEBUG */

}

void
nasd_cheops_bs_remove_cm (handle_t              client_handle,
                          nasd_cookie_t         in_cookie,
                          nasd_identifier_t     in_bsid,
                          nasd_status_t        *nasd_status,
                          error_status_t       *op_status)
{
  int  rc;
	
	rc = nasd_cheops_mgr_check_cookie (client_handle, in_cookie, in_bsid,
                                     NASD_CHEOPS_OP_BS_REMOVE);
	if (rc) {
	  *nasd_status = NASD_AUTHCHECK_FAILED;
	  *op_status = 0;
	}
	rc = nasd_cheops_bs_remove(in_bsid); 
	if (rc) {
	  *nasd_status = rc;
	  *op_status = 0;
	  return;
	} else {
	  *nasd_status = 0;
	  *op_status = 0;
	}
	return;
#if NASD_CHEOPS_OP_DEBUG > 0
  (cheops_Msg "Cheops storage manager: Handled %s\n",
   "nasd_cheops_BS_REMOVE_cm");
#endif /* CHEOPS_OP_DEBUG */
}

void
nasd_cheops_bs_getattr_cm(handle_t              client_handle,
                          nasd_cookie_t         in_cookie,
                          nasd_identifier_t     in_bsid,
                          nasd_attribute_t     *out_attr,
                          nasd_status_t        *nasd_status,
                          error_status_t       *op_status)
{
  int rc=0;

  rc = nasd_cheops_mgr_check_cookie (client_handle, in_cookie, in_bsid,
                                     NASD_CHEOPS_OP_BS_GETATTR);
	if (rc) {
	  *nasd_status = NASD_AUTHCHECK_FAILED;
	  *op_status = 0;
	}
	rc = nasd_cheops_bs_getattr(in_bsid, out_attr); 
	if (rc) {
	  *nasd_status = rc;
	  *op_status = 0;
	  return;
	}
	*nasd_status = 0;
	*op_status = 0; 
#if NASD_CHEOPS_OP_DEBUG > 0
  (cheops_Msg "Cheops storage manager: Handled %s\n",
   "nasd_cheops_BS_GETATTR_cm");
#endif /* CHEOPS_OP_DEBUG */
}

void
nasd_cheops_bs_setattr_cm(handle_t              client_handle,
                          nasd_cookie_t         in_cookie,
                          nasd_identifier_t     in_bsid,
                          nasd_attribute_t      in_attr,
                          nasd_status_t        *nasd_status,
                          error_status_t       *op_status)
{
  nasd_attribute_t out_attr;
	int rc;

  rc = nasd_cheops_mgr_check_cookie (client_handle, in_cookie, in_bsid,
                                     NASD_CHEOPS_OP_BS_SETATTR);
	if (rc) {
	  *nasd_status = NASD_AUTHCHECK_FAILED;
	  *op_status = 0;
	}
	rc = nasd_cheops_bs_setattr(in_bsid, in_attr);
	if (rc) {
	  *nasd_status = rc;
	  *op_status = 0;
	}
	*nasd_status = 0;
	*op_status = 0; 
#if NASD_CHEOPS_OP_DEBUG > 0
  (cheops_Msg "Cheops storage manager: Handled %s\n",
   "nasd_cheops_BS_SETATTR_cm");
#endif /* CHEOPS_OP_DEBUG */
};

void
nasd_cheops_bs_refresh_cm(handle_t                  client_handle,
                          nasd_cookie_t             in_cookie,
                          nasd_identifier_t         in_bsid,
                          /*nasd_chunk_t            in_chunkid,*/
                          nasd_cheops_bs_handle_t  *bs_handle,
                          nasd_status_t            *nasd_status,
                          error_status_t           *op_status)
{
  int rc=0;

  rc = nasd_cheops_mgr_check_cookie (client_handle, in_cookie, in_bsid,
                                     NASD_CHEOPS_OP_BS_LOOKUP);
	if (rc) {
	  *nasd_status = NASD_AUTHCHECK_FAILED;
	  *op_status = 0;
	}
	rc = nasd_cheops_bs_lookup(in_bsid, /* chunkid? */ bs_handle); /* FIX -- */
	if (rc) {
	  *nasd_status = rc;
	  *op_status = 0;
	  return;
	}
	*nasd_status = 0;
	*op_status = 0; 
#if NASD_CHEOPS_OP_DEBUG > 0
  (cheops_Msg "Cheops storage manager: Handled %s\n",
   "nasd_cheops_BS_REFRESH_cm");
#endif /* CHEOPS_OP_DEBUG */
}

void
nasd_cheops_dr_lookup_cm(handle_t                client_handle,
                         nasd_cookie_t           in_cookie,
                         nasd_disk_ident_t       in_drive_id,
                         nasd_cheops_cl_dinfo_t *out_drive_info,
                         nasd_status_t          *nasd_status,
                         error_status_t         *op_status)		   
{
  int rc=0;

  rc = nasd_cheops_mgr_check_cookie (client_handle, in_cookie, in_drive_id,
                                     NASD_CHEOPS_OP_DR_LOOKUP);
	if (rc) {
	  *nasd_status = NASD_AUTHCHECK_FAILED;
	  *op_status = 0;
	}
	rc = nasd_cheops_dr_lookup(in_drive_id, out_drive_info); 

	if (rc) {
	  *nasd_status = rc;
	  *op_status = 0;
	  return;
	} 	  
	*nasd_status = *op_status = 0;

#if NASD_CHEOPS_OP_DEBUG > 0
  (cheops_Msg "Cheops storage manager: Handled %s\n","nasd_cheops_DR_LOOKUP_cm");
#endif /* CHEOPS_OP_DEBUG */
}

void
nasd_cheops_mgr_lookup_cm(handle_t                    client_handle,
                          nasd_cookie_t               in_cookie,
                          nasd_identifier_t           in_bsid,
                          nasd_cheops_mgr_info_t     *out_mgr_info,
                          nasd_status_t              *nasd_status,
                          error_status_t             *op_status)		   
{
  int rc=0;

  rc = nasd_cheops_mgr_check_cookie (client_handle, in_cookie, in_bsid,
                                     NASD_CHEOPS_OP_MGR_LOOKUP);
	if (rc) {
	  *nasd_status = NASD_AUTHCHECK_FAILED;
	  *op_status = 0;
	}
	rc = nasd_cheops_mgr_lookup(in_bsid, out_mgr_info); 
	if (rc) {
	  *nasd_status = rc;
	  *op_status = 0;
	  return;
	}
	*nasd_status = 0;
	*op_status = 0;
#if CHEOPS_OP_DEBUG > 0
  (cheops_Msg "Cheops storage manager: Handled %s\n",
   "nasd_cheops_MGR_LOOKUP_cm");
#endif /* CHEOPS_OP_DEBUG */
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
