/*
 * nasd_cheops_cl_noraid.c
 *
 * NORAID access module
 */
/*
 * Copyright (c) 1996,1997,1998,1999 Carnegie Mellon University.
 * All rights reserved.
 *
 * Author: Khalil Amiri, CMU SCS/ECE, July 18 1997
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <sys/errno.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_common.h>
#include <nasd/nasd_cheops_raidmap.h>
#include <nasd/nasd_cheops_cache.h>
#include <nasd/nasd_cheops_ios.h>
#include <nasd/nasd_cheops_client_internal.h>

/*
 * XXX this should be fixed. It will not be correctly included
 * as a dependency on many platforms. Also, the relative path
 * thing makes it hard for alternatively-organized trees, and
 * just give up on including something like this in the kernel.
 */
#include "../cheops/shared/nasd_cheops_cl_drive.h"

#define NASD_CHEOPS_WRITE_DEBUG 0
/*#define NASD_CHEOPS_READ_DEBUG 1*/

int
_nasd_cheops_noraid_read(nasd_asm_t *a, nasd_len_t *out_len)
{
  int rc = 0;
	NASD_pda_t *pda;
	nasd_identifier_t ni;
	nasd_disk_ident_t di;
	nasd_uint64 bms;
	nasd_status_t nasd_status;
	nasd_rpc_status_t status;
	nasd_key_t req_key;
	nasd_partnum_t partnum;
	nasd_cheops_handle_t h;
	_nasd_cheops_cache_key_t in_key;
	_nasd_cheops_dr_handle_t dr_handle;

	if (a == NULL)
	  return EINVAL;	
	pda = &a->first_stripe_access->pda_list[0];
	if (pda->buf == NULL)
	  return EINVAL;

	ni = pda->data_obj_id.nasd_identifier;
	di = pda->data_obj_id.disk_identifier;

  /* lookup a handle for the target drive */
	partnum = 0;
	
	/* FIX -- get cookie from pda */
	bms = 0;
	rc = _nasd_cheops_read_dr(di, partnum, req_key, ni,
                            pda->buf, pda->start_address, pda->len, bms,
                            out_len, &nasd_status, &status);

	/*(cheops_Msg "in noraid read \n");*/
	_nasd_cheops_asm_freeall(a);

  return rc;
}

int
_nasd_cheops_noraid_write(nasd_asm_t *a, nasd_len_t *out_len)
{
  int rc = 0;
	NASD_pda_t *pda;
	nasd_identifier_t ni;
	nasd_disk_ident_t di;
	nasd_status_t nasd_status;
	nasd_rpc_status_t status;
	nasd_key_t req_key;
	nasd_partnum_t partnum;
	nasd_cheops_handle_t h;
	_nasd_cheops_cache_key_t in_key;
	_nasd_cheops_dr_handle_t dr_handle;

#if NASD_CHEOPS_WRITE_DEBUG > 0
  (cheops_Msg "noraid_write called\n");
#endif /* NASD_CHEOPS_WRITE_DEBUG > 0 */

	if (a == NULL)
	  return EINVAL;	
	pda = &a->first_stripe_access->pda_list[0];
	if (pda->buf == NULL )
	  rc = EINVAL;
  else {
    ni = pda->data_obj_id.nasd_identifier;
    di = pda->data_obj_id.disk_identifier;

    /* lookup a handle for the target drive */
    partnum = 0;	

    rc = _nasd_cheops_write_dr(di, partnum, req_key, ni,
                               pda->buf, pda->start_address, pda->len,
                               out_len, &nasd_status, &status);

    /*(cheops_Msg "in noraid write \n");*/
    _nasd_cheops_asm_freeall(a);
  }

#if NASD_CHEOPS_WRITE_DEBUG > 0
  (cheops_Msg "noraid_write done, rc=%d\n", rc);
#endif /* NASD_CHEOPS_WRITE_DEBUG > 0 */

	return rc;
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
