/*-
 * Copyright (c) 2015 Taylor R. Campbell
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include "attribute.h"
#include "err.h"

#include "eprintf.h"

unsigned attr_printflike(1, 2)
eprintf(const char *fmt, ...)
{
	va_list va;
	unsigned n;

	va_start(va, fmt);
	n = evprintf(fmt, va);
	va_end(va);

	return n;
}

unsigned attr_printflike(2, 3)
efprintf(FILE *file, const char *fmt, ...)
{
	va_list va;
	unsigned n;

	va_start(va, fmt);
	n = evfprintf(file, fmt, va);
	va_end(va);

	return n;
}

unsigned attr_printflike(1, 0)
evprintf(const char *fmt, va_list va)
{
	int n;

	n = vprintf(fmt, va);
	if (n < 0)
		err(1, "printf");

	return n;
}

unsigned attr_printflike(2, 0)
evfprintf(FILE *file, const char *fmt, va_list va)
{
	int n;

	n = vfprintf(file, fmt, va);
	if (n < 0)
		err(1, "fprintf");

	return n;
}

unsigned attr_printflike(2, 0)
evasprintf(char **ret, const char *fmt, va_list va)
{
	int n;

	n = vasprintf(ret, fmt, va);
	if (n < 0)
		errx(1, "Cannot allocate memory");

	return n;
}
