/*	$NetBSD$	*/

/*-
 * Copyright (c) 2015 Taylor R. Campbell
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _SYS_IOCTL_PB_H_
#define	_SYS_IOCTL_PB_H_

#include <pb.h>

#define	PB_IOCTL_HDRSIZE	16
#define	PB_IOCTL_HDR_NTYPE	8
#define	PB_IOCTL_HDR_REQ	"protoreq"
#define	PB_IOCTL_HDR_RES	"protores"
#define	PB_IOCTL_HDR_TRUNC	"protosiz"

int	ioctl_pb_init(int, unsigned long, struct pb_msg, struct pb_msg);
int	ioctl_pb(int, unsigned long, struct pb_msg, struct pb_msg);

#ifdef _KERNEL
struct plistref;

extern size_t pb_copyin_limit;

int	pb_copyin_init(struct plistref *, struct pb_msg);
int	pb_copyin(struct plistref *, struct pb_msg);
int	pb_copyout_destroy(struct plistref *, struct pb_msg);
int	pb_copyout(struct plistref *, struct pb_msg);
#endif

#endif	/* _SYS_IOCTL_PB_H_ */
