/* pgps -- pgraf low level driver for  NeXT postscript */
/* From Giorgio Caranti, Physics, University of Cordoba, Argentina */

/* This version has modifications made by David Raymond that throw
 * out the encapsulation part of the postscript and make it produce
 * an output suitable for a laser printer.  Output now comes out
 * on the standard output.
 */

#include <stdio.h>
#include <math.h>

#define XLO 0.
#define XHI 360.
#define YLO 0.
#define YHI 240.
#define XMAX 15.
#define YMAX 10.
#define CHARHT 0.35
#define CHARWDTH 0.22
#define DESCENT 0.2
#define DEL 0.05
#define ESC 27
#define MAXSTRING 100

float xold,yold,xnew,ynew;
int ltype1,lflag;

void pginit()

{
  /* tell world it is postscript and define bounding box, etc. */
  fprintf(stdout, "%%!PS-Adobe-2.0 EPSF-2.0\n");
  fprintf(stdout, "%%%%Creator: pgeps.\n");
  fprintf(stdout, "%%%%Orientation: Portrait\n");
  fprintf(stdout, "%%%%BoundingBox: 0 0 360 240\n");
  fprintf(stdout, "%%%%Pages: 0\n");
  fprintf(stdout, "%%%%EndComments\n");

  fprintf(stdout, "%% definition operators\n");
  fprintf(stdout, "/bdef {bind def} bind def\n");
  fprintf(stdout, "/xdef {exch def} bdef\n\n");

  fprintf(stdout, "%% page state control\n");
  fprintf(stdout, "/pgsv () def\n");
  fprintf(stdout, "/bpage {/pgsv save newpath def} bdef\n");
  fprintf(stdout, "/epage {pgsv restore} bdef\n");
  fprintf(stdout, "/bplot {gsave} bdef\n");
  fprintf(stdout, "/eplot {grestore} bdef\n\n");

  fprintf(stdout, "%% line types: solid, dashed, dotted, dotdash\n");
  fprintf(stdout, "/SO { []        0 setdash } bdef\n");
  fprintf(stdout, "/DO { [4 2]     0 setdash } bdef\n");
  fprintf(stdout, "/DA { [1 4]     0 setdash } bdef\n");
  fprintf(stdout, "/DD { [1 2 4 2] 0 setdash } bdef\n\n");

  fprintf(stdout, "%% macros for moveto and polyline\n");
  fprintf(stdout, "/M {moveto}  bdef\n");
  fprintf(stdout, "/L {{lineto} repeat stroke} bdef\n\n");

  fprintf(stdout, "%% font control\n");
  fprintf(stdout, "/font_spec () def\n");
  fprintf(stdout, "/lfont currentfont def\n");
  fprintf(stdout, "/sfont currentfont def\n");
  fprintf(stdout, "/selfont {/font_spec xdef} bdef\n");
  fprintf(stdout, "/savefont {font_spec findfont exch scalefont def} bdef\n");
  fprintf(stdout, "/LF {lfont setfont} bdef\n");
  fprintf(stdout, "/SF {sfont setfont} bdef\n\n");

  fprintf(stdout, "%% fonts for text, standard numbers and exponents\n");
  fprintf(stdout, "/Times-Roman selfont\n");
  fprintf(stdout, "/lfont 10 savefont\n");
  fprintf(stdout, "/sfont 10 savefont\n\n");

  fprintf(stdout, "%%line width, line cap, and joint spec\n");
  fprintf(stdout, ".5 setlinewidth 1 setlinecap 1 setlinejoin\n\n");
  fprintf(stdout, "newpath\ngsave\ngsave\n");
}

void pgflsh()
{
  if (lflag==1) {
    lflag=0;
    fprintf(stdout,"stroke\n");
  }
}

void pgmove(x,y)
float x,y;
{
  float ixold,iyold;

  xold = x;
  yold = y;
  ixold = XLO + (XHI - XLO)*xold/XMAX + 0.5;
  iyold = YLO + (YHI - YLO)*yold/YMAX + 0.5;
  if (lflag==1) {
    lflag=0;
    fprintf(stdout,"stroke\n");
  }
  fprintf(stdout,"%f %f M\n",ixold,iyold);


}

void pgdraw(x,y,ltype)
float x,y;
int ltype;

{
  float xold,yold,xnew,ynew;

  float ixnew,iynew;
  int color;

  color = 0;
  while (ltype < 1) {
    ltype += 4;
    color--;
  }
  while (ltype > 4) {
    ltype -= 4;
    color++;
  }

  xnew = x;
  ynew = y;

  if (ltype != ltype1) {
    if (ltype==1) fprintf(stdout,"SO\n");
    if (ltype==2) fprintf(stdout,"DO\n");
    if (ltype==3) fprintf(stdout,"DA\n");
    if (ltype==4) fprintf(stdout,"DD\n");
    ltype1 = ltype;
  }

  ixnew = XLO + (XHI - XLO)*xnew/XMAX + 0.5;
  iynew = YLO + (YHI - YLO)*ynew/YMAX + 0.5;

  fprintf(stdout,"%f %f lineto\n",ixnew,iynew);
  lflag=1;
}


pgtext(x,y,text)

float x,y;
char text[];
{

  int ix,iy,i,k,yblot,descent;
  char text2[MAXSTRING];

  /* escape () (Postscript sucks!) */
  i = k = 0;
  while (text[i] != '\0') {
    if (text[i] == '(' || text[i] == ')') text2[k++] = '\\';
    text2[k] = text[i];
    k++;
    i++;
    if (k >= MAXSTRING) {
      fprintf(stderr,"pgps: text string is too long!\n");
      exit(1);
    }
  }
  text2[k] = '\0';

  ix= XLO + (XHI - XLO)*(x + 0.5*CHARWDTH)/XMAX + .5;
  iy = YLO + (YHI - YLO)*(y - 0.5*CHARHT)/YMAX + .5;


  for (k=1; k<=strlen(text); k++) {
    if (text2[k]=='\n') {
      text2[k]='\0';
    }
  }


  if (lflag==1) {
    lflag=0;
    fprintf(stdout,"stroke\n");
  }

  yblot = (1. + DESCENT)*(YHI - YLO)*CHARHT/YMAX + .5;
  descent = DESCENT*(YHI - YLO)*CHARHT/YMAX + .5;
  fprintf(stdout,"(%s)\nSF\n",text2);
  fprintf(stdout,"newpath\n%d %d M\n",ix,iy - descent);
  fprintf(stdout,"dup stringwidth pop dup\n");
  fprintf(stdout,"%d rlineto\n",0);
  fprintf(stdout,"%d %d rlineto\n",0,yblot);
  fprintf(stdout,"-1 mul %d rlineto\n",0);
  fprintf(stdout,"closepath\n 1.0 setgray\n fill\n");
  fprintf(stdout,"0.0 setgray\n");
  fprintf(stdout,"%d %d M show\n",ix,iy);
}

void pginfo(dcx,dcy)
float *dcx,*dcy;
{
  *dcx = CHARWDTH;
  *dcy = CHARHT;
}
