/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging.headers;

import java.util.Date;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.OutputController;

public class Header {
    public static String default_user = System.getProperty("user.name");
    public String user = default_user;
    public boolean application = true;
    public OutputController.Level level = OutputController.Level.WARNING_ALL;
    public Date date = new Date();
    public boolean isC = false;
    public String caller = "unknown";
    public String thread1 = "unknown";
    public String thread2 = "unknown";

    public Header() {
    }

    public Header(OutputController.Level level, boolean bl) {
        this(level, Thread.currentThread().getStackTrace(), Thread.currentThread(), bl);
    }

    public Header(OutputController.Level level, StackTraceElement[] stackTraceElementArray, Thread thread, boolean bl) {
        this(level, stackTraceElementArray, thread, new Date(), bl);
    }

    public Header(OutputController.Level level, StackTraceElement[] stackTraceElementArray, Thread thread, Date date, boolean bl) {
        this.application = JNLPRuntime.isWebstartApplication();
        this.level = level;
        this.date = date;
        this.isC = bl;
        if (stackTraceElementArray != null) {
            this.caller = Header.getCallerClass(stackTraceElementArray);
        }
        this.thread1 = Integer.toHexString(thread.hashCode());
        this.thread2 = thread.getName();
    }

    public String toString() {
        return this.toString(true, true, true, true, true, true, true);
    }

    public String toString(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (bl) {
                stringBuilder.append("[").append(this.user).append("]");
            }
            if (bl2) {
                stringBuilder.append("[").append(this.getOrigin()).append("]");
            }
            if (bl3 && this.level != null) {
                stringBuilder.append('[').append(this.level.toString()).append(']');
            }
            if (bl4) {
                stringBuilder.append('[').append(this.date.toString()).append(']');
            }
            if (bl5 && this.caller != null) {
                stringBuilder.append('[').append(this.caller).append(']');
            }
            if (bl6 && bl7) {
                stringBuilder.append(this.threadsToString());
            } else if (bl6) {
                stringBuilder.append(this.thread1ToString());
            } else if (bl7) {
                stringBuilder.append(this.thread2ToString());
            }
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
        }
        return stringBuilder.toString();
    }

    public String thread1ToString() {
        return " NETX Thread# " + this.thread1;
    }

    public String thread2ToString() {
        return "name " + this.thread2;
    }

    public String threadsToString() {
        return this.thread1ToString() + ", " + this.thread2ToString();
    }

    public String getOrigin() {
        if (this.application) {
            return "ITW-JAVAWS";
        }
        if (this.isC) {
            return "ITW-C-PLUGIN";
        }
        return "ITW-APPLET";
    }

    static String getCallerClass(StackTraceElement[] stackTraceElementArray) {
        try {
            StackTraceElement stackTraceElement = stackTraceElementArray[0];
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                stackTraceElement = stackTraceElementArray[i];
                if (!stackTraceElementArray[i].getClassName().contains(OutputController.class.getName()) && !stackTraceElementArray[i].getClassName().contains("sun.applet.PluginDebug") && !stackTraceElementArray[i].getClassName().contains(Header.class.getName())) break;
            }
            return stackTraceElement.toString();
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
            return "Unknown caller";
        }
    }
}

