/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.LogConfig;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.logging.SingleStreamLogger;
import net.sourceforge.jnlp.util.logging.headers.Header;

public final class FileLog
implements SingleStreamLogger {
    private static SimpleDateFormat fileLogNameFormatter = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.S");
    private static SimpleDateFormat pluginSharedFormatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss ZZZ yyyy");
    private final Logger impl;
    private final FileHandler fh;
    private static final String defaultloggerName = "IcedTea-Web file-logger";

    public FileLog() {
        this(false);
    }

    public FileLog(boolean bl) {
        this(defaultloggerName, LogConfig.getLogConfig().getIcedteaLogDir() + "itw-javantx-" + FileLog.getStamp() + ".log", bl);
    }

    public FileLog(String string, boolean bl) {
        this(string, string, bl);
    }

    public FileLog(String string, String string2, boolean bl) {
        try {
            File file = new File(string2);
            if (!file.exists()) {
                FileUtils.createRestrictedFile(file, true);
            }
            this.fh = new FileHandler(string2, bl);
            this.fh.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord logRecord) {
                    return logRecord.getMessage() + "\n";
                }
            });
            this.impl = Logger.getLogger(string);
            this.impl.setLevel(Level.ALL);
            this.impl.addHandler(this.fh);
            this.log(new Header(OutputController.Level.WARNING_ALL, Thread.currentThread().getStackTrace(), Thread.currentThread(), false).toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public synchronized void log(String string) {
        this.impl.log(Level.FINE, string);
    }

    public void close() {
        this.fh.close();
    }

    private static String getStamp() {
        return fileLogNameFormatter.format(new Date());
    }

    public static SimpleDateFormat getFileLogNameFormatter() {
        return fileLogNameFormatter;
    }

    public static SimpleDateFormat getPluginSharedFormatter() {
        return pluginSharedFormatter;
    }
}

