/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.lockingfile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sourceforge.jnlp.util.lockingfile.LockedFile;
import net.sourceforge.jnlp.util.lockingfile.StorageIoException;

public abstract class LockingReaderWriter {
    private LockedFile lockedFile;

    public LockingReaderWriter(File file) {
        this.lockedFile = LockedFile.getInstance(file);
    }

    public File getBackingFile() {
        return this.lockedFile.getFile();
    }

    public boolean isReadOnly() {
        return this.lockedFile.isReadOnly();
    }

    public void lock() {
        try {
            this.lockedFile.lock();
        }
        catch (IOException iOException) {
            throw new StorageIoException(iOException);
        }
    }

    public void unlock() {
        try {
            this.lockedFile.unlock();
        }
        catch (IOException iOException) {
            throw new StorageIoException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContents() throws IOException {
        if (!this.getBackingFile().isFile()) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        try (BufferedWriter bufferedWriter = null;){
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getBackingFile()), "UTF-8"));
            this.writeContent(bufferedWriter);
            bufferedWriter.flush();
        }
    }

    protected abstract void writeContent(BufferedWriter var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readContents() throws IOException {
        if (!this.getBackingFile().isFile()) {
            return;
        }
        try (BufferedReader bufferedReader = null;){
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getBackingFile()), "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                this.readLine(string);
            }
        }
    }

    protected synchronized void readContentsLocked() throws IOException {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    LockingReaderWriter.this.readContents();
                }
                catch (IOException iOException) {
                    throw new StorageIoException(iOException);
                }
            }
        });
    }

    protected synchronized void writeContentsLocked() throws IOException {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    LockingReaderWriter.this.writeContents();
                }
                catch (IOException iOException) {
                    throw new StorageIoException(iOException);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLocked(Runnable runnable) {
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    protected abstract void readLine(String var1);
}

