/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import net.sourceforge.jnlp.util.logging.OutputController;

public class UrlUtils {
    private static final String UTF8 = "utf-8";

    public static URL normalizeUrlAndStripParams(URL uRL, boolean bl) {
        try {
            String[] stringArray = uRL.toString().split("\\?");
            URL uRL2 = new URL(stringArray[0]);
            return UrlUtils.normalizeUrl(uRL2, bl);
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, uRISyntaxException);
        }
        return uRL;
    }

    public static URL normalizeUrlAndStripParams(URL uRL) {
        return UrlUtils.normalizeUrlAndStripParams(uRL, false);
    }

    public static boolean isLocalFile(URL uRL) {
        return !(!uRL.getProtocol().equals("file") || uRL.getAuthority() != null && !uRL.getAuthority().equals("") || uRL.getHost() != null && !uRL.getHost().equals(""));
    }

    public static URL decodeUrlQuietly(URL uRL) {
        try {
            return new URL(URLDecoder.decode(uRL.toString(), UTF8));
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
            return uRL;
        }
    }

    public static boolean isValidRFC2396Url(URL uRL) {
        try {
            uRL.toURI();
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static URL normalizeUrl(URL uRL, boolean bl) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        boolean bl2;
        if (uRL == null) {
            return null;
        }
        String string = uRL.getProtocol();
        boolean bl3 = bl2 = bl || !"file".equals(string);
        if (string == null || !bl2 || uRL.getPath() == null || UrlUtils.isValidRFC2396Url(uRL)) {
            return uRL;
        }
        URL uRL2 = new URL(URLDecoder.decode(uRL.toString(), UTF8));
        URI uRI = new URI(uRL2.getProtocol(), null, uRL2.getHost(), uRL2.getPort(), uRL2.getPath(), uRL2.getQuery(), null);
        URL uRL3 = new URL(uRI.toASCIIString());
        return uRL3;
    }

    public static URL normalizeUrl(URL uRL) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        return UrlUtils.normalizeUrl(uRL, false);
    }

    public static URL normalizeUrlQuietly(URL uRL, boolean bl) {
        try {
            return UrlUtils.normalizeUrl(uRL, bl);
        }
        catch (MalformedURLException malformedURLException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, malformedURLException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, unsupportedEncodingException);
        }
        catch (URISyntaxException uRISyntaxException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, uRISyntaxException);
        }
        return uRL;
    }

    public static URL normalizeUrlQuietly(URL uRL) {
        return UrlUtils.normalizeUrlQuietly(uRL, false);
    }

    public static File decodeUrlAsFile(URL uRL) {
        return new File(UrlUtils.decodeUrlQuietly(uRL).getFile());
    }
}

