/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;

class SingleInstanceLock {
    JNLPFile jnlpFile;
    File lockFile = null;
    public static final int INVALID_PORT = Integer.MIN_VALUE;
    int port = Integer.MIN_VALUE;

    public SingleInstanceLock(JNLPFile jNLPFile) {
        this.jnlpFile = jNLPFile;
        this.lockFile = this.getLockFile();
    }

    public void createWithPort(int n) throws IOException {
        FileUtils.createRestrictedFile(this.lockFile, true);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.lockFile, false));
        bufferedWriter.write(String.valueOf(n));
        bufferedWriter.newLine();
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public boolean isValid() {
        return this.exists() && this.getPort() != Integer.MIN_VALUE && !this.isPortFree(this.getPort());
    }

    public int getPort() {
        if (!this.exists()) {
            return Integer.MIN_VALUE;
        }
        try {
            this.parseFile();
        }
        catch (NumberFormatException numberFormatException) {
            this.port = Integer.MIN_VALUE;
        }
        catch (IOException iOException) {
            this.port = Integer.MIN_VALUE;
        }
        return this.port;
    }

    private boolean exists() {
        return this.lockFile.exists();
    }

    private boolean isPortFree(int n) {
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            serverSocket.close();
            return true;
        }
        catch (BindException bindException) {
            return false;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private File getLockFile() {
        File file = new File(JNLPRuntime.getConfiguration().getProperty("deployment.user.locksdir"));
        if (!file.isDirectory()) {
            if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
                throw new RuntimeException(Translator.R("RNoLockDir", file));
            }
            try {
                FileUtils.createRestrictedDirectory(file);
            }
            catch (IOException iOException) {
                throw new RuntimeException(Translator.R("RNoLockDir", file));
            }
        }
        String string = this.getLockFileName();
        File file2 = new File(file, string);
        return file2;
    }

    private String getLockFileName() {
        String string = "";
        string = this.jnlpFile.getSourceLocation() != null ? string + this.jnlpFile.getSourceLocation() : string + this.jnlpFile.getFileLocation();
        if (this.jnlpFile.getFileVersion() != null) {
            string = string + this.jnlpFile.getFileVersion().toString();
        }
        string = string + this.getCurrentDisplay();
        return FileUtils.sanitizeFileName(string);
    }

    private void parseFile() throws NumberFormatException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.lockFile));
        int n = Integer.valueOf(bufferedReader.readLine());
        bufferedReader.close();
        this.port = n;
    }

    private String getCurrentDisplay() {
        String string = System.getenv("DISPLAY");
        return string == null ? "" : string;
    }
}

