/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteUnsignedApplet;
import net.sourceforge.jnlp.security.appletextendedsecurity.UrlRegEx;

public class UnsignedAppletActionEntry {
    private ExecuteUnsignedApplet unsignedAppletAction;
    private Date timeStamp;
    private UrlRegEx documentBase;
    private UrlRegEx codeBase;
    private List<String> archives;

    public static UnsignedAppletActionEntry createFromString(String string) {
        String[] stringArray = string.split("\\s+");
        UnsignedAppletActionEntry unsignedAppletActionEntry = new UnsignedAppletActionEntry(ExecuteUnsignedApplet.fromString(stringArray[0]), new Date(new Long(stringArray[1])), new UrlRegEx(stringArray[2]), null, null);
        if (stringArray.length > 3) {
            unsignedAppletActionEntry.setCodeBase(new UrlRegEx(stringArray[3]));
        }
        if (stringArray.length > 4) {
            unsignedAppletActionEntry.setArchives(UnsignedAppletActionEntry.createArchivesList(string.substring(string.lastIndexOf(stringArray[3]) + stringArray[3].length()).trim()));
        }
        return unsignedAppletActionEntry;
    }

    public UnsignedAppletActionEntry(ExecuteUnsignedApplet executeUnsignedApplet, Date date, UrlRegEx urlRegEx, UrlRegEx urlRegEx2, List<String> list) {
        this.unsignedAppletAction = executeUnsignedApplet;
        this.timeStamp = date;
        this.documentBase = urlRegEx;
        this.codeBase = urlRegEx2;
        this.archives = list;
    }

    public String toString() {
        return this.serializeToReadableAndParseableString();
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.serializeToReadableAndParseableString());
    }

    private String serializeToReadableAndParseableString() {
        return this.unsignedAppletAction.toChar() + " " + (this.timeStamp == null ? "1" : Long.valueOf(this.timeStamp.getTime())) + " " + (this.documentBase == null ? "" : this.documentBase.getRegEx()) + " " + (this.codeBase == null ? "" : this.codeBase.getRegEx()) + " " + UnsignedAppletActionEntry.createArchivesString(this.archives);
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public UrlRegEx getDocumentBase() {
        return this.documentBase;
    }

    public void setTimeStamp(Date date) {
        this.timeStamp = date;
    }

    public void setDocumentBase(UrlRegEx urlRegEx) {
        this.documentBase = urlRegEx;
    }

    public ExecuteUnsignedApplet getUnsignedAppletAction() {
        return this.unsignedAppletAction;
    }

    public void setUnsignedAppletAction(ExecuteUnsignedApplet executeUnsignedApplet) {
        this.unsignedAppletAction = executeUnsignedApplet;
    }

    public UrlRegEx getCodeBase() {
        return this.codeBase;
    }

    public void setCodeBase(UrlRegEx urlRegEx) {
        this.codeBase = urlRegEx;
    }

    public List<String> getArchives() {
        return this.archives;
    }

    public void setArchives(List<String> list) {
        this.archives = list;
    }

    public static String createArchivesString(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string.trim().isEmpty()) continue;
            stringBuilder.append(string);
            if (i == list.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public static List<String> createArchivesList(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().isEmpty()) {
            return null;
        }
        String[] stringArray = string.trim().split(",");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.trim().isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

