/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityUtil {
    private static final char[] password = "changeit".toCharArray();

    public static String getTrustedCertsFilename() throws Exception {
        return KeyStores.getKeyStoreLocation(KeyStores.Level.USER, KeyStores.Type.CERTS);
    }

    public static char[] getTrustedCertsPassword() {
        return password;
    }

    public static String getCN(String string) {
        int n = string.indexOf("CN=");
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = null;
        block5: for (int i = n + 3; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    if (bl2) {
                        stringBuilder.append(c);
                        bl2 = false;
                        continue block5;
                    }
                    bl = !bl;
                    continue block5;
                }
                case '\\': {
                    if (bl2) {
                        stringBuilder.append(c);
                        bl2 = false;
                        continue block5;
                    }
                    bl2 = true;
                    continue block5;
                }
                case '+': 
                case ',': 
                case ';': {
                    if (bl2 || bl) {
                        stringBuilder.append(c);
                        if (!bl2) continue block5;
                        bl2 = false;
                        continue block5;
                    }
                    return stringBuilder.toString();
                }
                default: {
                    if (bl2 && SecurityUtil.isHexDigit(c)) {
                        cArray = new char[2];
                        cArray[0] = c;
                    } else if (cArray != null) {
                        if (!SecurityUtil.isHexDigit(c)) {
                            return "";
                        }
                        cArray[1] = c;
                        stringBuilder.append((char)Integer.parseInt(new String(cArray), 16));
                        cArray = null;
                    } else {
                        stringBuilder.append(c);
                    }
                    bl2 = false;
                }
            }
        }
        return stringBuilder.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean checkTrustedCertsFile() throws Exception {
        File file = new File(SecurityUtil.getTrustedCertsFilename());
        if (!file.isFile()) {
            File file2 = file.getAbsoluteFile().getParentFile();
            boolean bl = false;
            if (!file2.isDirectory()) {
                bl = file2.mkdirs();
            }
            if (bl || file2.isDirectory()) {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(null, password);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                keyStore.store(fileOutputStream, password);
                fileOutputStream.close();
                return true;
            }
            return false;
        }
        return true;
    }

    public static KeyStore getUserKeyStore() throws Exception {
        KeyStore keyStore = null;
        FileInputStream fileInputStream = null;
        if (SecurityUtil.checkTrustedCertsFile()) {
            try {
                File file = new File(SecurityUtil.getTrustedCertsFilename());
                if (file.exists()) {
                    fileInputStream = new FileInputStream(file);
                    keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(fileInputStream, password);
                }
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
                throw exception;
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getCacertsKeyStore() throws Exception {
        KeyStore keyStore = null;
        try (FileInputStream fileInputStream = null;){
            File file = new File(System.getProperty("java.home") + "/lib/security/cacerts");
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(fileInputStream, null);
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getSystemCertStore() throws Exception {
        KeyStore keyStore = null;
        try (FileInputStream fileInputStream = null;){
            File file = new File(System.getProperty("javax.net.ssl.trustStore"));
            String string = System.getProperty("javax.net.ssl.trustStoreType");
            char[] cArray = System.getProperty("javax.net.ssl.trustStorePassword").toCharArray();
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                keyStore = KeyStore.getInstance(string);
                keyStore.load(fileInputStream, cArray);
            }
        }
        return keyStore;
    }
}

