/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Random;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.replacements.BASE64Encoder;

public class CertificateUtils {
    public static final void addToKeyStore(File file, KeyStore keyStore) throws CertificateException, IOException, KeyStoreException {
        OutputController.getLogger().log("Importing certificate from " + file + " into " + keyStore);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(bufferedInputStream);
        }
        catch (ClassCastException classCastException) {
            throw new CertificateException("Input file is not an X509 Certificate", classCastException);
        }
        CertificateUtils.addToKeyStore(x509Certificate, keyStore);
    }

    public static final void addToKeyStore(X509Certificate x509Certificate, KeyStore keyStore) throws KeyStoreException {
        OutputController.getLogger().log("Importing " + x509Certificate.getSubjectX500Principal().getName());
        String string = null;
        string = keyStore.getCertificateAlias(x509Certificate);
        if (string != null) {
            return;
        }
        Random random = new Random();
        while (keyStore.getCertificate(string = new BigInteger(20, random).toString()) != null) {
        }
        keyStore.setCertificateEntry(string, x509Certificate);
    }

    public static void addPKCS12ToKeyStore(File file, KeyStore keyStore, char[] cArray) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        KeyStore keyStore2 = KeyStore.getInstance("PKCS12");
        keyStore2.load(bufferedInputStream, cArray);
        Enumeration<String> enumeration = keyStore2.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate[] certificateArray = keyStore2.getCertificateChain(string);
            Key key = keyStore2.getKey(string, cArray);
            CertificateUtils.addPKCS12ToKeyStore(certificateArray, key, keyStore);
        }
    }

    public static void addPKCS12ToKeyStore(Certificate[] certificateArray, Key key, KeyStore keyStore) throws KeyStoreException {
        String string = null;
        string = keyStore.getCertificateAlias(certificateArray[0]);
        if (string != null) {
            return;
        }
        Random random = new Random();
        while (keyStore.getCertificate(string = new BigInteger(20, random).toString()) != null) {
        }
        keyStore.setKeyEntry(string, key, KeyStores.getPassword(), certificateArray);
    }

    public static final boolean inKeyStores(X509Certificate x509Certificate, KeyStore[] keyStoreArray) {
        for (int i = 0; i < keyStoreArray.length; ++i) {
            try {
                Enumeration<String> enumeration = keyStoreArray[i].aliases();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (!x509Certificate.equals(keyStoreArray[i].getCertificate(string))) continue;
                    OutputController.getLogger().log(Translator.R("LCertFoundIn", x509Certificate.getSubjectX500Principal().getName(), KeyStores.getPathToKeystore(keyStoreArray[i].hashCode())));
                    return true;
                }
                continue;
            }
            catch (KeyStoreException keyStoreException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, keyStoreException);
            }
        }
        return false;
    }

    public static void dump(Certificate certificate, PrintStream printStream) throws IOException, CertificateException {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        printStream.println("-----BEGIN CERTIFICATE-----");
        bASE64Encoder.encodeBuffer(certificate.getEncoded(), (OutputStream)printStream);
        printStream.println("-----END CERTIFICATE-----");
    }

    public static void dumpPKCS12(String string, File file, KeyStore keyStore, char[] cArray) throws Exception {
        Certificate[] certificateArray = keyStore.getCertificateChain(string);
        Key key = keyStore.getKey(string, KeyStores.getPassword());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        KeyStore keyStore2 = KeyStore.getInstance("PKCS12");
        keyStore2.load(null, null);
        keyStore2.setKeyEntry(string, key, cArray, certificateArray);
        keyStore2.store(bufferedOutputStream, cArray);
    }
}

