/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.applet.Applet;
import java.awt.Container;
import java.awt.Frame;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.AppletEnvironment;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.util.logging.OutputController;

public class AppletInstance
extends ApplicationInstance {
    private boolean appletStopped = false;
    private Applet applet;
    private AppletEnvironment environment;

    public AppletInstance(JNLPFile jNLPFile, ThreadGroup threadGroup, ClassLoader classLoader, Applet applet) {
        super(jNLPFile, threadGroup, classLoader);
        this.applet = applet;
        this.environment = new AppletEnvironment(jNLPFile, this);
    }

    public void setApplet(Applet applet) {
        if (this.applet != null) {
            OutputController.getLogger().log(new IllegalStateException("Applet can only be set once."));
            return;
        }
        this.applet = applet;
    }

    public AppletInstance(JNLPFile jNLPFile, ThreadGroup threadGroup, ClassLoader classLoader, Applet applet, Container container) {
        super(jNLPFile, threadGroup, classLoader);
        this.applet = applet;
        this.environment = new AppletEnvironment(jNLPFile, this, container);
    }

    public void setResizable(boolean bl) {
        Container container = this.environment.getAppletFrame();
        if (container instanceof Frame) {
            ((Frame)container).setResizable(bl);
        }
    }

    public boolean isResizable() {
        Container container = this.environment.getAppletFrame();
        if (container instanceof Frame) {
            return ((Frame)container).isResizable();
        }
        return false;
    }

    @Override
    public String getTitle() {
        return this.getJNLPFile().getApplet().getName();
    }

    public AppletEnvironment getAppletEnvironment() {
        return this.environment;
    }

    public Applet getApplet() {
        return this.applet;
    }

    @Override
    public void destroy() {
        if (this.appletStopped) {
            return;
        }
        this.appletStopped = true;
        try {
            this.applet.stop();
            this.applet.destroy();
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
        }
        this.environment.destroy();
        super.destroy();
    }
}

