/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.ConfigurationException;
import javax.swing.JOptionPane;
import net.sourceforge.jnlp.config.Defaults;
import net.sourceforge.jnlp.config.DirectoryValidator;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.config.ValueValidator;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public final class DeploymentConfiguration {
    public static final String DEPLOYMENT_SUBDIR_DIR = "icedtea-web";
    public static final String DEPLOYMENT_CACHE_DIR = ".cache" + File.separator + "icedtea-web";
    public static final String DEPLOYMENT_CONFIG_DIR = ".config" + File.separator + "icedtea-web";
    public static final String DEPLOYMENT_CONFIG_FILE = "deployment.config";
    public static final String DEPLOYMENT_PROPERTIES = "deployment.properties";
    public static final String APPLET_TRUST_SETTINGS = ".appletTrustSettings";
    public static final String DEPLOYMENT_COMMENT = "Netx deployment configuration";
    public static final int JNLP_ASSOCIATION_NEVER = 0;
    public static final int JNLP_ASSOCIATION_NEW_ONLY = 1;
    public static final int JNLP_ASSOCIATION_ASK_USER = 2;
    public static final int JNLP_ASSOCIATION_REPLACE_ASK = 3;
    public static final String CONSOLE_HIDE = "HIDE";
    public static final String CONSOLE_SHOW = "SHOW";
    public static final String CONSOLE_DISABLE = "DISABLE";
    public static final String CONSOLE_SHOW_PLUGIN = "SHOW_PLUGIN_ONLY";
    public static final String CONSOLE_SHOW_JAVAWS = "SHOW_JAVAWS_ONLY";
    public static final String KEY_USER_CACHE_DIR = "deployment.user.cachedir";
    public static final String KEY_USER_PERSISTENCE_CACHE_DIR = "deployment.user.pcachedir";
    public static final String KEY_SYSTEM_CACHE_DIR = "deployment.system.cachedir";
    public static final String KEY_USER_LOG_DIR = "deployment.user.logdir";
    public static final String KEY_USER_TMP_DIR = "deployment.user.tmp";
    public static final String KEY_USER_LOCKS_DIR = "deployment.user.locksdir";
    public static final String KEY_USER_NETX_RUNNING_FILE = "deployment.user.runningfile";
    public static final String KEY_USER_SECURITY_POLICY = "deployment.user.security.policy";
    public static final String KEY_USER_TRUSTED_CA_CERTS = "deployment.user.security.trusted.cacerts";
    public static final String KEY_USER_TRUSTED_JSSE_CA_CERTS = "deployment.user.security.trusted.jssecacerts";
    public static final String KEY_USER_TRUSTED_CERTS = "deployment.user.security.trusted.certs";
    public static final String KEY_USER_TRUSTED_JSSE_CERTS = "deployment.user.security.trusted.jssecerts";
    public static final String KEY_USER_TRUSTED_CLIENT_CERTS = "deployment.user.security.trusted.clientauthcerts";
    public static final String KEY_SYSTEM_SECURITY_POLICY = "deployment.system.security.policy";
    public static final String KEY_SYSTEM_TRUSTED_CA_CERTS = "deployment.system.security.cacerts";
    public static final String KEY_SYSTEM_TRUSTED_JSSE_CA_CERTS = "deployment.system.security.jssecacerts";
    public static final String KEY_SYSTEM_TRUSTED_CERTS = "deployment.system.security.trusted.certs";
    public static final String KEY_SYSTEM_TRUSTED_JSSE_CERTS = "deployment.system.security.trusted.jssecerts";
    public static final String KEY_SYSTEM_TRUSTED_CLIENT_CERTS = "deployment.system.security.trusted.clientautcerts";
    public static final String KEY_SECURITY_PROMPT_USER = "deployment.security.askgrantdialog.show";
    public static final String KEY_SECURITY_LEVEL = "deployment.security.level";
    public static final String KEY_SECURITY_TRUSTED_POLICY = "deployment.security.trusted.policy";
    public static final String KEY_SECURITY_ALLOW_HIDE_WINDOW_WARNING = "deployment.security.sandbox.awtwarningwindow";
    public static final String KEY_SECURITY_PROMPT_USER_FOR_JNLP = "deployment.security.sandbox.jnlp.enhanced";
    public static final String KEY_SECURITY_INSTALL_AUTHENTICATOR = "deployment.security.authenticator";
    public static final String KEY_PROXY_TYPE = "deployment.proxy.type";
    public static final String KEY_PROXY_SAME = "deployment.proxy.same";
    public static final String KEY_PROXY_AUTO_CONFIG_URL = "deployment.proxy.auto.config.url";
    public static final String KEY_PROXY_BYPASS_LIST = "deployment.proxy.bypass.list";
    public static final String KEY_PROXY_BYPASS_LOCAL = "deployment.proxy.bypass.local";
    public static final String KEY_PROXY_HTTP_HOST = "deployment.proxy.http.host";
    public static final String KEY_PROXY_HTTP_PORT = "deployment.proxy.http.port";
    public static final String KEY_PROXY_HTTPS_HOST = "deployment.proxy.https.host";
    public static final String KEY_PROXY_HTTPS_PORT = "deployment.proxy.https.port";
    public static final String KEY_PROXY_FTP_HOST = "deployment.proxy.ftp.host";
    public static final String KEY_PROXY_FTP_PORT = "deployment.proxy.ftp.port";
    public static final String KEY_PROXY_SOCKS4_HOST = "deployment.proxy.socks.host";
    public static final String KEY_PROXY_SOCKS4_PORT = "deployment.proxy.socks.port";
    public static final String KEY_PROXY_OVERRIDE_HOSTS = "deployment.proxy.override.hosts";
    public static final String KEY_ENABLE_LOGGING = "deployment.log";
    public static final String KEY_ENABLE_LOGGING_HEADERS = "deployment.log.headers";
    public static final String KEY_ENABLE_LOGGING_TOFILE = "deployment.log.file";
    public static final String KEY_ENABLE_LOGGING_TOSTREAMS = "deployment.log.stdstreams";
    public static final String KEY_ENABLE_LOGGING_TOSYSTEMLOG = "deployment.log.system";
    public static final String KEY_CONSOLE_STARTUP_MODE = "deployment.console.startup.mode";
    public static final String KEY_JNLP_ASSOCIATIONS = "deployment.javaws.associations";
    public static final String KEY_CREATE_DESKTOP_SHORTCUT = "deployment.javaws.shortcut";
    public static final String KEY_JRE_INTSTALL_URL = "deployment.javaws.installURL";
    public static final String KEY_AUTO_DOWNLOAD_JRE = "deployment.javaws.autodownload";
    public static final String KEY_BROWSER_PATH = "deployment.browser.path";
    public static final String KEY_UPDATE_TIMEOUT = "deployment.javaws.update.timeout";
    public static final String KEY_PLUGIN_JVM_ARGUMENTS = "deployment.plugin.jvm.arguments";
    public static final String KEY_JRE_DIR = "deployment.jre.dir";
    private ConfigurationException loadingException = null;
    private boolean systemPropertiesMandatory = false;
    private File systemPropertiesFile = null;
    private File userPropertiesFile = null;
    public static final File USER_DEPLOYMENT_PROPERTIES_FILE = new File(Defaults.USER_CONFIG_HOME + File.separator + "deployment.properties");
    private Map<String, Setting<String>> currentConfiguration = new HashMap<String, Setting<String>>();
    private Map<String, Setting<String>> unchangeableConfiguration = new HashMap<String, Setting<String>>();

    public void setLoadingException(ConfigurationException configurationException) {
        this.loadingException = configurationException;
    }

    public ConfigurationException getLoadingException() {
        return this.loadingException;
    }

    public void load() throws ConfigurationException {
        this.load(true);
    }

    public static File getAppletTrustUserSettingsPath() {
        return new File(Defaults.USER_CONFIG_HOME + File.separator + APPLET_TRUST_SETTINGS);
    }

    public static File getAppletTrustGlobalSettingsPath() {
        return new File(File.separator + "etc" + File.separator + ".java" + File.separator + "deployment" + File.separator + APPLET_TRUST_SETTINGS);
    }

    public void load(boolean bl) throws ConfigurationException {
        File file = new File(USER_DEPLOYMENT_PROPERTIES_FILE.getAbsolutePath());
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(file.toString());
        }
        File file2 = this.findSystemConfigFile();
        this.load(file2, file, bl);
    }

    void load(File file, File file2, boolean bl) throws ConfigurationException {
        Map<String, Setting<String>> map = Defaults.getDefaults();
        Map<String, Setting<String>> map2 = null;
        if (file != null) {
            if (this.loadSystemConfiguration(file)) {
                OutputController.getLogger().log("System level deployment.config is mandatory: " + this.systemPropertiesMandatory);
                map2 = this.loadProperties(ConfigType.System, this.systemPropertiesFile, this.systemPropertiesMandatory);
            }
            if (map2 != null) {
                this.mergeMaps(map, map2);
            }
        }
        this.unchangeableConfiguration = new HashMap<String, Setting<String>>();
        Set<String> set = map.keySet();
        for (String string : set) {
            this.unchangeableConfiguration.put(string, new Setting<String>(map.get(string)));
        }
        this.userPropertiesFile = file2;
        Map<String, Setting<String>> map3 = this.loadProperties(ConfigType.User, this.userPropertiesFile, false);
        if (map3 != null) {
            this.mergeMaps(map, map3);
        }
        if (bl) {
            this.checkAndFixConfiguration(map);
        }
        this.currentConfiguration = map;
    }

    public void copyTo(Properties properties) {
        Set<String> set = this.getAllPropertyNames();
        for (String string : set) {
            String string2 = this.getProperty(string);
            if (string2 == null) continue;
            properties.setProperty(string, string2);
        }
    }

    public String getProperty(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && this.userPropertiesFile != null) {
            securityManager.checkRead(this.userPropertiesFile.toString());
        }
        String string2 = null;
        if (this.currentConfiguration.get(string) != null) {
            string2 = this.currentConfiguration.get(string).getValue();
        }
        return string2;
    }

    public Set<String> getAllPropertyNames() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && this.userPropertiesFile != null) {
            securityManager.checkRead(this.userPropertiesFile.toString());
        }
        return this.currentConfiguration.keySet();
    }

    public Map<String, Setting<String>> getRaw() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && this.userPropertiesFile != null) {
            securityManager.checkRead(this.userPropertiesFile.toString());
        }
        return this.currentConfiguration;
    }

    public void setProperty(String string, String string2) {
        Setting<String> setting;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && this.userPropertiesFile != null) {
            securityManager.checkWrite(this.userPropertiesFile.toString());
        }
        if ((setting = this.currentConfiguration.get(string)) != null) {
            if (!setting.isLocked()) {
                setting.setValue(string2);
            }
        } else {
            setting = new Setting<String>(string, Translator.R("Unknown"), false, null, null, string2, Translator.R("Unknown"));
            this.currentConfiguration.put(string, setting);
        }
    }

    public void checkAndFixConfiguration(Map<String, Setting<String>> map) {
        Map<String, Setting<String>> map2 = Defaults.getDefaults();
        for (String string : map.keySet()) {
            Setting<String> setting = map.get(string);
            if (!setting.getName().equals(string)) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("DCInternal", "key " + string + " does not match setting name " + setting.getName()));
                continue;
            }
            if (!map2.containsKey(string)) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("DCUnknownSettingWithName", string));
                continue;
            }
            ValueValidator valueValidator = map2.get(string).getValidator();
            if (valueValidator == null) continue;
            try {
                valueValidator.validate(setting.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("DCIncorrectValue", string, setting.getValue(), valueValidator.getPossibleValues()));
                setting.setValue(setting.getDefaultValue());
                OutputController.getLogger().log(illegalArgumentException);
            }
        }
    }

    private File findSystemConfigFile() {
        Object object;
        File file = new File(File.separator + "etc" + File.separator + ".java" + File.separator + "deployment" + File.separator + DEPLOYMENT_CONFIG_FILE);
        if (file.isFile()) {
            return file;
        }
        String string = null;
        try {
            object = this.parsePropertiesFile(USER_DEPLOYMENT_PROPERTIES_FILE);
            Setting<String> setting = object.get(KEY_JRE_DIR);
            if (setting != null) {
                string = setting.getValue();
            }
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
        }
        object = string != null ? new File(string + File.separator + "lib" + File.separator + DEPLOYMENT_CONFIG_FILE) : new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + DEPLOYMENT_CONFIG_FILE);
        if (((File)object).isFile()) {
            return object;
        }
        return null;
    }

    private boolean loadSystemConfiguration(File file) {
        OutputController.getLogger().log("Loading system configuation from: " + file);
        Map<Object, Object> map = new HashMap();
        try {
            map = this.parsePropertiesFile(file);
        }
        catch (IOException iOException) {
            OutputController.getLogger().log("No System level deployment.properties found.");
            OutputController.getLogger().log(iOException);
            return false;
        }
        try {
            String string = (String)((Setting)map.get("deployment.system.config")).getValue();
            if (string == null) {
                OutputController.getLogger().log("No System level deployment.properties found.");
                return false;
            }
            URL uRL = new URL(string);
            if (uRL.getProtocol().equals("file")) {
                this.systemPropertiesFile = new File(uRL.getFile());
                OutputController.getLogger().log("Using System leveldeployment.properties: " + this.systemPropertiesFile);
                Setting setting = (Setting)map.get("deployment.system.config.mandatory");
                this.systemPropertiesMandatory = Boolean.valueOf(setting == null ? null : (String)setting.getValue());
                return true;
            }
            OutputController.getLogger().log("Remote + deployment.properties not supported");
            return false;
        }
        catch (MalformedURLException malformedURLException) {
            OutputController.getLogger().log("Invalid url for deployment.properties");
            OutputController.getLogger().log(malformedURLException);
            return false;
        }
    }

    private Map<String, Setting<String>> loadProperties(ConfigType configType, File file, boolean bl) throws ConfigurationException {
        if (file == null || !file.isFile()) {
            OutputController.getLogger().log("No " + configType.toString() + " level " + DEPLOYMENT_PROPERTIES + " found.");
            if (!bl) {
                return null;
            }
            throw new ConfigurationException();
        }
        OutputController.getLogger().log("Loading " + configType.toString() + " level properties from: " + file);
        try {
            return this.parsePropertiesFile(file);
        }
        catch (IOException iOException) {
            if (JNLPRuntime.isDebug()) {
                OutputController.getLogger().log(iOException);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (this.userPropertiesFile == null) {
            throw new IllegalStateException("must load() before save()");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.userPropertiesFile.toString());
        }
        OutputController.getLogger().log("Saving properties into " + this.userPropertiesFile.toString());
        Properties properties = new Properties();
        for (String object2 : this.currentConfiguration.keySet()) {
            String string;
            String string2 = this.unchangeableConfiguration.get(object2) == null ? null : this.unchangeableConfiguration.get(object2).getValue();
            String string3 = string = this.currentConfiguration.get(object2) == null ? null : this.currentConfiguration.get(object2).getValue();
            if (string2 == null && string == null) continue;
            if (string2 == null && string != null) {
                properties.setProperty(object2, string);
                continue;
            }
            if (string2 != null && string == null) {
                properties.setProperty(object2, string);
                continue;
            }
            if (string2.equals(string)) continue;
            properties.setProperty(object2, string);
        }
        File file = new File(this.userPropertiesFile.toString() + ".old");
        if (this.userPropertiesFile.isFile() && !this.userPropertiesFile.renameTo(file)) {
            throw new IOException("Error saving backup copy of " + this.userPropertiesFile);
        }
        FileUtils.createParentDir(this.userPropertiesFile);
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.userPropertiesFile));){
            properties.store(bufferedOutputStream, DEPLOYMENT_COMMENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Setting<String>> parsePropertiesFile(File file) throws IOException {
        HashMap<String, Setting<String>> hashMap = new HashMap<String, Setting<String>>();
        Properties properties = new Properties();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            properties.load(bufferedReader);
        }
        Set<String> set = properties.stringPropertyNames();
        for (String string : set) {
            Setting setting;
            String string2;
            if (string.endsWith(".locked")) {
                string2 = string.substring(0, string.length() - ".locked".length());
                setting = (Setting)hashMap.get(string2);
                if (setting == null) {
                    setting = new Setting<Object>(string2, Translator.R("Unknown"), true, null, null, null, file.toString());
                    hashMap.put(string2, setting);
                    continue;
                }
                setting.setLocked(true);
                continue;
            }
            string2 = properties.getProperty(string);
            setting = (Setting)hashMap.get(string);
            if (setting == null) {
                setting = new Setting(string, Translator.R("Unknown"), false, null, null, string2, file.toString());
                hashMap.put(string, setting);
                continue;
            }
            setting.setValue(string2);
            setting.setSource(file.toString());
        }
        return hashMap;
    }

    private void mergeMaps(Map<String, Setting<String>> map, Map<String, Setting<String>> map2) {
        for (String string : map2.keySet()) {
            Setting<String> setting = map.get(string);
            Setting<String> setting2 = map2.get(string);
            if (setting == null) {
                map.put(string, setting2);
                continue;
            }
            if (setting.isLocked()) continue;
            setting.setSource(setting2.getSource());
            setting.setValue(setting2.getValue());
        }
    }

    private static void dumpConfiguration(Map<String, Setting<String>> map, PrintStream printStream) {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "KEY: VALUE [Locked]");
        for (String string : map.keySet()) {
            Setting<String> setting = map.get(string);
            printStream.println("'" + string + "': '" + setting.getValue() + "'" + (setting.isLocked() ? " [LOCKED]" : ""));
        }
    }

    public static void move14AndOlderFilesTo15StructureCatched() {
        try {
            DeploymentConfiguration.move14AndOlderFilesTo15Structure();
        }
        catch (Throwable throwable) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Critical error during converting old files to new. Continuing");
            OutputController.getLogger().log(throwable);
        }
    }

    private static void move14AndOlderFilesTo15Structure() {
        Object object;
        int n = 0;
        String string = ".icedtea";
        String string2 = System.getProperty("user.home") + File.separator + string;
        File file = new File(Defaults.USER_CONFIG_HOME);
        File file2 = new File(Defaults.USER_CACHE_HOME);
        File file3 = new File(string2);
        if (file3.exists()) {
            String string3;
            Object object2;
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Legacy configuration and cache found. Those will be now transported to new locations");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Defaults.USER_CONFIG_HOME + " and " + Defaults.USER_CACHE_HOME);
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "You should not see this message next time you run icedtea-web!");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Your custom dirs will not be touched and will work");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "-----------------------------------------------");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Preparing new directories:");
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " " + Defaults.USER_CONFIG_HOME);
            n += DeploymentConfiguration.resultToStd(file.mkdirs());
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, " " + Defaults.USER_CACHE_HOME);
            n += DeploymentConfiguration.resultToStd(file2.mkdirs());
            object = string2 + File.separator + "security";
            String string4 = Defaults.USER_SECURITY;
            n += DeploymentConfiguration.moveLegacyToCurrent((String)object, string4);
            String string5 = string2 + File.separator + "cache";
            String string6 = Defaults.getDefaults().get(KEY_USER_CACHE_DIR).getDefaultValue();
            n += DeploymentConfiguration.moveLegacyToCurrent(string5, string6);
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Adapting recently_used to new destination");
            try {
                object2 = new File(string6, "recently_used");
                string3 = FileUtils.loadFileAsString((File)object2);
                string3 = string3.replace(string5, string6);
                FileUtils.saveFile(string3, (File)object2);
            }
            catch (IOException iOException) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, iOException);
                ++n;
            }
            object2 = string2 + File.separator + "pcache";
            string3 = Defaults.getDefaults().get(KEY_USER_PERSISTENCE_CACHE_DIR).getDefaultValue();
            n += DeploymentConfiguration.moveLegacyToCurrent((String)object2, string3);
            String string7 = string2 + File.separator + "log";
            String string8 = Defaults.getDefaults().get(KEY_USER_LOG_DIR).getDefaultValue();
            n += DeploymentConfiguration.moveLegacyToCurrent(string7, string8);
            String string9 = string2 + File.separator + DEPLOYMENT_PROPERTIES;
            String string10 = Defaults.USER_CONFIG_HOME + File.separator + DEPLOYMENT_PROPERTIES;
            n += DeploymentConfiguration.moveLegacyToCurrent(string9, string10);
            String string11 = string2 + File.separator + DEPLOYMENT_PROPERTIES + ".old";
            String string12 = Defaults.USER_CONFIG_HOME + File.separator + DEPLOYMENT_PROPERTIES + ".old";
            n += DeploymentConfiguration.moveLegacyToCurrent(string11, string12);
            String string13 = string2 + File.separator + APPLET_TRUST_SETTINGS;
            String string14 = DeploymentConfiguration.getAppletTrustUserSettingsPath().getAbsolutePath();
            n += DeploymentConfiguration.moveLegacyToCurrent(string13, string14);
            String string15 = string2 + File.separator + "tmp";
            String string16 = Defaults.getDefaults().get(KEY_USER_TMP_DIR).getDefaultValue();
            n += DeploymentConfiguration.moveLegacyToCurrent(string15, string16);
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Removing now empty " + string2);
            if ((n += DeploymentConfiguration.resultToStd(file3.delete())) != 0) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "There occureed " + n + " errors");
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Please double check content of old data in " + string2 + " with ");
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "new " + Defaults.USER_CONFIG_HOME + " and " + Defaults.USER_CACHE_HOME);
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "To disable this check again, please remove " + string2);
            }
        } else {
            OutputController.getLogger().log("System is already following XDG .cache and .config specifications");
            try {
                OutputController.getLogger().log("config: " + Defaults.USER_CONFIG_HOME + " file exists: " + file.exists());
            }
            catch (Exception exception) {
                OutputController.getLogger().log(exception);
            }
            try {
                OutputController.getLogger().log("cache: " + Defaults.USER_CACHE_HOME + " file exists:" + file2.exists());
            }
            catch (Exception exception) {
                OutputController.getLogger().log(exception);
            }
        }
        object = new DirectoryValidator().ensureDirs();
        if (!JNLPRuntime.isHeadless() && ((DirectoryValidator.DirectoryCheckResults)object).getFailures() > 0) {
            JOptionPane.showMessageDialog(null, ((DirectoryValidator.DirectoryCheckResults)object).getMessage());
        }
    }

    private static int moveLegacyToCurrent(String string, String string2) {
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Moving " + string + " to " + string2);
        File file = new File(string2);
        File file2 = new File(string);
        if (file.exists()) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Warning! Destination " + string2 + " exists!");
        }
        if (file2.exists()) {
            boolean bl = file2.renameTo(file);
            return DeploymentConfiguration.resultToStd(bl);
        }
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Source " + string + " do not exists, nothing to do");
        return 0;
    }

    private static int resultToStd(boolean bl) {
        if (bl) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "OK");
            return 0;
        }
        OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "ERROR");
        return 1;
    }

    public static enum ConfigType {
        System,
        User;

    }
}

