/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.net.URL;
import java.util.List;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.util.WeakList;
import net.sourceforge.jnlp.util.logging.OutputController;

public class Resource {
    public static final int UNINITIALIZED = 0;
    public static final int CONNECT = 1;
    public static final int CONNECTING = 2;
    public static final int CONNECTED = 4;
    public static final int DOWNLOAD = 8;
    public static final int DOWNLOADING = 16;
    public static final int DOWNLOADED = 32;
    public static final int ERROR = 64;
    public static final int STARTED = 128;
    private static WeakList<Resource> resources = new WeakList();
    private WeakList<ResourceTracker> trackers = new WeakList();
    URL location;
    private URL downloadLocation;
    File localFile;
    Version requestVersion;
    Version downloadVersion;
    long transferred = 0L;
    long size = -1L;
    int status = 0;
    UpdatePolicy updatePolicy;

    private Resource(URL uRL, Version version, UpdatePolicy updatePolicy) {
        this.location = uRL;
        this.downloadLocation = uRL;
        this.requestVersion = version;
        this.updatePolicy = updatePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getResource(URL uRL, Version version, UpdatePolicy updatePolicy) {
        WeakList<Resource> weakList = resources;
        synchronized (weakList) {
            Resource resource;
            Resource resource2 = new Resource(uRL, version, updatePolicy);
            int n = resources.indexOf(resource2);
            if (n >= 0 && (resource = resources.get(n)) != null) {
                return resource;
            }
            resources.add(resource2);
            resources.trimToSize();
            return resource2;
        }
    }

    public URL getLocation() {
        return this.location;
    }

    public URL getDownloadLocation() {
        return this.downloadLocation;
    }

    public void setDownloadLocation(URL uRL) {
        this.downloadLocation = uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceTracker getTracker() {
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            List<ResourceTracker> list = this.trackers.hardList();
            if (list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
    }

    public boolean isSet(int n) {
        if (n == 0) {
            return this.status == 0;
        }
        return (this.status & n) != 0;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    private String getStatusString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            stringBuffer.append("<> ");
        }
        if ((n & 1) != 0) {
            stringBuffer.append("CONNECT ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("CONNECTING ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("CONNECTED ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("DOWNLOAD ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("DOWNLOADING ");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("DOWNLOADED ");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append("ERROR ");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("STARTED ");
        }
        return stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStatus(int n, int n2) {
        int n3 = 0;
        Resource resource = this;
        synchronized (resource) {
            n3 = this.status;
            this.status &= ~n;
            this.status |= n2;
        }
        if (this.status != n3) {
            OutputController.getLogger().log("Status: " + this.getStatusString(this.status));
            if ((this.status & ~n3) != 0) {
                OutputController.getLogger().log(" +(" + this.getStatusString(this.status & ~n3) + ")");
            }
            if ((~this.status & n3) != 0) {
                OutputController.getLogger().log(" -(" + this.getStatusString(~this.status & n3) + ")");
            }
            OutputController.getLogger().log(" @ " + this.location.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTracker(ResourceTracker resourceTracker) {
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            this.trackers.remove(resourceTracker);
            this.trackers.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTracker(ResourceTracker resourceTracker) {
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            List<ResourceTracker> list = this.trackers.hardList();
            if (!list.contains(resourceTracker)) {
                this.trackers.add(resourceTracker);
            }
            this.trackers.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDownloadEvent() {
        List<ResourceTracker> list;
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            list = this.trackers.hardList();
        }
        for (ResourceTracker resourceTracker : list) {
            resourceTracker.fireDownloadEvent(this);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Resource) {
            return CacheUtil.urlEquals(this.location, ((Resource)object).location);
        }
        return false;
    }

    public String toString() {
        return "location=" + this.location.toString() + " state=" + this.getStatusString(this.status);
    }
}

