/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class NativeLibraryStorage {
    private ResourceTracker tracker;
    private List<File> nativeSearchDirectories = new ArrayList<File>();
    private File jarEntryDirectory = null;
    public static final String[] NATIVE_LIBRARY_EXTENSIONS = new String[]{".so", ".dylib", ".jnilib", ".framework", ".dll"};

    public NativeLibraryStorage(ResourceTracker resourceTracker) {
        this.tracker = resourceTracker;
    }

    public void cleanupTemporaryFolder() {
        if (this.jarEntryDirectory != null) {
            OutputController.getLogger().log("Cleaning up native directory" + this.jarEntryDirectory.getAbsolutePath());
            try {
                FileUtils.recursiveDelete(this.jarEntryDirectory, new File(System.getProperty("java.io.tmpdir")));
                this.jarEntryDirectory = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addSearchDirectory(File file) {
        this.nativeSearchDirectories.add(file);
    }

    public List<File> getSearchDirectories() {
        return this.nativeSearchDirectories;
    }

    public File findLibrary(String string) {
        for (File file : this.getSearchDirectories()) {
            File file2 = new File(file, string);
            if (!file2.exists()) continue;
            return file2;
        }
        return null;
    }

    public void addSearchJar(URL uRL) {
        OutputController.getLogger().log("Activate native: " + uRL);
        File file = this.tracker.getCacheFile(uRL);
        if (file == null) {
            return;
        }
        try {
            JarFile jarFile = new JarFile(file, false);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory()) continue;
                String string = new File(jarEntry.getName()).getName();
                boolean bl = false;
                for (String string2 : NATIVE_LIBRARY_EXTENSIONS) {
                    if (!string.endsWith(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                this.ensureNativeStoreDirectory();
                File file2 = new File(this.jarEntryDirectory, string);
                if (!file2.isFile()) {
                    FileUtils.createRestrictedFile(file2, true);
                }
                CacheUtil.streamCopy(jarFile.getInputStream(jarEntry), new FileOutputStream(file2));
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(iOException);
        }
    }

    void ensureNativeStoreDirectory() {
        if (this.jarEntryDirectory == null) {
            this.jarEntryDirectory = NativeLibraryStorage.createNativeStoreDirectory();
            this.addSearchDirectory(this.jarEntryDirectory);
        }
    }

    private static File createNativeStoreDirectory() {
        int n = (int)((Math.random() * 2.0 - 1.0) * 2.147483647E9);
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "netx-native-" + (n & 0xFFFF));
        File file2 = file.getParentFile();
        if (!file2.isDirectory() && !file2.mkdirs()) {
            return null;
        }
        try {
            FileUtils.createRestrictedDirectory(file);
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

