/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.util.HashMap;
import java.util.Map;
import sun.applet.PluginDebug;

enum PluginObjectStore {
    INSTANCE;

    private final Map<Integer, Object> objects = new HashMap<Integer, Object>();
    private final Map<Integer, Integer> counts = new HashMap<Integer, Integer>();
    private final Map<Object, Integer> identifiers = new HashMap<Object, Integer>();
    private final Object lock = new Object();
    private boolean wrapped = false;
    private int nextUniqueIdentifier = 1;

    public static PluginObjectStore getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Integer n) {
        Object object = this.lock;
        synchronized (object) {
            return this.objects.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIdentifier(Object object) {
        if (object == null) {
            return 0;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            return this.identifiers.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        if (object != null) {
            Object object2 = this.lock;
            synchronized (object2) {
                return this.identifiers.containsKey(object);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int n) {
        Object object = this.lock;
        synchronized (object) {
            return this.objects.containsKey(n);
        }
    }

    private boolean checkNeg() {
        if (this.nextUniqueIdentifier < 1) {
            this.wrapped = true;
            this.nextUniqueIdentifier = 1;
        }
        return this.wrapped;
    }

    private int getNextID() {
        while (this.checkNeg() && this.objects.containsKey(this.nextUniqueIdentifier)) {
            ++this.nextUniqueIdentifier;
        }
        return this.nextUniqueIdentifier++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reference(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            Integer n = this.identifiers.get(object);
            if (n == null) {
                int n2 = this.getNextID();
                this.objects.put(n2, object);
                this.counts.put(n2, 1);
                this.identifiers.put(object, n2);
            } else {
                this.counts.put(n, this.counts.get(n) + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unreference(int n) {
        Object object = this.lock;
        synchronized (object) {
            Integer n2 = this.counts.get(n);
            if (n2 == null) {
                return;
            }
            if (n2 == 1) {
                Object object2 = this.objects.get(n);
                this.objects.remove(n);
                this.counts.remove(n);
                this.identifiers.remove(object2);
            } else {
                this.counts.put(n, n2 - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        Object object = this.lock;
        synchronized (object) {
            if (PluginDebug.DEBUG) {
                for (Map.Entry<Integer, Object> entry : this.objects.entrySet()) {
                    PluginDebug.debug(entry.getKey(), "::", entry.getValue());
                }
            }
        }
    }
}

