/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.util.HashMap;
import net.sourceforge.jnlp.util.logging.OutputController;

public class TimedHashMap<K, V> {
    HashMap<K, V> actualMap = new HashMap();
    HashMap<K, Long> timeStamps = new HashMap();
    Long expiry = 10000000000L;

    public V put(K k, V v) {
        this.timeStamps.put(k, System.nanoTime());
        return this.actualMap.put(k, v);
    }

    public V get(K k) {
        Long l = System.nanoTime();
        if (this.actualMap.containsKey(k)) {
            Long l2 = l - this.timeStamps.get(k);
            if (l2 <= this.expiry) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Returning proxy " + this.actualMap.get(k) + " from cache for " + k);
                this.timeStamps.put(k, System.nanoTime());
                return this.actualMap.get(k);
            }
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Proxy cache for " + k + " has expired (age=" + (double)l2.longValue() * 1.0E-9 + " seconds)");
        }
        return null;
    }
}

