/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sourceforge.jnlp.util.logging.OutputController;

public enum ImageResources {
    INSTANCE;

    private static final String APPLICATION_ICON_PATH = "net/sourceforge/jnlp/resources/netx-icon.png";
    private final Map<String, Image> cache = new HashMap<String, Image>();

    void clearCache() {
        this.cache.clear();
    }

    private Image getApplicationImage() {
        if (this.cache.containsKey(APPLICATION_ICON_PATH)) {
            return this.cache.get(APPLICATION_ICON_PATH);
        }
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        InputStream inputStream = classLoader.getResourceAsStream(APPLICATION_ICON_PATH);
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            this.cache.put(APPLICATION_ICON_PATH, bufferedImage);
            return bufferedImage;
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
            return null;
        }
    }

    public List<Image> getApplicationImages() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        Image image = this.getApplicationImage();
        if (image != null) {
            arrayList.add(image);
        }
        return arrayList;
    }
}

