/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.IOException;
import java.net.URL;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.ManageJnlpResources;

class XDownloadService
implements DownloadService {
    XDownloadService() {
    }

    JNLPClassLoader getClassLoader() {
        return (JNLPClassLoader)JNLPRuntime.getApplication().getClassLoader();
    }

    @Override
    public DownloadServiceListener getDefaultProgressWindow() {
        return null;
    }

    @Override
    public boolean isExtensionPartCached(URL uRL, String string, String string2) {
        boolean bl = true;
        Version version = string == null ? null : new Version(string);
        JARDesc[] jARDescArray = ManageJnlpResources.findJars(this.getClassLoader(), uRL, string2, version);
        if (jARDescArray.length <= 0) {
            return false;
        }
        for (int i = 0; i < jARDescArray.length && bl; ++i) {
            bl = CacheUtil.isCached(jARDescArray[i].getLocation(), version);
        }
        return bl;
    }

    @Override
    public boolean isExtensionPartCached(URL uRL, String string, String[] stringArray) {
        boolean bl = true;
        if (stringArray.length <= 0) {
            return false;
        }
        for (String string2 : stringArray) {
            bl = this.isExtensionPartCached(uRL, string, string2);
        }
        return bl;
    }

    @Override
    public boolean isPartCached(String string) {
        boolean bl = true;
        JARDesc[] jARDescArray = ManageJnlpResources.findJars(this.getClassLoader(), null, string, null);
        if (jARDescArray.length <= 0) {
            return false;
        }
        for (int i = 0; i < jARDescArray.length && bl; ++i) {
            bl = CacheUtil.isCached(jARDescArray[i].getLocation(), null);
        }
        return bl;
    }

    @Override
    public boolean isPartCached(String[] stringArray) {
        boolean bl = true;
        if (stringArray.length <= 0) {
            return false;
        }
        for (String string : stringArray) {
            bl = this.isPartCached(string);
        }
        return bl;
    }

    @Override
    public boolean isResourceCached(URL uRL, String string) {
        return ManageJnlpResources.isExternalResourceCached(this.getClassLoader(), uRL, string);
    }

    @Override
    public void loadExtensionPart(URL uRL, String string, String[] stringArray, DownloadServiceListener downloadServiceListener) throws IOException {
        for (String string2 : stringArray) {
            this.loadExtensionPart(uRL, string, string2, downloadServiceListener);
        }
    }

    @Override
    public void loadExtensionPart(URL uRL, String string, String string2, DownloadServiceListener downloadServiceListener) throws IOException {
        Version version = string == null ? null : new Version(string);
        ManageJnlpResources.downloadJars(this.getClassLoader(), uRL, string2, version);
    }

    @Override
    public void loadPart(String[] stringArray, DownloadServiceListener downloadServiceListener) throws IOException {
        for (String string : stringArray) {
            this.loadPart(string, downloadServiceListener);
        }
    }

    @Override
    public void loadPart(String string, DownloadServiceListener downloadServiceListener) throws IOException {
        ManageJnlpResources.downloadJars(this.getClassLoader(), null, string, null);
    }

    @Override
    public void loadResource(URL uRL, String string, DownloadServiceListener downloadServiceListener) throws IOException {
        ManageJnlpResources.loadExternalResouceToCache(this.getClassLoader(), uRL, string);
    }

    @Override
    public void removeExtensionPart(URL uRL, String string, String string2) throws IOException {
        Version version = string == null ? null : new Version(string);
        JARDesc[] jARDescArray = ManageJnlpResources.findJars(this.getClassLoader(), uRL, string2, version);
        ManageJnlpResources.removeCachedJars(this.getClassLoader(), uRL, jARDescArray);
    }

    @Override
    public void removeExtensionPart(URL uRL, String string, String[] stringArray) throws IOException {
        for (String string2 : stringArray) {
            this.removeExtensionPart(uRL, string, string2);
        }
    }

    @Override
    public void removePart(String string) throws IOException {
        JARDesc[] jARDescArray = ManageJnlpResources.findJars(this.getClassLoader(), null, string, null);
        ManageJnlpResources.removeCachedJars(this.getClassLoader(), null, jARDescArray);
    }

    @Override
    public void removePart(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            this.removePart(string);
        }
    }

    @Override
    public void removeResource(URL uRL, String string) throws IOException {
        ManageJnlpResources.removeExternalCachedResource(this.getClassLoader(), uRL, string);
    }
}

