/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.services.ExtendedSingleInstanceService;
import net.sourceforge.jnlp.services.XServiceManagerStub;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ServiceUtil {
    public static BasicService getBasicService() {
        return (BasicService)ServiceUtil.getService("javax.jnlp.BasicService");
    }

    public static ClipboardService getClipboardService() {
        return (ClipboardService)ServiceUtil.getService("javax.jnlp.ClipboardService");
    }

    public static DownloadService getDownloadService() {
        return (DownloadService)ServiceUtil.getService("javax.jnlp.DownloadService");
    }

    public static ExtensionInstallerService getExtensionInstallerService() {
        return (ExtensionInstallerService)ServiceUtil.getService("javax.jnlp.ExtensionInstallerService");
    }

    public static FileOpenService getFileOpenService() {
        return (FileOpenService)ServiceUtil.getService("javax.jnlp.FileOpenService");
    }

    public static FileSaveService getFileSaveService() {
        return (FileSaveService)ServiceUtil.getService("javax.jnlp.FileSaveService");
    }

    public static PersistenceService getPersistenceService() {
        return (PersistenceService)ServiceUtil.getService("javax.jnlp.PersistenceService");
    }

    public static PrintService getPrintService() {
        return (PrintService)ServiceUtil.getService("javax.jnlp.PrintService");
    }

    public static SingleInstanceService getSingleInstanceService() {
        return (SingleInstanceService)ServiceUtil.getService("javax.jnlp.SingleInstanceService");
    }

    public static void checkExistingSingleInstance(JNLPFile jNLPFile) {
        ExtendedSingleInstanceService extendedSingleInstanceService = (ExtendedSingleInstanceService)ServiceUtil.getSingleInstanceService();
        extendedSingleInstanceService.checkSingleInstanceRunning(jNLPFile);
    }

    private static Object getService(String string) {
        try {
            return ServiceManager.lookup(string);
        }
        catch (UnavailableServiceException unavailableServiceException) {
            return null;
        }
    }

    static Object createPrivilegedProxy(Class<?> clazz, Object object) {
        return Proxy.newProxyInstance(XServiceManagerStub.class.getClassLoader(), new Class[]{clazz}, new PrivilegedHandler(object));
    }

    public static boolean checkAccess(SecurityDialogs.AccessType accessType, Object ... objectArray) {
        return ServiceUtil.checkAccess(null, accessType, objectArray);
    }

    public static boolean checkAccess(ApplicationInstance applicationInstance, SecurityDialogs.AccessType accessType, Object ... objectArray) {
        boolean bl = ServiceUtil.isSigned(applicationInstance);
        if (!bl) {
            if (!ServiceUtil.shouldPromptUser()) {
                return false;
            }
            if (applicationInstance == null) {
                applicationInstance = JNLPRuntime.getApplication();
            }
            final SecurityDialogs.AccessType accessType2 = accessType;
            final Object[] objectArray2 = objectArray;
            final ApplicationInstance applicationInstance2 = applicationInstance;
            Boolean bl2 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean bl = SecurityDialogs.showAccessWarningDialog(accessType2, applicationInstance2.getJNLPFile(), objectArray2);
                    return bl;
                }
            });
            return bl2;
        }
        return true;
    }

    private static boolean shouldPromptUser() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.security.sandbox.jnlp.enhanced"));
            }
        });
    }

    public static boolean isSigned(ApplicationInstance applicationInstance) {
        if (applicationInstance == null) {
            applicationInstance = JNLPRuntime.getApplication();
        }
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(stackTraceElementArray[i].getClassName());
            }
            catch (Exception exception) {
                OutputController.getLogger().log(exception);
                try {
                    clazz = Class.forName(stackTraceElementArray[i].getClassName(), false, applicationInstance.getClassLoader());
                }
                catch (Exception exception2) {
                    OutputController.getLogger().log(exception2);
                }
            }
            if (clazz != null && (clazz.getProtectionDomain().getCodeSource() == null || clazz.getProtectionDomain().getCodeSource().getCodeSigners() != null)) continue;
            return false;
        }
        return true;
    }

    private static class PrivilegedHandler
    implements InvocationHandler {
        private final Object receiver;

        PrivilegedHandler(Object object) {
            this.receiver = object;
        }

        @Override
        public Object invoke(Object object, final Method method, final Object[] objectArray) throws Throwable {
            if (JNLPRuntime.isDebug()) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "call privileged method: " + method.getName());
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "           arg: " + objectArray[i]);
                    }
                }
            }
            PrivilegedExceptionAction<Object> privilegedExceptionAction = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return method.invoke(PrivilegedHandler.this.receiver, objectArray);
                }
            };
            try {
                Object object2 = AccessController.doPrivileged(privilegedExceptionAction);
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "        result: " + object2);
                return object2;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getCause() instanceof InvocationTargetException) {
                    throw privilegedActionException.getCause().getCause();
                }
                throw privilegedActionException.getCause();
            }
        }
    }
}

