/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertsInfoPane;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityUtil;

public class SingleCertInfoPane
extends CertsInfoPane {
    public SingleCertInfoPane(SecurityDialog securityDialog, CertVerifier certVerifier) {
        super(securityDialog, certVerifier);
    }

    @Override
    protected void buildTree() {
        X509Certificate x509Certificate = this.parent.getCert();
        String string = SecurityUtil.getCN(x509Certificate.getSubjectX500Principal().getName());
        String string2 = SecurityUtil.getCN(x509Certificate.getIssuerX500Principal().getName());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string + " (" + string2 + ")");
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new CertsInfoPane.TreeSelectionHandler());
    }

    @Override
    protected void populateTable() {
        X509Certificate x509Certificate = this.parent.getCert();
        this.certNames = new String[1];
        this.certsData = new ArrayList();
        this.certsData.add(this.parseCert(x509Certificate));
        this.certNames[0] = SecurityUtil.getCN(x509Certificate.getSubjectX500Principal().getName()) + " (" + SecurityUtil.getCN(x509Certificate.getIssuerX500Principal().getName()) + ")";
    }
}

