/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.security.cert.CertPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.AppVerifier;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.tools.CertInformation;
import net.sourceforge.jnlp.tools.JarCertVerifier;

public class PluginAppVerifier
implements AppVerifier {
    @Override
    public boolean hasAlreadyTrustedPublisher(Map<CertPath, CertInformation> map, Map<String, Integer> map2) {
        boolean bl = true;
        for (String string : map2.keySet()) {
            int n = map2.get(string);
            boolean bl2 = false;
            for (CertInformation certInformation : map.values()) {
                if (!certInformation.isSignerOfJar(string) || n != certInformation.getNumJarEntriesSigned(string) || !certInformation.isPublisherAlreadyTrusted()) continue;
                bl2 = true;
                break;
            }
            bl &= bl2;
        }
        return bl;
    }

    @Override
    public boolean hasRootInCacerts(Map<CertPath, CertInformation> map, Map<String, Integer> map2) {
        boolean bl = true;
        for (String string : map2.keySet()) {
            int n = map2.get(string);
            boolean bl2 = false;
            for (CertInformation certInformation : map.values()) {
                if (!certInformation.isSignerOfJar(string) || n != certInformation.getNumJarEntriesSigned(string) || !certInformation.isRootInCacerts()) continue;
                bl2 = true;
                break;
            }
            bl &= bl2;
        }
        return bl;
    }

    @Override
    public boolean isFullySigned(Map<CertPath, CertInformation> map, Map<String, Integer> map2) {
        boolean bl = true;
        for (String string : map2.keySet()) {
            int n = map2.get(string);
            boolean bl2 = false;
            for (CertInformation certInformation : map.values()) {
                if (!certInformation.isSignerOfJar(string) || n != certInformation.getNumJarEntriesSigned(string)) continue;
                bl2 = true;
                break;
            }
            bl &= bl2;
        }
        return bl;
    }

    @Override
    public void checkTrustWithUser(JarCertVerifier jarCertVerifier, JNLPFile jNLPFile) throws LaunchException {
        List<CertPath> list = this.buildCertPathsList(jarCertVerifier);
        ArrayList<CertPath> arrayList = new ArrayList<CertPath>();
        for (String string : jarCertVerifier.getJarSignableEntries().keySet()) {
            CertInformation certInformation;
            boolean bl = false;
            for (CertPath certPath : arrayList) {
                jarCertVerifier.setCurrentlyUsedCertPath(certPath);
                certInformation = jarCertVerifier.getCertInformation(certPath);
                if (!certInformation.isSignerOfJar(string) || !arrayList.contains(certPath)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            for (CertPath certPath : list) {
                jarCertVerifier.setCurrentlyUsedCertPath(certPath);
                certInformation = jarCertVerifier.getCertInformation(certPath);
                if (!certInformation.isSignerOfJar(string)) continue;
                if (certInformation.isPublisherAlreadyTrusted()) {
                    bl = true;
                    arrayList.add(certPath);
                    break;
                }
                SecurityDialogs.AccessType accessType = certInformation.isRootInCacerts() && !certInformation.hasSigningIssues() ? SecurityDialogs.AccessType.VERIFIED : (certInformation.isRootInCacerts() ? SecurityDialogs.AccessType.SIGNING_ERROR : SecurityDialogs.AccessType.UNVERIFIED);
                boolean bl2 = SecurityDialogs.showCertWarningDialog(accessType, jNLPFile, jarCertVerifier);
                if (!bl2) continue;
                arrayList.add(certPath);
                bl = true;
                break;
            }
            if (bl) continue;
            throw new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCancelOnUserRequest"), "");
        }
    }

    public List<CertPath> buildCertPathsList(JarCertVerifier jarCertVerifier) {
        List<CertPath> list = jarCertVerifier.getCertsList();
        ArrayList<CertPath> arrayList = new ArrayList<CertPath>();
        for (CertPath certPath : list) {
            if (arrayList.contains(certPath) || !jarCertVerifier.getCertInformation(certPath).isPublisherAlreadyTrusted()) continue;
            arrayList.add(certPath);
        }
        for (CertPath certPath : list) {
            if (arrayList.contains(certPath) || !jarCertVerifier.getCertInformation(certPath).isRootInCacerts() || jarCertVerifier.getCertInformation(certPath).hasSigningIssues()) continue;
            arrayList.add(certPath);
        }
        for (CertPath certPath : list) {
            if (arrayList.contains(certPath) || !jarCertVerifier.getCertInformation(certPath).isRootInCacerts() || !jarCertVerifier.getCertInformation(certPath).hasSigningIssues()) continue;
            arrayList.add(certPath);
        }
        for (CertPath certPath : list) {
            if (arrayList.contains(certPath)) continue;
            arrayList.add(certPath);
        }
        return arrayList;
    }
}

