/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.util.FileUtils;
import sun.misc.Launcher;

public class AccessWarningPane
extends SecurityDialogPanel {
    JCheckBox alwaysAllow;
    Object[] extras;

    public AccessWarningPane(SecurityDialog securityDialog, CertVerifier certVerifier) {
        super(securityDialog, certVerifier);
        this.addComponents();
    }

    public AccessWarningPane(SecurityDialog securityDialog, Object[] objectArray, CertVerifier certVerifier) {
        super(securityDialog, certVerifier);
        this.extras = objectArray;
        this.addComponents();
    }

    private void addComponents() {
        SecurityDialogs.AccessType accessType = this.parent.getAccessType();
        JNLPFile jNLPFile = this.parent.getFile();
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            string = jNLPFile.getInformation().getTitle() != null ? jNLPFile.getInformation().getTitle() : Translator.R("SNoAssociatedCertificate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string2 = jNLPFile.getInformation().getVendor() != null ? jNLPFile.getInformation().getVendor() + " " + Translator.R("SUnverified") : Translator.R("SNoAssociatedCertificate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string3 = !jNLPFile.getInformation().getHomepage().toString().equals("") ? jNLPFile.getInformation().getHomepage().toString() : jNLPFile.getSourceLocation().getAuthority();
        }
        catch (Exception exception) {
            string3 = jNLPFile.getSourceLocation().getAuthority();
        }
        String string4 = "";
        switch (accessType) {
            case READ_FILE: {
                if (this.extras != null && this.extras.length > 0 && this.extras[0] instanceof String) {
                    string4 = Translator.R("SFileReadAccess", FileUtils.displayablePath((String)this.extras[0]));
                    break;
                }
                string4 = Translator.R("SFileReadAccess", Translator.R("AFileOnTheMachine"));
                break;
            }
            case WRITE_FILE: {
                if (this.extras != null && this.extras.length > 0 && this.extras[0] instanceof String) {
                    string4 = Translator.R("SFileWriteAccess", FileUtils.displayablePath((String)this.extras[0]));
                    break;
                }
                string4 = Translator.R("SFileWriteAccess", Translator.R("AFileOnTheMachine"));
                break;
            }
            case CREATE_DESTKOP_SHORTCUT: {
                string4 = Translator.R("SDesktopShortcut");
                break;
            }
            case CLIPBOARD_READ: {
                string4 = Translator.R("SClipboardReadAccess");
                break;
            }
            case CLIPBOARD_WRITE: {
                string4 = Translator.R("SClipboardWriteAccess");
                break;
            }
            case PRINTER: {
                string4 = Translator.R("SPrinterAccess");
                break;
            }
            case NETWORK: {
                string4 = this.extras != null && this.extras.length >= 0 ? Translator.R("SNetworkAccess", this.extras[0]) : Translator.R("SNetworkAccess", "(address here)");
            }
        }
        ImageIcon imageIcon = new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/question.png"));
        JLabel jLabel = new JLabel(this.htmlWrap(string4), imageIcon, 2);
        jLabel.setFont(new Font(jLabel.getFont().toString(), 1, 12));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.add((Component)jLabel, "Center");
        jPanel.setPreferredSize(new Dimension(450, 100));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel2 = new JLabel(Translator.R("Name") + ":   " + string);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel3 = new JLabel(Translator.R("Publisher") + ": " + string2);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel4 = new JLabel(Translator.R("From") + ":   " + string3);
        jLabel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.alwaysAllow = new JCheckBox(Translator.R("AlwaysAllowAction"));
        this.alwaysAllow.setEnabled(false);
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1));
        jPanel2.add(jLabel2);
        jPanel2.add(jLabel3);
        jPanel2.add(jLabel4);
        jPanel2.add(this.alwaysAllow);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Translator.R("ButAllow"));
        JButton jButton2 = new JButton(Translator.R("ButCancel"));
        jButton.addActionListener(this.createSetValueListener(this.parent, 0));
        jButton.addActionListener(new CheckBoxListener());
        jButton2.addActionListener(this.createSetValueListener(this.parent, 1));
        this.initialFocusComponent = jButton2;
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AccessWarningPane.this.alwaysAllow == null || AccessWarningPane.this.alwaysAllow.isSelected()) {
                // empty if block
            }
        }
    }
}

