/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.Launcher;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.about.AboutDialog;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.viewer.CertificateViewer;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public final class Boot
implements PrivilegedAction<Void> {
    public static final String name = Boot.class.getPackage().getImplementationTitle();
    public static final String version = Boot.class.getPackage().getImplementationVersion();
    private static final String miniLicense = "\n   netx - an open-source JNLP client.\n   Copyright (C) 2001-2003 Jon A. Maxwell (JAM)\n\n   // This library is free software; you can redistribute it and/or\n   modify it under the terms of the GNU Lesser General Public\n   License as published by the Free Software Foundation; either\n   version 2.1 of the License, or (at your option) any later version.\n\n   This library is distributed in the hope that it will be useful,\n   but WITHOUT ANY WARRANTY; without even the implied warranty of\n   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n   Lesser General Public License for more details.\n\n   You should have received a copy of the GNU Lesser General Public\n   License along with this library; if not, write to the Free Software\n   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n";
    private static final String itwInfoMessage = "" + name + " " + version + "\n\n*  " + Translator.R("BAboutITW") + "\n*  " + Translator.R("BFileInfoAuthors") + "\n*  " + Translator.R("BFileInfoNews") + "\n*  " + Translator.R("BFileInfoCopying");
    private static final String helpMessage = "\nUsage:   " + Translator.R("BOUsage") + "\n" + "         " + Translator.R("BOUsage2") + "\n" + "\n" + "control-options:" + "\n" + "  -about                " + Translator.R("BOAbout") + "\n" + "  -viewer               " + Translator.R("BOViewer") + "\n" + "\n" + "run-options:" + "\n" + "  -arg arg              " + Translator.R("BOArg") + "\n" + "  -param name=value     " + Translator.R("BOParam") + "\n" + "  -property name=value  " + Translator.R("BOProperty") + "\n" + "  -update seconds       " + Translator.R("BOUpdate") + "\n" + "  -license              " + Translator.R("BOLicense") + "\n" + "  -verbose              " + Translator.R("BOVerbose") + "\n" + "  -nosecurity           " + Translator.R("BONosecurity") + "\n" + "  -noupdate             " + Translator.R("BONoupdate") + "\n" + "  -headless             " + Translator.R("BOHeadless") + "\n" + "  -strict               " + Translator.R("BOStrict") + "\n" + "  -xml                  " + Translator.R("BOXml") + "\n" + "  -Xnofork              " + Translator.R("BXnofork") + "\n" + "  -Xclearcache          " + Translator.R("BXclearcache") + "\n" + "  -Xignoreheaders       " + Translator.R("BXignoreheaders") + "\n" + "  -help                 " + Translator.R("BOHelp") + "\n";
    private static final String doubleArgs = "-basedir -jnlp -arg -param -property -update";
    private static String[] args;

    public static void main(String[] stringArray) {
        args = stringArray;
        if (AppContext.getAppContext() == null) {
            SunToolkit.createNewAppContext();
        }
        if (null != Boot.getOption("-headless")) {
            JNLPRuntime.setHeadless(true);
        }
        DeploymentConfiguration.move14AndOlderFilesTo15StructureCatched();
        if (null != Boot.getOption("-viewer")) {
            try {
                CertificateViewer.main(null);
                JNLPRuntime.exit(0);
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            }
        }
        if (null != Boot.getOption("-license")) {
            OutputController.getLogger().printOutLn(miniLicense);
            JNLPRuntime.exit(0);
        }
        if (null != Boot.getOption("-help")) {
            OutputController.getLogger().printOutLn(helpMessage);
            JNLPRuntime.exit(0);
        }
        if (null != Boot.getOption("-about")) {
            OutputController.getLogger().printOutLn(itwInfoMessage);
            if (null != Boot.getOption("-headless")) {
                JNLPRuntime.exit(0);
            } else {
                OutputController.getLogger().printOutLn(Translator.R("BLaunchAbout"));
                AboutDialog.display();
                return;
            }
        }
        if (null != Boot.getOption("-verbose")) {
            JNLPRuntime.setDebug(true);
        }
        if (null != Boot.getOption("-update")) {
            int n = Integer.parseInt(Boot.getOption("-update"));
            JNLPRuntime.setDefaultUpdatePolicy(new UpdatePolicy((long)n * 1000L));
        }
        if (null != Boot.getOption("-noupdate")) {
            JNLPRuntime.setDefaultUpdatePolicy(UpdatePolicy.NEVER);
        }
        if (null != Boot.getOption("-Xnofork")) {
            JNLPRuntime.setForksAllowed(false);
        }
        if (null != Boot.getOption("-Xtrustall")) {
            JNLPRuntime.setTrustAll(true);
        }
        if (null != Boot.getOption("-Xignoreheaders")) {
            JNLPRuntime.setIgnoreHeaders(true);
        }
        JNLPRuntime.setInitialArgments(Arrays.asList(stringArray));
        AccessController.doPrivileged(new Boot());
    }

    @Override
    public Void run() {
        JNLPRuntime.setSecurityEnabled(null == Boot.getOption("-nosecurity"));
        JNLPRuntime.initialize(true);
        if (null != Boot.getOption("-Xclearcache")) {
            CacheUtil.clearCache();
            return null;
        }
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("arguments", Boot.getOptions("-arg"));
        hashMap.put("parameters", Boot.getOptions("-param"));
        hashMap.put("properties", Boot.getOptions("-property"));
        ParserSettings parserSettings = ParserSettings.setGlobalParserSettingsFromArgs(args);
        try {
            Launcher launcher2 = new Launcher(false);
            launcher2.setParserSettings(parserSettings);
            launcher2.setInformationToMerge(hashMap);
            launcher2.launch(Boot.getFileLocation());
        }
        catch (LaunchException launchException) {
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
            Boot.fatalError(Translator.R("RUnexpected", exception.toString(), exception.getStackTrace()[0]));
        }
        return null;
    }

    private static void fatalError(String string) {
        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "netx: " + string);
        JNLPRuntime.exit(1);
    }

    private static URL getFileLocation() {
        String string = Boot.getJNLPFile();
        if (string == null) {
            OutputController.getLogger().printOutLn(helpMessage);
            JNLPRuntime.exit(1);
        }
        OutputController.getLogger().log(Translator.R("BFileLoc") + ": " + string);
        URL uRL = null;
        try {
            uRL = new File(string).exists() ? new File(string).toURL() : new URL(ServiceUtil.getBasicService().getCodeBase(), string);
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
            Boot.fatalError("Invalid jnlp file " + string);
        }
        return uRL;
    }

    private static String getJNLPFile() {
        if (args.length == 0) {
            OutputController.getLogger().printOutLn(helpMessage);
            JNLPRuntime.exit(0);
        } else {
            if (args.length == 1) {
                return args[args.length - 1];
            }
            String string = args[args.length - 1];
            String string2 = args[args.length - 2];
            if (doubleArgs.indexOf(string2) == -1) {
                return string;
            }
            OutputController.getLogger().printOutLn(helpMessage);
            JNLPRuntime.exit(0);
        }
        return null;
    }

    private static String getOption(String string) {
        String[] stringArray = Boot.getOptions(string);
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    private static String[] getOptions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (string.equals(args[i])) {
                if (-1 == doubleArgs.indexOf(string)) {
                    arrayList.add(string);
                } else if (i + 1 < args.length) {
                    arrayList.add(args[i + 1]);
                }
            }
            if (!args[i].startsWith("-") || -1 == doubleArgs.indexOf(args[i])) continue;
            ++i;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

