/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.Container;
import java.awt.SplashScreen;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.text.html.parser.ParserDelegator;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.StreamEater;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.services.InstanceExistsException;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.splashscreen.SplashUtils;
import net.sourceforge.jnlp.util.JarFile;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.awt.SunToolkit;

public class Launcher {
    static final ThreadGroup mainGroup = new ThreadGroup(Translator.R("LAllThreadGroup"));
    private LaunchHandler handler = null;
    private UpdatePolicy updatePolicy = JNLPRuntime.getDefaultUpdatePolicy();
    private boolean context = true;
    private boolean exitOnFailure = true;
    private ParserSettings parserSettings = new ParserSettings();
    private Map<String, String[]> extra = null;

    public Launcher() {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
    }

    public Launcher(boolean bl) {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
        this.exitOnFailure = bl;
    }

    public Launcher(LaunchHandler launchHandler) {
        this(launchHandler, null);
    }

    public Launcher(LaunchHandler launchHandler, UpdatePolicy updatePolicy) {
        if (updatePolicy == null) {
            updatePolicy = JNLPRuntime.getDefaultUpdatePolicy();
        }
        this.handler = launchHandler;
        this.updatePolicy = updatePolicy;
    }

    public void setUpdatePolicy(UpdatePolicy updatePolicy) {
        if (updatePolicy == null) {
            throw new IllegalArgumentException(Translator.R("LNullUpdatePolicy"));
        }
        this.updatePolicy = updatePolicy;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setCreateAppContext(boolean bl) {
        this.context = bl;
    }

    public boolean isCreateAppContext() {
        return this.context;
    }

    public void setParserSettings(ParserSettings parserSettings) {
        this.parserSettings = parserSettings;
    }

    public void setInformationToMerge(Map<String, String[]> map) {
        this.extra = map;
    }

    public ApplicationInstance launch(JNLPFile jNLPFile) throws LaunchException {
        return this.launch(jNLPFile, null);
    }

    public ApplicationInstance launch(JNLPFile jNLPFile, Container container) throws LaunchException {
        this.mergeExtraInformation(jNLPFile, this.extra);
        JNLPRuntime.markNetxRunning();
        if (!jNLPFile.getInformation().isOfflineAllowed()) {
            try {
                InetAddress.getByName(jNLPFile.getSourceLocation().getHost());
            }
            catch (UnknownHostException unknownHostException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "File cannot be launched because offline-allowed tag not specified and system currently offline.");
                return null;
            }
            catch (Exception exception) {
                OutputController.getLogger().log(exception);
            }
        }
        TgThread tgThread = jNLPFile instanceof PluginBridge && container != null ? new TgThread(jNLPFile, container, true) : (container == null ? new TgThread(jNLPFile) : new TgThread(jNLPFile, container));
        tgThread.start();
        try {
            tgThread.join();
        }
        catch (InterruptedException interruptedException) {
            throw this.launchWarning(new LaunchException(jNLPFile, interruptedException, Translator.R("LSMinor"), Translator.R("LCSystem"), Translator.R("LThreadInterrupted"), Translator.R("LThreadInterruptedInfo")));
        }
        if (tgThread.getException() != null) {
            throw tgThread.getException();
        }
        if (this.handler != null) {
            this.handler.launchCompleted(tgThread.getApplication());
        }
        return tgThread.getApplication();
    }

    public ApplicationInstance launch(URL uRL) throws LaunchException {
        return this.launch(this.fromUrl(uRL));
    }

    private void mergeExtraInformation(JNLPFile jNLPFile, Map<String, String[]> map) throws LaunchException {
        String[] stringArray;
        String[] stringArray2;
        if (map == null) {
            return;
        }
        String[] stringArray3 = map.get("properties");
        if (stringArray3 != null) {
            this.addProperties(jNLPFile, stringArray3);
        }
        if ((stringArray2 = map.get("arguments")) != null && jNLPFile.isApplication()) {
            this.addArguments(jNLPFile, stringArray2);
        }
        if ((stringArray = map.get("parameters")) != null && jNLPFile.isApplet()) {
            this.addParameters(jNLPFile, stringArray);
        }
    }

    private void addProperties(JNLPFile jNLPFile, String[] stringArray) throws LaunchException {
        ResourcesDesc resourcesDesc = jNLPFile.getResources();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("=");
            if (n == -1) {
                throw this.launchError(new LaunchException(Translator.R("BBadProp", stringArray[i])));
            }
            String string = stringArray[i].substring(0, n);
            String string2 = stringArray[i].substring(n + 1, stringArray[i].length());
            resourcesDesc.addResource(new PropertyDesc(string, string2));
        }
    }

    private void addParameters(JNLPFile jNLPFile, String[] stringArray) throws LaunchException {
        AppletDesc appletDesc = jNLPFile.getApplet();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("=");
            if (n == -1) {
                throw this.launchError(new LaunchException(Translator.R("BBadParam", stringArray[i])));
            }
            String string = stringArray[i].substring(0, n);
            String string2 = stringArray[i].substring(n + 1, stringArray[i].length());
            appletDesc.addParameter(string, string2);
        }
    }

    private void addArguments(JNLPFile jNLPFile, String[] stringArray) {
        ApplicationDesc applicationDesc = jNLPFile.getApplication();
        for (int i = 0; i < stringArray.length; ++i) {
            applicationDesc.addArgument(stringArray[i]);
        }
    }

    public void launchExternal(List<String> list, JNLPFile jNLPFile, List<String> list2) throws LaunchException {
        LinkedList<String> linkedList = new LinkedList<String>(list2);
        if (jNLPFile.getFileLocation() != null) {
            linkedList.add(jNLPFile.getFileLocation().toString());
        } else if (jNLPFile.getSourceLocation() != null) {
            linkedList.add(jNLPFile.getFileLocation().toString());
        } else {
            this.launchError(new LaunchException(jNLPFile, null, Translator.R("LSFatal"), Translator.R("LCExternalLaunch"), Translator.R("LNullLocation"), Translator.R("LNullLocationInfo")));
        }
        this.launchExternal(list, linkedList);
    }

    public void launchExternal(URL uRL) throws LaunchException {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(uRL.toString());
        this.launchExternal(new LinkedList<String>(), linkedList);
    }

    public void launchExternal(List<String> list, List<String> list2) throws LaunchException {
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            String string = System.getProperty("icedtea-web.bin.location");
            linkedList.add(string);
            for (String object2 : list) {
                linkedList.add("-J" + object2);
            }
            linkedList.addAll(list2);
            String[] stringArray = linkedList.toArray(new String[0]);
            Process process = Runtime.getRuntime().exec(stringArray);
            new StreamEater(process.getErrorStream()).start();
            new StreamEater(process.getInputStream()).start();
            process.getOutputStream().close();
        }
        catch (NullPointerException nullPointerException) {
            throw this.launchError(new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCExternalLaunch"), Translator.R("LNetxJarMissing"), Translator.R("LNetxJarMissingInfo")));
        }
        catch (Exception exception) {
            throw this.launchError(new LaunchException(null, exception, Translator.R("LSFatal"), Translator.R("LCExternalLaunch"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")));
        }
    }

    private JNLPFile fromUrl(URL uRL) throws LaunchException {
        try {
            JNLPFile jNLPFile = new JNLPFile(uRL, this.parserSettings);
            boolean bl = false;
            boolean bl2 = false;
            if ("file".equalsIgnoreCase(uRL.getProtocol()) && new File(uRL.getFile()).exists()) {
                bl = true;
            }
            if (jNLPFile.getSourceLocation() != null) {
                bl2 = true;
            }
            if (bl && bl2) {
                jNLPFile = new JNLPFile(jNLPFile.getSourceLocation(), this.parserSettings);
            }
            return jNLPFile;
        }
        catch (Exception exception) {
            if (exception instanceof LaunchException) {
                throw (LaunchException)exception;
            }
            throw this.launchError(new LaunchException(null, exception, Translator.R("LSFatal"), Translator.R("LCReadError"), Translator.R("LCantRead"), Translator.R("LCantReadInfo")));
        }
    }

    protected ApplicationInstance launchApplication(JNLPFile jNLPFile) throws LaunchException {
        if (!jNLPFile.isApplication()) {
            throw this.launchError(new LaunchException(jNLPFile, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotApplication"), Translator.R("LNotApplicationInfo")));
        }
        try {
            Object[] objectArray;
            Object object;
            Object object2;
            try {
                ServiceUtil.checkExistingSingleInstance(jNLPFile);
            }
            catch (InstanceExistsException instanceExistsException) {
                OutputController.getLogger().log("Single instance application is already running.");
                return null;
            }
            if (JNLPRuntime.getForksAllowed() && jNLPFile.needsNewVM()) {
                Object object3;
                if (!JNLPRuntime.isHeadless() && (object3 = SplashScreen.getSplashScreen()) != null) {
                    ((SplashScreen)object3).close();
                }
                object3 = new LinkedList();
                object3.add("-Xnofork");
                object3.addAll(JNLPRuntime.getInitialArguments());
                this.launchExternal(jNLPFile.getNewVMArgs(), (List<String>)object3);
                return null;
            }
            this.handler.launchInitialized(jNLPFile);
            ApplicationInstance applicationInstance = this.createApplication(jNLPFile);
            applicationInstance.initialize();
            String string = jNLPFile.getApplication().getMainClass();
            if (string == null && (object2 = CacheUtil.getCacheFile(((JARDesc)(object = jNLPFile.getResources().getMainJAR())).getLocation(), null)) != null) {
                objectArray = new JarFile((File)object2);
                string = objectArray.getManifest().getMainAttributes().getValue("Main-Class");
            }
            if (string == null) {
                throw this.launchError(new LaunchException(jNLPFile, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LCantDetermineMainClass"), Translator.R("LCantDetermineMainClassInfo")));
            }
            object = applicationInstance.getClassLoader().loadClass(string);
            object2 = ((Class)object).getMethod("main", String[].class);
            objectArray = jNLPFile.getApplication().getArguments();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
            this.setContextClassLoaderForAllThreads(applicationInstance.getThreadGroup(), applicationInstance.getClassLoader());
            this.handler.launchStarting(applicationInstance);
            ((AccessibleObject)object2).setAccessible(true);
            OutputController.getLogger().log("Invoking main() with args: " + Arrays.toString(objectArray));
            ((Method)object2).invoke(null, new Object[]{objectArray});
            return applicationInstance;
        }
        catch (LaunchException launchException) {
            throw this.launchError(launchException);
        }
        catch (Exception exception) {
            throw this.launchError(new LaunchException(jNLPFile, exception, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")));
        }
    }

    private void setContextClassLoaderForAllThreads(ThreadGroup threadGroup, ClassLoader classLoader) {
        Thread[] threadArray;
        int n = threadGroup.activeCount();
        do {
            threadArray = new Thread[n *= 2];
            threadGroup.enumerate(threadArray, true);
        } while (threadArray[n - 1] != null);
        for (Thread thread : threadArray) {
            if (thread == null) continue;
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Setting " + classLoader + " as the classloader for thread " + thread.getName());
            thread.setContextClassLoader(classLoader);
        }
    }

    protected ApplicationInstance launchApplet(JNLPFile jNLPFile, boolean bl, Container container) throws LaunchException {
        Object object;
        if (!jNLPFile.isApplet()) {
            throw this.launchError(new LaunchException(jNLPFile, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotApplet"), Translator.R("LNotAppletInfo")));
        }
        if (JNLPRuntime.getForksAllowed() && jNLPFile.needsNewVM() && !JNLPRuntime.isHeadless() && (object = SplashScreen.getSplashScreen()) != null) {
            ((SplashScreen)object).close();
        }
        if (this.handler != null) {
            this.handler.launchInitialized(jNLPFile);
        }
        object = null;
        try {
            ServiceUtil.checkExistingSingleInstance(jNLPFile);
            object = this.createApplet(jNLPFile, bl, container);
            ((ApplicationInstance)object).initialize();
            ((AppletInstance)object).getAppletEnvironment().startApplet();
            Object object2 = object;
            return object2;
        }
        catch (InstanceExistsException instanceExistsException) {
            OutputController.getLogger().log("Single instance applet is already running.");
            throw this.launchError(new LaunchException(jNLPFile, instanceExistsException, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LSingleInstanceExists")), (AppletInstance)object);
        }
        catch (LaunchException launchException) {
            throw this.launchError(launchException, (AppletInstance)object);
        }
        catch (Exception exception) {
            throw this.launchError(new LaunchException(jNLPFile, exception, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")), (AppletInstance)object);
        }
        finally {
            if (this.handler != null) {
                this.handler.launchStarting((ApplicationInstance)object);
            }
        }
    }

    protected ApplicationInstance getApplet(JNLPFile jNLPFile, boolean bl, Container container) throws LaunchException {
        if (!jNLPFile.isApplet()) {
            throw this.launchError(new LaunchException(jNLPFile, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotApplet"), Translator.R("LNotAppletInfo")));
        }
        AppletInstance appletInstance = null;
        try {
            ServiceUtil.checkExistingSingleInstance(jNLPFile);
            appletInstance = this.createApplet(jNLPFile, bl, container);
            appletInstance.initialize();
            return appletInstance;
        }
        catch (InstanceExistsException instanceExistsException) {
            OutputController.getLogger().log("Single instance applet is already running.");
            throw this.launchError(new LaunchException(jNLPFile, instanceExistsException, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LSingleInstanceExists")), appletInstance);
        }
        catch (LaunchException launchException) {
            throw this.launchError(launchException, appletInstance);
        }
        catch (Exception exception) {
            throw this.launchError(new LaunchException(jNLPFile, exception, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")), appletInstance);
        }
    }

    protected ApplicationInstance launchInstaller(JNLPFile jNLPFile) throws LaunchException {
        throw this.launchError(new LaunchException(jNLPFile, null, Translator.R("LSFatal"), Translator.R("LCNotSupported"), Translator.R("LNoInstallers"), Translator.R("LNoInstallersInfo")));
    }

    protected AppletInstance createApplet(JNLPFile jNLPFile, boolean bl, Container container) throws LaunchException {
        AppletInstance appletInstance = null;
        try {
            JNLPClassLoader jNLPClassLoader = JNLPClassLoader.getInstance(jNLPFile, this.updatePolicy);
            if (bl) {
                jNLPClassLoader.enableCodeBase();
            } else if (jNLPFile.getResources().getJARs().length == 0) {
                throw new ClassNotFoundException("Can't do a codebase look up and there are no jars. Failing sooner rather than later");
            }
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            appletInstance = container == null ? new AppletInstance(jNLPFile, threadGroup, jNLPClassLoader, null) : new AppletInstance(jNLPFile, threadGroup, jNLPClassLoader, null, container);
            jNLPClassLoader.setApplication(appletInstance);
            String string = jNLPFile.getApplet().getMainClass();
            Class<?> clazz = jNLPClassLoader.loadClass(string);
            Applet applet = (Applet)clazz.newInstance();
            applet.setStub((AppletStub)((Object)container));
            appletInstance.setApplet(applet);
            appletInstance.getAppletEnvironment().setApplet(applet);
            this.setContextClassLoaderForAllThreads(appletInstance.getThreadGroup(), appletInstance.getClassLoader());
            return appletInstance;
        }
        catch (Exception exception) {
            throw this.launchError(new LaunchException(jNLPFile, exception, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LInitApplet"), Translator.R("LInitAppletInfo")), appletInstance);
        }
    }

    protected Applet createAppletObject(JNLPFile jNLPFile, boolean bl, Container container) throws LaunchException {
        try {
            JNLPClassLoader jNLPClassLoader = JNLPClassLoader.getInstance(jNLPFile, this.updatePolicy);
            if (bl) {
                jNLPClassLoader.enableCodeBase();
            } else if (jNLPFile.getResources().getJARs().length == 0) {
                throw new ClassNotFoundException("Can't do a codebase look up and there are no jars. Failing sooner rather than later");
            }
            String string = jNLPFile.getApplet().getMainClass();
            Class<?> clazz = jNLPClassLoader.loadClass(string);
            Applet applet = (Applet)clazz.newInstance();
            return applet;
        }
        catch (Exception exception) {
            throw this.launchError(new LaunchException(jNLPFile, exception, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LInitApplet"), Translator.R("LInitAppletInfo")));
        }
    }

    protected ApplicationInstance createApplication(JNLPFile jNLPFile) throws LaunchException {
        try {
            JNLPClassLoader jNLPClassLoader = JNLPClassLoader.getInstance(jNLPFile, this.updatePolicy);
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            ApplicationInstance applicationInstance = new ApplicationInstance(jNLPFile, threadGroup, jNLPClassLoader);
            jNLPClassLoader.setApplication(applicationInstance);
            return applicationInstance;
        }
        catch (Exception exception) {
            throw new LaunchException(jNLPFile, exception, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LInitApplication"), Translator.R("LInitApplicationInfo"));
        }
    }

    protected ThreadGroup createThreadGroup(JNLPFile jNLPFile) {
        ThreadGroup threadGroup = jNLPFile instanceof PluginBridge ? Thread.currentThread().getThreadGroup() : new ThreadGroup(mainGroup, jNLPFile.getTitle());
        return threadGroup;
    }

    private LaunchException launchError(LaunchException launchException) {
        return this.launchError(launchException, null);
    }

    private LaunchException launchError(LaunchException launchException, AppletInstance appletInstance) {
        if (appletInstance != null) {
            SplashUtils.showErrorCaught(launchException, appletInstance);
        }
        if (this.handler != null) {
            this.handler.launchError(launchException);
        }
        return launchException;
    }

    private LaunchException launchWarning(LaunchException launchException) {
        if (this.handler != null && !this.handler.launchWarning(launchException)) {
            return launchException;
        }
        return null;
    }

    private static void doPerApplicationAppContextHacks() {
        new ParserDelegator();
    }

    private class TgThread
    extends Thread {
        private JNLPFile file;
        private ApplicationInstance application;
        private LaunchException exception;
        private Container cont;
        private boolean isPlugin;

        TgThread(JNLPFile jNLPFile) {
            this(jNLPFile, null);
        }

        TgThread(JNLPFile jNLPFile, Container container) {
            super(Launcher.this.createThreadGroup(jNLPFile), jNLPFile.getTitle());
            this.isPlugin = false;
            this.file = jNLPFile;
            this.cont = container;
        }

        TgThread(JNLPFile jNLPFile, Container container, boolean bl) {
            super(Launcher.this.createThreadGroup(jNLPFile), jNLPFile.getTitle());
            this.isPlugin = false;
            this.file = jNLPFile;
            this.cont = container;
            this.isPlugin = bl;
        }

        @Override
        public void run() {
            block9: {
                try {
                    if (Launcher.this.context && !this.isPlugin) {
                        SunToolkit.createNewAppContext();
                    }
                    Launcher.doPerApplicationAppContextHacks();
                    if (this.isPlugin) {
                        JNLPRuntime.setDefaultDownloadIndicator(null);
                        this.application = Launcher.this.getApplet(this.file, ((PluginBridge)this.file).codeBaseLookup(), this.cont);
                        break block9;
                    }
                    if (this.file.isApplication()) {
                        this.application = Launcher.this.launchApplication(this.file);
                        break block9;
                    }
                    if (this.file.isApplet()) {
                        this.application = Launcher.this.launchApplet(this.file, true, this.cont);
                        break block9;
                    }
                    if (this.file.isInstaller()) {
                        this.application = Launcher.this.launchInstaller(this.file);
                        break block9;
                    }
                    throw Launcher.this.launchError(new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotLaunchable"), Translator.R("LNotLaunchableInfo")));
                }
                catch (LaunchException launchException) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, launchException);
                    this.exception = launchException;
                    if (Launcher.this.exitOnFailure) {
                        JNLPRuntime.exit(1);
                    }
                }
                catch (Throwable throwable) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, throwable);
                    throw new RuntimeException(throwable);
                }
            }
        }

        public LaunchException getException() {
            return this.exception;
        }

        public ApplicationInstance getApplication() {
            return this.application;
        }
    }
}

