/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.sourceforge.jnlp.AssociationDesc;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.RelatedContentDesc;
import net.sourceforge.jnlp.ShortcutDesc;

public class InformationDesc {
    public static final Object ONE_LINE = "one-line";
    public static final Object SHORT = "short";
    public static final Object TOOLTIP = "tooltip";
    public static final Object DEFAULT = "default";
    private Locale[] locales;
    private List<Object> info;

    public InformationDesc(Locale[] localeArray) {
        this.locales = localeArray;
    }

    public String getTitle() {
        return (String)this.getItem("title");
    }

    public String getVendor() {
        return (String)this.getItem("vendor");
    }

    public URL getHomepage() {
        return (URL)this.getItem("homepage");
    }

    public String getDescription() {
        String string = this.getDescription(DEFAULT);
        if (string == null) {
            string = this.getDescription(ONE_LINE);
        }
        if (string == null) {
            string = this.getDescription(SHORT);
        }
        if (string == null) {
            string = this.getDescription(TOOLTIP);
        }
        return string;
    }

    public String getDescription(Object object) {
        String string = this.getDescriptionStrict(object);
        if (string == null) {
            return (String)this.getItem("description-" + DEFAULT);
        }
        return string;
    }

    public String getDescriptionStrict(Object object) {
        return (String)this.getItem("description-" + object);
    }

    public IconDesc[] getIcons(Object object) {
        List<Object> list = this.getItems("icon-" + object);
        return list.toArray(new IconDesc[list.size()]);
    }

    public URL getIconLocation(Object object, int n, int n2) {
        IconDesc[] iconDescArray = this.getIcons(object);
        if (iconDescArray.length == 0) {
            return null;
        }
        IconDesc iconDesc = null;
        for (int i = 0; i < iconDescArray.length; ++i) {
            if (iconDescArray[i].getWidth() < n || iconDescArray[i].getHeight() < n2) continue;
            if (iconDesc == null) {
                iconDesc = iconDescArray[i];
            }
            if (iconDescArray[i].getWidth() > iconDesc.getWidth() || iconDescArray[i].getHeight() > iconDesc.getHeight()) continue;
            iconDesc = iconDescArray[i];
        }
        if (iconDesc == null) {
            iconDesc = iconDescArray[0];
        }
        return iconDesc.getLocation();
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public boolean isOfflineAllowed() {
        return null != this.getItem("offline-allowed");
    }

    public boolean isSharingAllowed() {
        return null != this.getItem("sharing-allowed");
    }

    public AssociationDesc[] getAssociations() {
        List<Object> list = this.getItems("association");
        return list.toArray(new AssociationDesc[list.size()]);
    }

    public ShortcutDesc getShortcut() {
        return (ShortcutDesc)this.getItem("shortcut");
    }

    public RelatedContentDesc[] getRelatedContents() {
        List<Object> list = this.getItems("related-content");
        return list.toArray(new RelatedContentDesc[list.size()]);
    }

    protected Object getItem(Object object) {
        List<Object> list = this.getItems(object);
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    protected List<Object> getItems(Object object) {
        if (this.info == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.info.size(); i += 2) {
            if (!this.info.get(i).equals(object)) continue;
            arrayList.add(this.info.get(i + 1));
        }
        return arrayList;
    }

    protected void addItem(String string, Object object) {
        if (this.info == null) {
            this.info = new ArrayList<Object>();
        }
        this.info.add(string);
        this.info.add(object);
    }
}

