/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.SystemColor;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.InvocationEvent;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TrayIconPeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CGraphicsConfig;
import sun.awt.CGraphicsDevice;
import sun.awt.PlatformFont;
import sun.awt.SunToolkit;
import sun.awt.SunToolkitSubclass;
import sun.lwawt.LWCursorManager;
import sun.lwawt.LWToolkit;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformComponent;
import sun.lwawt.PlatformWindow;
import sun.lwawt.SecurityWarningWindow;
import sun.lwawt.macosx.CCheckboxMenuItem;
import sun.lwawt.macosx.CClipboard;
import sun.lwawt.macosx.CCursorManager;
import sun.lwawt.macosx.CCustomCursor;
import sun.lwawt.macosx.CDragSourceContextPeer;
import sun.lwawt.macosx.CFileDialog;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CInputMethod;
import sun.lwawt.macosx.CInputMethodDescriptor;
import sun.lwawt.macosx.CMenu;
import sun.lwawt.macosx.CMenuBar;
import sun.lwawt.macosx.CMenuItem;
import sun.lwawt.macosx.CMouseDragGestureRecognizer;
import sun.lwawt.macosx.CPlatformComponent;
import sun.lwawt.macosx.CPlatformEmbeddedFrame;
import sun.lwawt.macosx.CPlatformWindow;
import sun.lwawt.macosx.CPopupMenu;
import sun.lwawt.macosx.CRobot;
import sun.lwawt.macosx.CSystemTray;
import sun.lwawt.macosx.CThreading;
import sun.lwawt.macosx.CTrayIcon;
import sun.lwawt.macosx.CViewPlatformEmbeddedFrame;
import sun.lwawt.macosx.CWarningWindow;
import sun.lwawt.macosx.NamedCursor;
import sun.security.action.GetBooleanAction;
import sun.util.CoreResourceBundleControl;

public final class LWCToolkit
extends LWToolkit {
    private static final int BUTTONS = 5;
    private static CInputMethodDescriptor sInputMethodDescriptor;
    private static final int NUM_APPLE_COLORS = 3;
    public static final int KEYBOARD_FOCUS_COLOR = 0;
    public static final int INACTIVE_SELECTION_BACKGROUND_COLOR = 1;
    public static final int INACTIVE_SELECTION_FOREGROUND_COLOR = 2;
    private static int[] appleColors;
    private static boolean areExtraMouseButtonsEnabled;
    static final String nsImagePrefix = "NSImage://";
    private static Boolean sunAwtDisableCALayers;

    private static native void initIDs();

    public LWCToolkit() {
        SunToolkit.setDataTransfererClassName("sun.lwawt.macosx.CDataTransferer");
        areExtraMouseButtonsEnabled = Boolean.parseBoolean(System.getProperty("sun.awt.enableExtraMouseButtons", "true"));
        System.setProperty("sun.awt.enableExtraMouseButtons", "" + areExtraMouseButtonsEnabled);
    }

    private native void loadNativeColors(int[] var1, int[] var2);

    @Override
    protected void loadSystemColors(int[] nArray) {
        if (nArray == null) {
            return;
        }
        this.loadNativeColors(nArray, appleColors);
    }

    public static Color getAppleColor(int n) {
        return new AppleSpecificColor(n);
    }

    static void systemColorsChanged() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Method method = SystemColor.class.getDeclaredMethod("updateSystemColors", new Class[0]);
                            method.setAccessible(true);
                            method.invoke(null, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        return null;
                    }
                });
            }
        });
    }

    public static LWCToolkit getLWCToolkit() {
        return (LWCToolkit)Toolkit.getDefaultToolkit();
    }

    @Override
    protected PlatformWindow createPlatformWindow(LWWindowPeer.PeerType peerType) {
        if (peerType == LWWindowPeer.PeerType.EMBEDDED_FRAME) {
            return new CPlatformEmbeddedFrame();
        }
        if (peerType == LWWindowPeer.PeerType.VIEW_EMBEDDED_FRAME) {
            return new CViewPlatformEmbeddedFrame();
        }
        assert (peerType == LWWindowPeer.PeerType.SIMPLEWINDOW || peerType == LWWindowPeer.PeerType.DIALOG || peerType == LWWindowPeer.PeerType.FRAME);
        return new CPlatformWindow();
    }

    @Override
    protected SecurityWarningWindow createSecurityWarning(Window window, LWWindowPeer lWWindowPeer) {
        return new CWarningWindow(window, lWWindowPeer);
    }

    @Override
    protected PlatformComponent createPlatformComponent() {
        return new CPlatformComponent();
    }

    @Override
    protected FileDialogPeer createFileDialogPeer(FileDialog fileDialog) {
        return new CFileDialog(fileDialog);
    }

    @Override
    public MenuPeer createMenu(Menu menu) {
        CMenu cMenu = new CMenu(menu);
        LWCToolkit.targetCreatedPeer(menu, cMenu);
        return cMenu;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        CMenuBar cMenuBar = new CMenuBar(menuBar);
        LWCToolkit.targetCreatedPeer(menuBar, cMenuBar);
        return cMenuBar;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        CMenuItem cMenuItem = new CMenuItem(menuItem);
        LWCToolkit.targetCreatedPeer(menuItem, cMenuItem);
        return cMenuItem;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        CCheckboxMenuItem cCheckboxMenuItem = new CCheckboxMenuItem(checkboxMenuItem);
        LWCToolkit.targetCreatedPeer(checkboxMenuItem, cCheckboxMenuItem);
        return cCheckboxMenuItem;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        CPopupMenu cPopupMenu = new CPopupMenu(popupMenu);
        LWCToolkit.targetCreatedPeer(popupMenu, cPopupMenu);
        return cPopupMenu;
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray systemTray) {
        CSystemTray cSystemTray = new CSystemTray();
        return cSystemTray;
    }

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon trayIcon) {
        CTrayIcon cTrayIcon = new CTrayIcon(trayIcon);
        LWCToolkit.targetCreatedPeer(trayIcon, cTrayIcon);
        return cTrayIcon;
    }

    @Override
    public LWCursorManager getCursorManager() {
        return CCursorManager.getInstance();
    }

    @Override
    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException, HeadlessException {
        return new CCustomCursor(image, point, string);
    }

    @Override
    public Dimension getBestCursorSize(int n, int n2) throws HeadlessException {
        return CCustomCursor.getBestCursorSize(n, n2);
    }

    @Override
    protected void platformCleanup() {
    }

    @Override
    protected void platformInit() {
    }

    @Override
    protected void platformRunMessage() {
    }

    @Override
    protected void platformShutdown() {
    }

    @Override
    public FontPeer getFontPeer(String string, int n) {
        return new OSXPlatformFont(string, n);
    }

    @Override
    protected int getScreenHeight() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().height;
    }

    @Override
    protected int getScreenWidth() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().width;
    }

    @Override
    protected void initializeDesktopProperties() {
        super.initializeDesktopProperties();
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.desktopProperties.put("awt.font.desktophints", hashMap);
        this.desktopProperties.put("awt.mouse.numButtons", 5);
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
        this.desktopProperties.put("DnD.isDragImageSupported", new Boolean(true));
        this.desktopProperties.put("DnD.Cursor.CopyDrop", new NamedCursor("DnD.Cursor.CopyDrop"));
        this.desktopProperties.put("DnD.Cursor.MoveDrop", new NamedCursor("DnD.Cursor.MoveDrop"));
        this.desktopProperties.put("DnD.Cursor.LinkDrop", new NamedCursor("DnD.Cursor.LinkDrop"));
        this.desktopProperties.put("DnD.Cursor.CopyNoDrop", new NamedCursor("DnD.Cursor.CopyNoDrop"));
        this.desktopProperties.put("DnD.Cursor.MoveNoDrop", new NamedCursor("DnD.Cursor.MoveNoDrop"));
        this.desktopProperties.put("DnD.Cursor.LinkNoDrop", new NamedCursor("DnD.Cursor.LinkNoDrop"));
    }

    @Override
    protected boolean syncNativeQueue(long l) {
        return this.nativeSyncQueue(l);
    }

    @Override
    public native void beep();

    @Override
    public int getScreenResolution() throws HeadlessException {
        return (int)((CGraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()).getXResolution();
    }

    @Override
    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return ((CGraphicsConfig)graphicsConfiguration).getDevice().getScreenInsets();
    }

    @Override
    public void sync() {
    }

    @Override
    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new CRobot(robot, (CGraphicsDevice)graphicsDevice);
    }

    private native boolean isCapsLockOn();

    @Override
    public boolean getLockingKeyState(int n) throws UnsupportedOperationException {
        switch (n) {
            case 144: 
            case 145: 
            case 262: {
                throw new UnsupportedOperationException("Toolkit.getLockingKeyState");
            }
            case 20: {
                return this.isCapsLockOn();
            }
        }
        throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
    }

    @Override
    public boolean areExtraMouseButtonsEnabled() throws HeadlessException {
        return areExtraMouseButtonsEnabled;
    }

    @Override
    public int getNumberOfButtons() {
        return 5;
    }

    @Override
    public boolean isTraySupported() {
        return true;
    }

    @Override
    public boolean isAlwaysOnTopSupported() {
        return true;
    }

    private static void installToolkitThreadInJava() {
        Thread.currentThread().setName(CThreading.APPKIT_THREAD_NAME);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(null);
                return null;
            }
        });
    }

    @Override
    public boolean isWindowOpacitySupported() {
        return true;
    }

    @Override
    public boolean isFrameStateSupported(int n) throws HeadlessException {
        switch (n) {
            case 0: 
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getMenuShortcutKeyMask() {
        return 4;
    }

    @Override
    public Image getImage(String string) {
        Image image = this.checkForNSImage(string);
        if (image != null) {
            return image;
        }
        return super.getImage(string);
    }

    protected Image checkForNSImage(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith(nsImagePrefix)) {
            return null;
        }
        return CImage.getCreator().createImageFromName(string.substring(nsImagePrefix.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doEquals(final Object object, final Object object2, Component component) {
        if (object == object2) {
            return true;
        }
        final boolean[] blArray = new boolean[1];
        try {
            LWCToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean[] blArray2 = blArray;
                    synchronized (blArray) {
                        blArray[0] = object.equals(object2);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, component);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return blArray[0];
        }
    }

    public static <T> T invokeAndWait(Callable<T> callable, Component component) throws Exception {
        CallableWrapper<T> callableWrapper = new CallableWrapper<T>(callable);
        LWCToolkit.invokeAndWait(callableWrapper, component);
        return callableWrapper.getResult();
    }

    public static void invokeAndWait(Runnable runnable, Component component) throws InvocationTargetException {
        Object object;
        final long l = LWCToolkit.createAWTRunLoopMediator();
        InvocationEvent invocationEvent = AWTAccessor.getInvocationEventAccessor().createEvent(component != null ? component : Toolkit.getDefaultToolkit(), runnable, new Runnable(){

            @Override
            public void run() {
                if (l != 0L) {
                    LWCToolkit.stopAWTRunLoop(l);
                }
            }
        }, true);
        if (component != null) {
            object = SunToolkit.targetToAppContext(component);
            SunToolkit.postEvent((AppContext)object, invocationEvent);
            SunToolkitSubclass.flushPendingEvents((AppContext)object);
        } else {
            ((LWCToolkit)Toolkit.getDefaultToolkit()).getSystemEventQueueForInvokeAndWait().postEvent(invocationEvent);
        }
        LWCToolkit.doAWTRunLoop(l, false);
        object = invocationEvent.getException();
        if (object != null) {
            if (object instanceof UndeclaredThrowableException) {
                object = ((UndeclaredThrowableException)object).getUndeclaredThrowable();
            }
            throw new InvocationTargetException((Throwable)object);
        }
    }

    public static void invokeLater(Runnable runnable, Component component) throws InvocationTargetException {
        Object object;
        InvocationEvent invocationEvent = new InvocationEvent(component != null ? component : Toolkit.getDefaultToolkit(), runnable);
        if (component != null) {
            object = SunToolkit.targetToAppContext(component);
            SunToolkit.postEvent((AppContext)object, invocationEvent);
            SunToolkitSubclass.flushPendingEvents((AppContext)object);
        } else {
            ((LWCToolkit)Toolkit.getDefaultToolkit()).getSystemEventQueueForInvokeAndWait().postEvent(invocationEvent);
        }
        object = invocationEvent.getException();
        if (object == null) {
            return;
        }
        if (object instanceof UndeclaredThrowableException) {
            throw new InvocationTargetException(((UndeclaredThrowableException)object).getUndeclaredThrowable());
        }
        throw new InvocationTargetException((Throwable)object);
    }

    EventQueue getSystemEventQueueForInvokeAndWait() {
        return this.getSystemEventQueueImpl();
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        CDragSourceContextPeer cDragSourceContextPeer = CDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
        return cDragSourceContextPeer;
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        CMouseDragGestureRecognizer cMouseDragGestureRecognizer = null;
        if (MouseDragGestureRecognizer.class.equals(clazz)) {
            cMouseDragGestureRecognizer = new CMouseDragGestureRecognizer(dragSource, component, n, dragGestureListener);
        }
        return (T)cMouseDragGestureRecognizer;
    }

    @Override
    public Locale getDefaultKeyboardLocale() {
        Locale locale = CInputMethod.getNativeLocale();
        if (locale == null) {
            return super.getDefaultKeyboardLocale();
        }
        return locale;
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() {
        if (sInputMethodDescriptor == null) {
            sInputMethodDescriptor = new CInputMethodDescriptor();
        }
        return sInputMethodDescriptor;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return CInputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    @Override
    public int getFocusAcceleratorKeyMask() {
        return 10;
    }

    @Override
    public boolean isPrintableCharacterModifiersMask(int n) {
        return (n & 6) == 0;
    }

    @Override
    public boolean canPopupOverlapTaskBar() {
        return false;
    }

    public static synchronized boolean getSunAwtDisableCALayers() {
        if (sunAwtDisableCALayers == null) {
            sunAwtDisableCALayers = AccessController.doPrivileged(new GetBooleanAction("sun.awt.disableCALayers"));
        }
        return sunAwtDisableCALayers;
    }

    public native boolean isApplicationActive();

    static native long createAWTRunLoopMediator();

    static native void doAWTRunLoop(long var0, boolean var2);

    static native void stopAWTRunLoop(long var0);

    private native boolean nativeSyncQueue(long var1);

    @Override
    public Clipboard createPlatformClipboard() {
        return new CClipboard("System");
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType modalExclusionType) {
        return modalExclusionType == null || modalExclusionType == Dialog.ModalExclusionType.NO_EXCLUDE || modalExclusionType == Dialog.ModalExclusionType.APPLICATION_EXCLUDE || modalExclusionType == Dialog.ModalExclusionType.TOOLKIT_EXCLUDE;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == null || modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.DOCUMENT_MODAL || modalityType == Dialog.ModalityType.APPLICATION_MODAL || modalityType == Dialog.ModalityType.TOOLKIT_MODAL;
    }

    @Override
    public boolean isWindowShapingSupported() {
        return true;
    }

    @Override
    public boolean isWindowTranslucencySupported() {
        return true;
    }

    @Override
    public boolean isTranslucencyCapable(GraphicsConfiguration graphicsConfiguration) {
        return true;
    }

    @Override
    public boolean isSwingBackbufferTranslucencySupported() {
        return true;
    }

    @Override
    public boolean enableInputMethodsForTextComponent() {
        return true;
    }

    static {
        System.err.flush();
        ResourceBundle resourceBundle = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

            @Override
            public ResourceBundle run() {
                ResourceBundle resourceBundle = null;
                try {
                    resourceBundle = ResourceBundle.getBundle("sun.awt.resources.awtosx", CoreResourceBundleControl.getRBControlInstance());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                System.loadLibrary("awt");
                System.loadLibrary("fontmanager");
                return resourceBundle;
            }
        });
        AWTAccessor.getToolkitAccessor().setPlatformResources(resourceBundle);
        if (!GraphicsEnvironment.isHeadless()) {
            LWCToolkit.initIDs();
        }
        appleColors = new int[]{-8355712, -4144960, -13619152};
        areExtraMouseButtonsEnabled = true;
        sunAwtDisableCALayers = null;
    }

    static final class CallableWrapper<T>
    implements Runnable {
        final Callable<T> callable;
        T object;
        Exception e;

        public CallableWrapper(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public void run() {
            try {
                this.object = this.callable.call();
            }
            catch (Exception exception) {
                this.e = exception;
            }
        }

        public T getResult() throws Exception {
            if (this.e != null) {
                throw this.e;
            }
            return this.object;
        }
    }

    class OSXPlatformFont
    extends PlatformFont {
        public OSXPlatformFont(String string, int n) {
            super(string, n);
        }

        @Override
        protected char getMissingGlyphCharacter() {
            return '\ufff8';
        }
    }

    private static class AppleSpecificColor
    extends Color {
        int index;

        public AppleSpecificColor(int n) {
            super(appleColors[n]);
            this.index = n;
        }

        @Override
        public int getRGB() {
            return appleColors[this.index];
        }
    }
}

