/* Copyright 1991 by John Atwood deVries II. */
/* $Id: s_news.c,v 1.18 2001/10/30 05:12:33 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* primitive to handle information requests */

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "externs.h"

#define MAX_NEWS_FILES 10

void	s_news (int, int);

/*ARGSUSED*/
void
s_news(int n, int argc)
{
	int             i, first;
	int             news_fd;
	char            fname[80], c, line[LINE_SIZE];

	first = 0;
	/*
	 * I don't know where clients get this (null) from, but we might as
	 * well take care of it
	 */
	if ((strlen(fields[1]) == 0) || (strcmp(fields[1], "(null)") == 0)) {
		for (i = 1; i < MAX_NEWS_FILES; i++) {
			line[0] = '\0';
			snprintf(fname, 80, "news.%d", i);
			if ((news_fd = open(fname, O_RDONLY)) >= 0) {
				if (first == 0) {
					first++;
					sends_cmdout(n, "--------------------------------------");
				}
				while (read(news_fd, &c, 1) > 0) {
					if (c == '\012') {
						sends_cmdout(n, line);
						line[0] = '\0';
					} else {
						int l;

						l = strlen(line);
						line[l] = c;
						line[l+1] = '\0';
					}
				}
				if (close(news_fd) != 0)
					error("News File Close: %s", strerror(errno));
				sends_cmdout(n, "--------------------------------------");
			}
		}
		if (first == 0)
			sendstatus(n, "News", "No news.");
	} else {
		snprintf(fname, 80, "news.%s", fields[1]);
		if ((news_fd = open(fname, O_RDONLY)) >= 0) {
			sends_cmdout(n, "--------------------------------------");
			line[0] = '\0';
			while (read(news_fd, &c, 1) > 0) {
				if (c == '\012') {
					sends_cmdout(n, line);
					line[0] = '\0';
				} else {
					int l;

					l = strlen(line);
					line[l] = c;
					line[l+1] = '\0';
				}
			}
			sends_cmdout(n, "--------------------------------------");
			if (close(news_fd) != 0)
				error("News File Close: %s", strerror(errno));
		} else
			senderror(n, "Entry not found.");
	}
}
