<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [

<!-- $NetBSD: netbsd.dsl,v 1.7 2020/09/02 17:37:25 kim Exp $ -->

<!ENTITY % output.html      "IGNORE">
<!ENTITY % output.print     "IGNORE">
<!ENTITY % output.print.tex "IGNORE">
<!ENTITY % output.print.rtf "IGNORE">

<![ %output.html; [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA DSSSL>
]]>
<![ %output.print; [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA DSSSL>
]]>

<!ENTITY % misc.ent PUBLIC "-//NetBSD//ENTITIES NetBSD Miscellaneous Entities//EN">
%misc.ent;
]>

<!-- $NetBSD: netbsd.dsl,v 1.7 2020/09/02 17:37:25 kim Exp $ -->

<style-sheet>
  <style-specification use="docbook">
    <style-specification-body>

      (element username ($mono-seq$))
      (element groupname ($mono-seq$))
      (element devicename ($mono-seq$))
      (element maketarget ($mono-seq$))
      (element makevar ($mono-seq$))

      <!-- We would like the author attributions to show up in line
           with the section they refer to.  Authors who made the same
           contribution should be listed in a single <authorgroup> and 
           only one of the <author> elements should contain a <contrib>
           element that describes what the whole authorgroup was
           responsible for.  For example:

           <chapterinfo>
             <authorgroup>
               <author>
                 <firstname>Bob</firstname>
                 <surname>Jones</surname>
                 <contrib>Contributed by </contrib>
               </author>
               <author>
                 <firstname>Sarah</firstname>
                 <surname>Lee</surname>
               </author>
             </authorgroup>
           </chapterinfo>

           Would show up as "Contributed by Bob Jones and Sarah Lee".  Each
           authorgroup shows up as a separate sentence. -->

     (element chapterinfo 
        (process-children))
      (element sect1info 
        (process-children))
      (element sect2info 
        (process-children))
      (element sect3info 
        (process-children))
      (element sect4info 
        (process-children))
      (element sect5info 
        (process-children))
      (element (chapterinfo authorgroup author)
        (literal (author-list-string)))
      (element (sect1info authorgroup author)
        (literal (author-list-string)))
      (element (sect2info authorgroup author)
        (literal (author-list-string)))
      (element (sect3info authorgroup author)
        (literal (author-list-string)))
      (element (sect4info authorgroup author)
        (literal (author-list-string)))
      (element (sect5info authorgroup author)
        (literal (author-list-string)))

      (define (custom-authorgroup)
        ($italic-seq$
          (make sequence
            (process-node-list (select-elements (descendants (current-node))
                                  (normalize "contrib")))
            (process-children)
            (literal ".  "))))

      (element (chapterinfo authorgroup)
        (custom-authorgroup))
      (element (sect1info authorgroup)
        (custom-authorgroup))
      (element (sect2info authorgroup)
        (custom-authorgroup))
      (element (sect3info authorgroup)
        (custom-authorgroup))
      (element (sect4info authorgroup)
        (custom-authorgroup))
      (element (sect5info authorgroup)
        (custom-authorgroup))

      <![ %output.html; [

      ;; $Id: netbsd.dsl,v 1.7 2020/09/02 17:37:25 kim Exp $
      ;;
      ;; This file is part of the Modular DocBook Stylesheet distribution.
      ;; See ../README or http://www.berkshire.net/~norm/dsssl/
      ;;
      ;; Example of a customization layer on top of the modular docbook style
      ;; sheet.  Definitions inserted in this file take precedence over 
      ;; definitions in the 'use'd stylesheet(s).
      
      (define %graphic-default-extension% "gif")

      (define %root-filename%
      ;; Name for the root HTML document
      "netbsd")
      
      (define %html-ext%
      ;; Default extension for HTML output files
      ".html")
      
      (define %use-id-as-filename%
      ;; Use ID attributes as name for component HTML files?
      #t)
      
      (define html-manifest
      ;; Write a manifest?
      #f)
      
      (define (chunk-element-list)
        (list (normalize "preface")
              (normalize "chapter")
              (normalize "appendix") 
              (normalize "article")
              (normalize "glossary")
              (normalize "bibliography")
              (normalize "index")
              (normalize "colophon")
              (normalize "setindex")
              (normalize "reference")
              (normalize "refentry")
              (normalize "part")
              ;;	(normalize "sect1") 
              ;;	(normalize "section") 
              (normalize "book") ;; just in case nothing else matches...
              (normalize "set")  ;; sets are definitely chunks...
              ))

      (define %chapter-autolabel% 
      ;; Are chapters enumerated?
      #t)

      (define %section-autolabel%
      ;; Are sections enumerated?
      #t)

      (define %stylesheet%
      ;; REFENTRY stylesheet
      ;; PURP Name of the stylesheet to use
      ;; DESC
      ;; The name of the stylesheet to place in the HTML LINK TAG, or '#f' to
      ;; suppress the stylesheet LINK.
      ;; /DESC
      ;; AUTHOR N/A
      ;; /REFENTRY
      "docbook.css")

      (define %gentext-nav-use-tables%
        ;; Use tables to build the navigation headers and footers?
        #t)

      (define %generate-docformat-navi-link%
        ;; Create docformat navi link for HTML output?
        #f)

      (define %shade-verbatim%
        ;; Should verbatim environments be shaded?
        #f)

      (define (article-titlepage-recto-elements)
        (list (normalize "title")
              (normalize "subtitle")
              (normalize "corpauthor")
              (normalize "authorgroup")
              (normalize "author")
              (normalize "releaseinfo")
              (normalize "copyright")
              (normalize "pubdate")
              (normalize "revhistory")
              (normalize "legalnotice")
              (normalize "abstract")))

      (element pkg ($mono-seq$))

      ;; Create a simple navigation link
      ;; if %generate-docformat-navi-link% defined.
      (define (make-docformat-navi tlist)
        (let ((rootgi (gi (sgml-root-element))))
          (make element gi: "DIV"
                attributes: '(("CLASS" "DOCFORAMTNAVI"))
                (literal "[ ")
                (make-docformat-navi-link rootgi tlist)
                (literal " ]"))))

      (define (make-docformat-navi-link rootgi tlist)
        (make sequence
          (cond
           ((null? tlist)               (empty-sosofo))
           ((null? (car tlist))         (empty-sosofo))
           ((not (symbol? (car tlist))) (empty-sosofo))
           ((equal? (car tlist) 'html-split)
            (make sequence
              (create-link (list (list "href" "./index.html"))
                           (literal "&docnavi.split-html;"))
              (if (not (null? (cdr tlist)))
                  (make sequence
                    (literal " / ")
                    (make-docformat-navi-link rootgi (cdr tlist)))
                  (empty-sosofo))))
           ((equal? (car tlist) 'html-single)
            (make sequence
              (create-link (list (list "href"
;;                                         (string-append "./" (case-fold-down rootgi) ".html")))
                                       (string-append "./" "netbsd" ".html")))
                           (literal "&docnavi.single-html;"))
              (if (not (null? (cdr tlist)))
                  (make sequence
                    (literal " / ")
                    (make-docformat-navi-link rootgi (cdr tlist)))
                  (empty-sosofo))))
           ((equal? (car tlist) 'postscript)
            (make sequence
              (create-link (list (list "href"
                                       (string-append "./netbsd.ps")))
                           (literal "&docnavi.postscript;"))
              (if (not (null? (cdr tlist)))
                  (make sequence
                    (literal " / ")
                    (make-docformat-navi-link rootgi (cdr tlist)))
                  (empty-sosofo))))
           ((equal? (car tlist) 'pdf)
            (make sequence
              (create-link (list (list "href"
                                       (string-append "./netbsd.pdf")))
                           (literal "&docnavi.pdf;"))
              (if (not (null? (cdr tlist)))
                  (make sequence
                    (literal " / ")
                    (make-docformat-navi-link rootgi (cdr tlist)))
                  (empty-sosofo))))
           (else (empty-sosofo)))))

      (define (article-titlepage-separator side)
        (make sequence
          (if %generate-docformat-navi-link%
              (make-docformat-navi '(html-split html-single postscript pdf))
              (empty-sosofo))
          (make empty-element gi: "HR")))

      (define (book-titlepage-separator side)
        (if (equal? side 'recto)
            (make sequence
              (if %generate-docformat-navi-link%
                  (make-docformat-navi '(html-split html-single postscript pdf))
                  (empty-sosofo)) 
              (make empty-element gi: "HR"))
            (empty-sosofo)))

       <!-- The (create-link) procedure should be used by all FreeBSD
 	   stylesheets to create links.  It calls (can-link-here) to
 	   determine whether it's okay to make a link in the current
 	   position.
 
 	   This check is necessary because links aren't allowed in,
 	   for example, <question> tags since the latter cause links
 	   to be created by themselves.  Obviously, nested links lead
 	   to all kinds of evil.  This normally wouldn't be a problem
 	   since no one in their right mind will put a <ulink> or
 	   <link> in a <question>, but it comes up when someone uses,
 	   say, a man page entity (e.g., &man.ls.1;); the latter may
 	   cause a link to be created, but its use inside a <question>
 	   is perfectly legal.
 
 	   The (can-link-here) routine isn't perfect; in fact, it's a
 	   hack and an ugly one at that.  Ideally, it would detect if
 	   the currect output would wind up in an <a> tag and return
 	   #f if that's the case.  Slightly less ideally it would
 	   check the current mode and return #f if, say, we're
 	   currently in TOC mode.  Right now, it makes a best guess
 	   attempt at guessing which tags might cause links to be
 	   generated.  -->
      (define (can-link-here)
 	(cond ((has-ancestor-member? (current-node)
				     '("TITLE" "QUESTION")) #f)
 	      (#t #t)))
 
      (define (create-link attrlist target)
 	(if (can-link-here)
 	    (make element gi: "A"
 		  attributes: attrlist
 		  target)
	    target))

        (define %refentry-xref-link%
          ;; REFENTRY refentry-xref-link
          ;; PURP Generate URL links when cross-referencing RefEntrys?
          ;; DESC
          ;; If true, a web link will be generated, presumably
          ;; to an online man->HTML gateway.  The text of the link is
          ;; generated by the $create-refentry-xref-link$ function.
          ;; /DESC
          ;; AUTHOR N/A
          ;; /REFENTRY
          #t)

        <!-- Specify how to generate the man page link HREF -->
        (define ($create-refentry-xref-link$ #!optional (n (current-node)))
          (let* ((r (select-elements (children n) (normalize "refentrytitle")))
                 (m (select-elements (children n) (normalize "manvolnum"))))
            (string-append "//man.NetBSD.org/" (data r) "." (data m))))

        (element citerefentry
          (let ((href ($create-refentry-xref-link$)))
            (if %refentry-xref-link%
              (create-link (list (list "HREF" href))
                (if %refentry-xref-italic%
                  ($italic-seq$)
                  ($charseq$)))
              (if %refentry-xref-italic%
                ($italic-seq$)
                ($charseq$)))))
      ]]>

      <![ %output.print; [

      (element pkg ($mono-seq$
			(make sequence
				(literal "pkgsrc/")
				(process-children))))

      (define minimal-section-labels #f)
      (define max-section-level-labels
        (if minimal-section-labels 3 10))

      (define ($section-title$)
        (let* ((sect (current-node))
      	       (info (info-element))
	       (exp-children (if (node-list-empty? info)
		 	         (empty-node-list)
			         (expand-children (children info) 
					          (list (normalize "bookbiblio") 
						        (normalize "bibliomisc")
						        (normalize "biblioset")))))
	       (parent-titles (select-elements (children sect) (normalize "title")))
  	       (info-titles   (select-elements exp-children (normalize "title")))
	       (titles        (if (node-list-empty? parent-titles)
		   	          info-titles
			          parent-titles))
	       (subtitles     (select-elements exp-children (normalize "subtitle")))
	       (renderas (inherited-attribute-string (normalize "renderas") sect))
	       (hlevel                          ;; the apparent section level;
	        (if renderas                    ;; if not real section level,
  	            (string->number             ;;   then get the apparent level
	             (substring renderas 4 5))  ;;   from "renderas",
	            (SECTLEVEL)))               ;; else use the real level
	       (hs (HSIZE (- 4 hlevel))))

          (make sequence
            (make paragraph
 	      font-family-name: %title-font-family%
	      font-weight:  (if (< hlevel 5) 'bold 'medium)
	      font-posture: (if (< hlevel 5) 'upright 'italic)
	      font-size: hs
	      line-spacing: (* hs %line-spacing-factor%)
	      space-before: (* hs %head-before-factor%)
	      space-after: (if (node-list-empty? subtitles)
	    	  	       (* hs %head-after-factor%)
	 	  	       0pt)
	      start-indent: (if (or (>= hlevel 3)
			            (member (gi) (list (normalize "refsynopsisdiv") 
					    	       (normalize "refsect1") 
						       (normalize "refsect2") 
						       (normalize "refsect3"))))
	 		        %body-start-indent%
			        0pt)
	      first-line-start-indent: 0pt
	      quadding: %section-title-quadding%
	      keep-with-next?: #t
	      heading-level: (if %generate-heading-level% (+ hlevel 1) 0)
  	      ;; SimpleSects are never AUTO numbered...they aren't hierarchical
	      (if (> hlevel (- max-section-level-labels 1))
	          (empty-sosofo)
	          (if (string=? (element-label (current-node)) "")
	  	      (empty-sosofo)
		      (literal (element-label (current-node)) 
			       (gentext-label-title-sep (gi sect)))))
	      (element-title-sosofo (current-node)))
            (with-mode section-title-mode
	      (process-node-list subtitles))
            ($section-info$ info))))

      <!-- More aesthetically pleasing chapter headers for print output --> 

      <![ %output.print.niceheaders; [

      (define niceheader-rule-spacebefore (* (HSIZE 5) %head-before-factor%))
      (define niceheader-rule-spaceafter 0pt)

      (define ($component-title$)
	(let* ((info (cond
		((equal? (gi) (normalize "appendix"))
		 (select-elements (children (current-node)) (normalize "docinfo")))
		((equal? (gi) (normalize "article"))
		 (node-list-filter-by-gi (children (current-node))
					 (list (normalize "artheader")
					       (normalize "articleinfo"))))
		((equal? (gi) (normalize "bibliography"))
		 (select-elements (children (current-node)) (normalize "docinfo")))
		((equal? (gi) (normalize "chapter"))
		 (select-elements (children (current-node)) (normalize "docinfo")))
		((equal? (gi) (normalize "dedication")) 
		 (empty-node-list))
		((equal? (gi) (normalize "glossary"))
		 (select-elements (children (current-node)) (normalize "docinfo")))
		((equal? (gi) (normalize "index"))
		 (select-elements (children (current-node)) (normalize "docinfo")))
		((equal? (gi) (normalize "preface"))
		 (select-elements (children (current-node)) (normalize "docinfo")))
		((equal? (gi) (normalize "reference"))
		 (select-elements (children (current-node)) (normalize "docinfo")))
		((equal? (gi) (normalize "setindex"))
		 (select-elements (children (current-node)) (normalize "docinfo")))
		(else
		 (empty-node-list))))
	 (exp-children (if (node-list-empty? info)
			   (empty-node-list)
			   (expand-children (children info) 
					    (list (normalize "bookbiblio") 
						  (normalize "bibliomisc")
						  (normalize "biblioset")))))
	 (parent-titles (select-elements (children (current-node)) (normalize "title")))
	 (info-titles   (select-elements exp-children (normalize "title")))
	 (titles        (if (node-list-empty? parent-titles)
			    info-titles
			    parent-titles))
	 (subtitles     (select-elements exp-children (normalize "subtitle"))))
    (make sequence
      (make paragraph
	font-family-name: %title-font-family%
	font-weight: 'bold
	font-size: (HSIZE 4)
	line-spacing: (* (HSIZE 4) %line-spacing-factor%)
	space-before: (* (HSIZE 4) %head-before-factor%)
	start-indent: 0pt
	first-line-start-indent: 0pt
	quadding: %component-title-quadding%
	heading-level: (if %generate-heading-level% 1 0)
	keep-with-next?: #t

	(if (string=? (element-label) "")
	    (empty-sosofo)
	    (literal (gentext-element-name-space (current-node))
		     (element-label)
		     (gentext-label-title-sep (gi)))))
      (make paragraph
	font-family-name: %title-font-family%
	font-weight: 'bold
	font-posture: 'italic
	font-size: (HSIZE 6)
	line-spacing: (* (HSIZE 6) %line-spacing-factor%)
;	space-before: (* (HSIZE 5) %head-before-factor%)
	start-indent: 0pt
	first-line-start-indent: 0pt
	quadding: %component-title-quadding%
	heading-level: (if %generate-heading-level% 1 0)
	keep-with-next?: #t

	(if (node-list-empty? titles)
	    (element-title-sosofo) ;; get a default!
	    (with-mode component-title-mode
	      (make sequence
		(process-node-list titles)))))

      (make paragraph
	font-family-name: %title-font-family%
	font-weight: 'bold
	font-posture: 'italic
	font-size: (HSIZE 3)
	line-spacing: (* (HSIZE 3) %line-spacing-factor%)
	space-before: (* 0.5 (* (HSIZE 3) %head-before-factor%))
	space-after: (* (HSIZE 4) %head-after-factor%)
	start-indent: 0pt
	first-line-start-indent: 0pt
	quadding: %component-subtitle-quadding%
	keep-with-next?: #t

	(with-mode component-title-mode
	  (make sequence
	    (process-node-list subtitles))))

      (if (equal? (gi) (normalize "index"))
	(empty-sosofo)
	(make rule
	  length: %body-width%
	  display-alignment: 'start
	  space-before: niceheader-rule-spacebefore
	  space-after: niceheader-rule-spaceafter
	  line-thickness: 0.5pt)))))

      (element authorgroup
        (empty-sosofo))

      ]]>

      <![ %output.print.tex; [
      ;; This file is part of the Modular DocBook Stylesheet distribution.
      ;; See ../README or http://www.berkshire.net/~norm/dsssl/
      ;;
      ;; Example of a customization layer on top of the modular docbook style
      ;; sheet.  Definitions inserted in this file take precedence over 
      ;; definitions in the 'use'd stylesheet(s).
      
      (define %graphic-default-extension% "eps")
      
      (define %generate-book-titlepage%
      ;; Should a book title page be produced?
      #t)
      
      (define %chapter-autolabel% 
      ;; Are chapters enumerated?
      #t)
      
      (define %section-autolabel%
      ;; Are sections enumerated?
      #t)
      
      (define %figure-rules%
      ;; Specify rules before and after an Figure
      #f)


      (define (split-string-to-list STR)
      ;; return list of STR separated with char " "
      (if (string? STR)
        (let loop ((i (string-delim-index STR)))
          (cond ((equal? (cdr i) '()) '())
                (else (cons (substring STR (list-ref i 0) (- (list-ref i 1) 1))
                            (loop (cdr i))))))
        '()))

      (define (string-delim-index STR)
      ;; return indexes of STR separated with char " "
      (if (string? STR)
        (let ((strlen (string-length STR)))
          (let loop ((i 0))
            (cond ((= i strlen) (cons (+ strlen 1) '()))
                  ((= i 0)      (cons i (loop (+ i 1))))
                  ((equal? (string-ref STR i) #\ ) (cons (+ i 1) (loop (+ i 1))))
                  (else (loop (+ i 1))))))
        '()
      ))

     (define (cvsid-to-time STR)
       (let ((time (list-ref (split-string-to-list STR) 4)))
           (if (null? time)
	       (error "cannot extract time from CVS ID.")
	       time)))

     (define (cvsid-to-date STR)
       (let ((date (list-ref (split-string-to-list STR) 3)))
           (if (null? date)
	       (error "cannot extract date from CVS ID.")
	       date)))

     (mode book-titlepage-verso-mode
       (element pubdate
         (make paragraph
	   (literal (gentext-element-name-space (gi (current-node))))
           (literal (string-append
		     (cvsid-to-date (data (current-node)))
		     " "
		     (cvsid-to-time (data (current-node))))))))

     (mode book-titlepage-recto-mode
       (element pubdate
         (make paragraph
	       use: book-titlepage-recto-style
	       quadding: %division-title-quadding%
	       space-before: (* (HSIZE 4) %head-before-factor%)
           (literal (string-append
		     "("
		     (cvsid-to-date (data (current-node)))
		     ")"
		     )))))

     (define (book-titlepage-recto-elements)
       (list (normalize "title") 
             (normalize "subtitle") 
             (normalize "pubdate")
             (normalize "graphic")
             (normalize "mediaobject")
             (normalize "corpauthor") 
             (normalize "authorgroup") 
             (normalize "author") 
	     (normalize "editor")
	     ))
      ]]>

      <![ %output.print.rtf; [
      
      ;; This file is part of the Modular DocBook Stylesheet distribution.
      ;; See ../README or http://www.berkshire.net/~norm/dsssl/
      ;;
      ;; Example of a customization layer on top of the modular docbook style
      ;; sheet.  Definitions inserted in this file take precedence over 
      ;; definitions in the 'use'd stylesheet(s).
      
      (define %graphic-default-extension% "bmp")
      
      (define %generate-book-titlepage%
      ;; Should a book title page be produced?
      #t)
      
      (define %chapter-autolabel% 
      ;; Are chapters enumerated?
      #t)
      
      (define %section-autolabel%
      ;; Are sections enumerated?
      #t)
      
      (define %figure-rules%
      ;; Specify rules before and after an Figure
      #f)
      ]]>
      ]]>
  
    </style-specification-body>
  </style-specification>

  <external-specification id="docbook" document="docbook.dsl">
</style-sheet>
