/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.sun.source.tree.Tree;

public enum OperatorPrecedence {
    POSTFIX(13),
    UNARY(12),
    MULTIPLICATIVE(11),
    ADDITIVE(10),
    SHIFT(9),
    RELATIONAL(8),
    EQUALITY(7),
    AND(6),
    XOR(5),
    OR(4),
    CONDITIONAL_AND(3),
    CONDITIONAL_OR(2),
    TERNARY(1),
    ASSIGNMENT(0);

    private final int precedence;

    private OperatorPrecedence(int precedence) {
        this.precedence = precedence;
    }

    public boolean isHigher(OperatorPrecedence other) {
        return this.precedence > other.precedence;
    }

    public static OperatorPrecedence from(Tree.Kind kind) {
        switch (kind) {
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: {
                return POSTFIX;
            }
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: {
                return UNARY;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: {
                return MULTIPLICATIVE;
            }
            case PLUS: 
            case MINUS: {
                return ADDITIVE;
            }
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LEFT_SHIFT: {
                return SHIFT;
            }
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case INSTANCE_OF: {
                return RELATIONAL;
            }
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                return EQUALITY;
            }
            case AND: {
                return AND;
            }
            case XOR: {
                return XOR;
            }
            case OR: {
                return OR;
            }
            case CONDITIONAL_AND: {
                return CONDITIONAL_AND;
            }
            case CONDITIONAL_OR: {
                return CONDITIONAL_OR;
            }
            case ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return ASSIGNMENT;
            }
        }
        throw new IllegalArgumentException("Unexpected operator kind: " + kind);
    }
}

