;; -*- coding: euc-jp ; mode: scheme -*-
;; test sandbox module.
;; Kahua.sandbox ⥸塼Υƥ

;; $Id: sandbox.scm,v 1.2 2005/07/04 05:09:21 nobsun Exp $


(use gauche.test)
(use kahua.plugin)

(test-start "sandbox test")

(define *sandbox* #f)

;;---------------------------------------------------------------
;; ɥƥ
;; kahua.sandbox ɤǤޤΥ󥿡ե
;; ʤȤǧ롣
(use kahua.sandbox)
(test-module 'kahua.sandbox)


;; ɥܥå⥸塼줬̵̾⥸塼
;; 뤳Ȥǧ롣
(test* "make sandbox module" "#<module #>"
       (let ((m (make-sandbox-module)))
         (set! *sandbox* m)
         (x->string m)))

;; ʼ³ΥƥȤ1
;; ɥܥåǵĤƤ³ car Ȥ뤳Ȥǧ롣
(test* "check available binding, car"
       '1
       (eval '(car '(1 2 3)) *sandbox*))

;; ʼ³ΥƥȤ2
;; ɥܥåǵĤƤ³ define Ȥ뤳Ȥǧ롣
(test* "check available binding, define"
       'square
       (eval '(define (square n) (* n n)) *sandbox*))

;; ߡ«򤷤ʼ³ΥƥȤ1
;; open-input-file ɾȥ顼ˤʤ뤳Ȥǧ롣
(test* "check disablebinding, open-input-file"
       *test-error*
       (eval '(open-input-file "/etc/passwd") *sandbox*))

;; ߡ«򤷤ʼ³ΥƥȤ2
;; open-output-file ɾȥ顼ˤʤ뤳Ȥǧ롣
(test* "check disablebinding, open-output-file"
       *test-error*
       (eval '(open-output-file "evil") *sandbox*))

;; ߡ«򤷤ʼ³ΥƥȤ3
;; call-with-input-file ɾȥ顼ˤʤ뤳Ȥǧ롣
(test* "check disablebinding, call-with-input-file"
       *test-error*
       (eval '(call-with-input-file "/etc/passwd" read-line) *sandbox*))

;; ߡ«򤷤ʼ³ΥƥȤ4
;; call-with-output-file ɾȥ顼ˤʤ뤳Ȥǧ롣
(test* "check disablebinding, call-with-output-file"
       *test-error*
       (eval '(call-with-output-file "evil"
                (lambda (in) (format in "#!/bin/sh\n")
                             (format in "killall gosh")))
             *sandbox*))

;; ߡ«򤷤ʼ³ΥƥȤ5
;; load ɾȥ顼ˤʤ뤳Ȥǧ롣
(test* "check disablebinding, load"
       *test-error*
       (eval '(load "gauche/process") *sandbox*))

;; ߡ«򤷤ʼ³ΥƥȤ6
;; require ɾȥ顼ˤʤ뤳Ȥǧ롣
(test* "check disablebinding, require"
       *test-error*
       (eval '(require "gauche/net") *sandbox*))

;; ߡ«򤷤ʼ³ΥƥȤ7
;; import ɾȥ顼ˤʤ뤳Ȥǧ롣
(test* "check disablebinding, import"
       *test-error*
       (eval '(import kahua.sandbox) *sandbox*))

;; ߡ«򤷤ʼ³ΥƥȤ8
;; select-module ɾȥ顼ˤʤ뤳Ȥǧ롣
(test* "check disablebinding, select-module"
       *test-error*
       (eval '(select-module user) *sandbox*))

;; ߡ«򤷤ʼ³ΥƥȤ9
;; with-module ɾȥ顼ˤʤ뤳Ȥǧ롣
(test* "check disablebinding, with-module"
       *test-error*
       (eval '(with-module user (open-input-file "/etc/passwd"))
             *sandbox*))

;; ߡ«򤷤ʼ³ΥƥȤ10
;; use ǥץ饰ϿƤʤ⥸塼ɾ
;; 顼ˤʤ뤳Ȥǧ롣
(test* "check overrided, use"
       *test-error*
       (eval '(use file.util) *sandbox*))

(test-end)

