;; -*- coding: euc-jp; mode: scheme -*-
;; test kahua.persistence
;; Kahua.persistence⥸塼Υƥ

;; $Id: persistence.scm,v 1.20 2006/12/02 07:11:36 bizenn Exp $

(use gauche.test)
(use gauche.collection)
(use file.util)
(use util.list)

;; A hook to use this file for both stand-alone test and
;; DBI-backed-up test.
(cond ((global-variable-bound? (current-module) '*dbname*)
       (rxmatch-if (#/^(\w+):/ *dbname*) (#f driver)
	 (test-start #`"persistence/,|driver| (,|*dbname*|)")
	 (test-start #`"persistence/efs (,|*dbname*|)")))
      (else
       (error "You must define \*dbname\* for database name.")))

(define-syntax with-clean-db
  (syntax-rules ()
    ((_ (db dbpath) . body)
     (with-db (db dbpath)
       (kahua-db-purge-objs)
       . body))))

;; ɥƥ:
;;   kahua.persistentceɤǤޤΥ󥿥ե
;;   ʤȤǧ롣
(use kahua.persistence)
(test-module 'kahua.persistence)

;;----------------------------------------------------------
;; Ūʥƥ
(test-section "database basics")

;;  ¸ߤʤǡ١̾Ϳƥǡ١򥪡ץ󤷡
;;  ǡ١뤳Ȥǧ롣
(test* "creating database" '(#t #t #t #t)
       (with-db (db *dbname*)
         (cons (is-a? db <kahua-db>)
	       (case (class-name (class-of db))
		 ((<kahua-db-fs> <kahua-db-efs>)
		  (list
		   (file-is-directory? (ref db 'real-path))
		   (file-is-regular? (ref db 'id-counter-path))
		   (file-is-regular? (ref db 'character-encoding-path))))
                 ((<kahua-db-mysql>)
		  (list
		   (and (dbi-do (ref db 'connection) "select class_name, table_name from kahua_db_classes") #t)
		   (and-let* ((r (dbi-do (ref db 'connection) "select value from kahua_db_idcount"))
			      (p (map (cut dbi-get-value <> 0) r)))
		     (and (pair? p) (integer? (x->integer (car p)))))
		   (and-let* ((r (dbi-do (ref db 'connection) "select value from kahua_db_classcount"))
			      (p (map (cut dbi-get-value <> 0) r)))
		     (and (pair? p) (integer? (x->integer (car p)))))))
		 ((<kahua-db-postgresql>)
		  (list
		   (and (dbi-do (ref db 'connection) "select class_name, table_name from kahua_db_classes") #t)
		   (and-let* ((r (dbi-do (ref db 'connection)
					 "select count(*) from pg_class where relname='kahua_db_idcount' and relkind='S'"))
			      (p (map (cut dbi-get-value <> 0) r)))
		     (and (pair? p) (= (x->integer (car p)) 1)))
		   (and-let* ((r (dbi-do (ref db 'connection)
					 "select count(*) from pg_class where relname='kahua_db_classcount' and relkind='S'"))
			      (p (map (cut dbi-get-value <> 0) r)))
		     (and (pair? p) (= (x->integer (car p)) 1))))))
	       )))

;;  ǡ١with-dbưŪͭǤꡢ
;;  γ̵ˤʤ뤳Ȥǧ롣
(test* "database activeness" '(#t #f)
       (receive (db active?)
           (with-db (db *dbname*) (values db (ref db 'active)))
         (list active? (ref db 'active))))

;;----------------------------------------------------------
;; 󥹥󥹺ƥ
(test-section "instances")

;;  ³饹줬³᥿饹<kahua-persistent-meta>
;;  ϿƤ뤳Ȥǧ롣
(define-class <kahua-test> (<kahua-persistent-base>)
  ((quick :allocation :persistent :init-keyword :quick :init-value 'i)
   (quack :init-keyword :quack :init-value 'a)
   (quock :allocation :persistent :init-keyword :quock :init-value 'o))
  :source-id "Rev 1")

(define-method list-slots ((obj <kahua-test>))
  (map (cut ref obj <>) '(%kahua-persistent-base::id quick quack quock)))

(define (get-test-obj id)
  (find-kahua-instance <kahua-test> (format "~6,'0d" id)))

(test* "metaclass stuff" (list #t <kahua-test>)
       (list (is-a? <kahua-test> <kahua-persistent-meta>)
             (find-kahua-class '<kahua-test>)))

;;  ³󥹥󥹤åȤƤ뤳ȳǧ롣
(test* "creation (1)" '(1 ii aa "oo")
       (with-clean-db (db *dbname*)
         (list-slots (make <kahua-test> :quick 'ii :quack 'aa :quock "oo"))))

;;  Ƥӥȥ󥶥򳫻Ϥ³֥Ȥ
;;  Ȥǧ롣
(test* "read (1)" '(1 ii a "oo")
       (with-clean-db (db *dbname*)
         (list-slots (get-test-obj 1))))

;;  ҤȤĤΥȥ󥶥ǤѹΥȥ󥶥ˤݻ
;;  뤳Ȥǧ롣
(test* "modify (1)" '(1 "II" a "oo")
       (begin
         (with-clean-db (db *dbname*)
           (set! (ref (get-test-obj 1) 'quick) "II"))
         (with-clean-db (db *dbname*)
           (list-slots (get-test-obj 1))))
       )

;;  ⤦Ĥα³󥹥󥹤ѹǽǤ뤳Ȥǧ롣
;;  ޤѹ³󥹥󥹤ˤϱƶʤȤ
;;  ǧ롣
(test* "creation (2)" '(2 hh bb "pp")
       (with-clean-db (db *dbname*)
         (list-slots (make <kahua-test> :quick 'hh :quack 'bb :quock "pp"))))

(test* "modify (2)" '(2 "hh" a "PP")
       (begin
         (with-clean-db (db *dbname*)
           (set! (ref (get-test-obj 2) 'quick) "hh")
           (set! (ref (get-test-obj 2) 'quock) "PP"))
         (with-clean-db (db *dbname*)
           (list-slots (get-test-obj 2))))
       )

(test* "read (1)" '(1 "II" a "oo")
       (with-clean-db (db *dbname*)
         (list-slots (get-test-obj 1))))

;;  ³饹ֹ椬Ƥ뤳ȡʤ
;;  in-memoryin-db0Ǥ뤳Ȥǧ롣
(test* "generation" '(0 0)
       (with-clean-db (db *dbname*)
         (list (ref <kahua-test> 'generation)
               (ref <kahua-test> 'persistent-generation))))

;; С饤ɤػߤåȤ򥪡С饤ɤ륯饹Ƥߤ롣
;; 顼ˤʤϤ
(test* "Final slot overriding: %kahua-persistent-base::id"
       *test-error*
       (eval '(define-class <kahua-violation-id> (<kahua-persistent-base>)
		((%kahua-persistent-base::id :init-value 0)))
	     (current-module)))
(test* "Final slot overriding: %kahua-persistent-base::db"
       *test-error*
       (eval '(define-class <kahua-violation-db> (<kahua-persistent-base>)
		((%kahua-persistent-base::db :init-value #f)
		 (%kahua-persistent-base::id :init-value 0)))
	     (current-module)))

;;----------------------------------------------------------
;; ȥ󥶥˴ؤƥ
(test-section "transaction")

;;   ³󥹥ѹ˥ȥ󥶥errorǤ
;;   Ƥӥȥ󥶥򳫻Ϥơ³󥹥󥹤ѹ
;;   ʤȤǧ롣
(test* "abort transaciton" '(2 "hh" a "PP")
       (with-error-handler
           (lambda (e)
             (with-clean-db (db *dbname*)
               (list-slots (get-test-obj 2))))
         (lambda ()
           (with-clean-db (db *dbname*)
             (set! (ref (get-test-obj 2) 'quick) 'whoops)
             (error "abort!")))))

;;   ³󥹥ѹ˰commitƤޤ󥹥󥹤
;;   ѹȥ󥶥errorǤ롣
;;   Ƥӥȥ󥶥򳫻Ϥơ³󥹥󥹤commitޤǤ
;;   ѹʹߤѹϼƤʤȤǧ롣
(test* "commit & abort" '(2 whoops a "PP")
       (with-error-handler
           (lambda (e)
             (with-clean-db (db *dbname*)
               (list-slots (get-test-obj 2))))
         (lambda ()
           (with-clean-db (db *dbname*)
             (set! (ref (get-test-obj 2) 'quick) 'whoops)
             (kahua-db-sync db)
             (set! (ref (get-test-obj 2) 'quock) 'whack)
             (error "abort!")))))

;;----------------------------------------------------------
;; ³֥ȴ֤λȤ˴ؤƥ
(test-section "references")

;;   ³֥ȤؤλȤ̤α³֥ȤΥåȤ˥åȤ
;;   ߥåȤǤ뤳Ȥǧ롣
(test* "reference write" #t
       (with-clean-db (db *dbname*)
         (set! (ref (get-test-obj 1) 'quick) (get-test-obj 2))
         (is-a? (ref (get-test-obj 1) 'quick) <kahua-test>)))

;;   ƤӤȤα³֥Ȥɤ߽Фα³֥Ȥ
;;   ɤޤƤ뤳Ȥǧ롣
(test* "reference read" '(2 whoops a "PP")
       (with-clean-db (db *dbname*)
         (list-slots (ref (get-test-obj 1) 'quick))))

;;   դĤα³֥Ȥߤ˻Ȥ¤줬
;;   ߥåȤǤ뤳Ȥǧ롣
(test* "circular reference write" '(#t #t)
       (with-clean-db (db *dbname*)
         (set! (ref (get-test-obj 2) 'quick) (get-test-obj 1))
         (list (eq? (get-test-obj 1) (ref (get-test-obj 2) 'quick))
               (eq? (get-test-obj 2) (ref (get-test-obj 1) 'quick)))))

;;   ۴Ļȹ¤Ƥɤ߽Ф¤ƸƤ
;;   Ȥǧ롣
(test* "circular reference read" '(#t #t)
       (with-clean-db (db *dbname*)
         (list (eq? (get-test-obj 1) (ref (get-test-obj 2) 'quick))
               (eq? (get-test-obj 2) (ref (get-test-obj 1) 'quick)))))

;;----------------------------------------------------------
;; 饹
(test-section "class redefinition")

;(with-clean-db (db *dbname*) (kahua-db-purge-objs))

;; ³饹롣åȤѹϰʲ̤ꡣ

;; Slot changes:
;;  quick - no change (persistent)
;;  quack - no change (transient)
;;  muick - added (persistent)
;;  quock - changed (persistent -> virtual)
(define-class <kahua-test> (<kahua-persistent-base>)
  ((quick :allocation :persistent :init-keyword :quick :init-value 'i)
   (quack :init-keyword :quack :init-value 'a)
   (muick :allocation :persistent :init-keyword :muick :init-value 'm)
   (quock :allocation :virtual
          :slot-ref  (lambda (o) (ref o 'quick))
          :slot-set! (lambda (o v) #f))  ;; to vanish
   )
  :source-id "Rev 2")

;;   ֥ȥޥ͡ˡ줿饹ϿƤ뤳Ȥǧ
(test* "redefining class" <kahua-test>
       (find-kahua-class '<kahua-test>))

;;   󥹥󥹤饹бƥåץǡȤ뤳Ȥǧ롣
(test* "updating instance for new class" #t
       (with-db (db *dbname*)
         (eq? (ref (get-test-obj 1) 'quick)
              (ref (get-test-obj 1) 'quock))))

(test* "updating instance for new class" '(#t #t)
       (with-db (db *dbname*)
         (list (equal? (list-slots (ref (get-test-obj 1) 'quock))
                       (list-slots (get-test-obj 2)))
               (equal? (list-slots (ref (get-test-obj 2) 'quock))
                       (list-slots (get-test-obj 1))))))

;;   åץǡȤ󥹥󥹤Фѹǡ١ȿǤ뤳Ȥ
;;   ǧ롣
(test* "redefining class (write)" '("M" "M" "M")
       (with-clean-db (db *dbname*)
         (set! (ref (get-test-obj 1) 'muick) '("M" "M" "M"))
         (ref (get-test-obj 1) 'muick)))

(test* "redefining class (read)" '("M" "M" "M")
       (with-clean-db (db *dbname*)
         (ref (get-test-obj 1) 'muick)))

;;   ³饹ֹ椬󥯥ȤƤ뤳Ȥǧ롣
(test* "generation" '(1 1)
       (with-clean-db (db *dbname*)
         (list (ref <kahua-test> 'generation)
               (ref <kahua-test> 'persistent-generation))))

;;----------------------------------------------------------
;; ֥饹Υƥ
(test-section "subclassing")

;(with-clean-db (db *dbname*) (kahua-db-purge-objs))

;;   ³饹<kahua-test>Ѿ֥饹롣
(define-class <kahua-test-sub> (<kahua-test>)
  ((woo :allocation :persistent :init-keyword :woo :init-value "W")
   (boo :allocation :persistent :init-keyword :boo :init-value "B")
   ;; this shadows parent's quock
   (quock :allocation :persistent :init-keyword :quock :init-value #f))
  :source-id "Rev 3")

(define-method list-slots ((obj <kahua-test-sub>))
  (map (cut ref obj <>) '(%kahua-persistent-base::id quick quack woo boo quock)))

(define-method key-of ((obj <kahua-test-sub>))
  (string-append (ref obj 'woo) (ref obj 'boo)))

;;   ֥饹α³󥹥󥹤졢Ѿ줿åȡ
;;   ɲä줿åȡ˥ǡ³뤳Ȥǧ롣
(test* "write" '(4 "quick" "quack" "woo" "boo" "quock")
       (with-clean-db (db *dbname*)
         (list-slots
          (make <kahua-test-sub> :quick "quick" :quack "quack"
                :woo "woo" :boo "boo" :quock "quock"))))

(test* "read"  '(4 "quick" a "woo" "boo" "quock")
       (with-clean-db (db *dbname*)
         (list-slots (find-kahua-instance <kahua-test-sub> "wooboo"))))

(test* "write" '(5 i a "wooo" "booo" #f)
       (with-clean-db (db *dbname*)
         (list-slots
          (make <kahua-test-sub> :woo "wooo" :boo "booo"))))

(test* "read"  '(5 i a "wooo" "booo" #f)
       (with-clean-db (db *dbname*)
         (list-slots (find-kahua-instance <kahua-test-sub> "wooobooo"))))

;;   ƥ饹α³󥹥󥹤ؤλȤޤ๽¤
;;   줬ǡ١ȿǤ뤳Ȥǧ롣
(test* "reference to parent (write)" #t
       (with-clean-db (db *dbname*)
         (let1 obj (find-kahua-instance <kahua-test-sub> "wooboo")
           (set! (ref obj 'quick) (get-test-obj 1))
           (eq? (ref obj 'quick) (get-test-obj 1)))))

(test* "reference to parent (read)" #t
       (with-clean-db (db *dbname*)
         (let1 obj (find-kahua-instance <kahua-test-sub> "wooboo")
           (eq? (ref obj 'quick) (get-test-obj 1)))))

;;   λҥ饹ֹ椬Ƥ뤳Ȥǧ롣
(test* "generation" '(0 0)
       (with-clean-db (db *dbname*)
         (list (ref <kahua-test-sub> 'generation)
               (ref <kahua-test-sub> 'persistent-generation))))

;;----------------------------------------------------------
;; ³֥ȥ쥯<kahua-collection>˴ؤƥ
(test-section "collection")

;;  <kahua-test>³饹<kahua-test-sub>³饹
;;  Υ饹α³󥹥󥹤Υ쥯󤬺Ǥ뤳Ȥ
;;  ǧ롣
(test* "kahua-test" '(1 2)
       (sort (with-clean-db (db *dbname*)
               (map kahua-persistent-id
                    (make-kahua-collection <kahua-test>)))))

(test* "kahua-test-sub" '("woo" "wooo")
       (sort (with-clean-db (db *dbname*)
               (map (cut ref <> 'woo)
                    (make-kahua-collection <kahua-test-sub>)))))

(test* "kahua-test-sub w/ predicate" '("woo")
       (sort (with-clean-db (db *dbname*)
	       (map (cut ref <> 'woo)
		    (make-kahua-collection <kahua-test-sub>
					   :predicate (lambda (obj)
							(string=? "woo" (ref obj 'woo))))))))

(test* "kahua-test-sub w/ keys" '(4 5)
       (sort (with-clean-db (db *dbname*)
	       (map kahua-persistent-id
		    (make-kahua-collection <kahua-test-sub> :keys '("wooboo" "wooobooo"))))))

;; This tests instance-by-key table initialization protocol
;; ³쥯κˡin-memoryǡ١Υǥåϥå夬
;; åȥåפ뤳Ȥǧ롣
(test* "kahua-test-sub" '((<kahua-test-sub> . "wooboo")
                          (<kahua-test-sub> . "wooobooo"))
       (with-clean-db (db *dbname*)
         (make-kahua-collection <kahua-test-sub>)
         (sort (hash-table-keys (ref db 'instance-by-key))
               (lambda (a b) (string<? (cdr a) (cdr b))))))

;; <kahua-test>ȡsubclassǤ<kahua-test-sub>ξԤȤ
;; ³󥹥󥹤Υ쥯<kahua-test>Ф
;; make-kahua-collectionѤƺǤ뤳Ȥǧ롥
(test* "kahua-test-subclasses"
       '((1 . <kahua-test>) (2 . <kahua-test>) (4 . <kahua-test-sub>) (5 . <kahua-test-sub>))
       (sort (with-clean-db (db *dbname*)
               (map (lambda (i) (cons (kahua-persistent-id i) (class-name (class-of i))))
                    (make-kahua-collection <kahua-test> :subclasses #t)))
	     (lambda (a b) (< (car a) (car b)))))

(define-class <hogehoge> (<kahua-persistent-base>)
  ((a :allocation :persistent :init-keyword :a)))

(test* "make-kahua-collection / floating instance" 1
       (with-clean-db (db *dbname*)
          (make <hogehoge> :a 'a)
          (size-of (make-kahua-collection <hogehoge>))))

(test* "make-kahua-collection / db instance" 1
       (with-clean-db (db *dbname*)
          (size-of (make-kahua-collection <hogehoge>))))

;;----------------------------------------------------------
;; ᥿˴ؤƥȡ³饹ѹ򥪥֥ȥޥ͡
;; ǧֹưŪͿƴƤ뤳Ȥǧ롣
(test-section "metainfo history")

;; Tests source-id change
;;   åѤsource-idѤ³饹
;;   ³饹ֹ椬Ѳʤȡѹsource-idֹؤ
;;   ޥåԥ󥰤ꤵƤ뤳Ȥǧ롣
(define-class <kahua-test-sub> (<kahua-test>)
  ((woo :allocation :persistent :init-keyword :woo :init-value "W")
   (boo :allocation :persistent :init-keyword :boo :init-value "B")
   ;; this shadows parent's quock
   (quock :allocation :persistent :init-keyword :quock :init-value #f))
  :source-id "Rev 4")

(test* "generation with source-id change"
       '("1B" 0 0 (0))
       (with-clean-db (db *dbname*)
         (let1 ins (make <kahua-test-sub>
                     :woo "1" :quick 'q1 :muick 'm1 :quock 'o1)
           (list (key-of ins)
                 (ref <kahua-test-sub> 'generation)
                 (ref <kahua-test-sub> 'persistent-generation)
                 (assoc-ref (ref (ref <kahua-test-sub> 'metainfo)
                                 'source-id-map)
                            "Rev 4")))))

;;   ˡSource-idᤷ³饹³åȰʳ
;;   ѹǤϱ³饹ֹ椬ѲʤȡSource-id
;;   ֹؤΥޥåԥ󥰤ʤȤǧ롣
(define <kahua-test-sub-save> <kahua-test-sub>)

(define-class <kahua-test-sub> (<kahua-test>)
  ((woo :allocation :persistent :init-keyword :woo :init-value "W")
   (boo :allocation :persistent :init-keyword :boo :init-value "B")
   (bar :init-keyword :bar :init-value #f)
   ;; this shadows parent's quock
   (quock :allocation :persistent :init-keyword :quock :init-value #f))
  :source-id "Rev 3")

(test* "generation with source-id change (revert source-id)"
       '("2B" 0 0 (0))
       (with-clean-db (db *dbname*)
         (let1 ins (make <kahua-test-sub> :woo "2")
           (list (key-of ins)
                 (ref <kahua-test-sub> 'generation)
                 (ref <kahua-test-sub> 'persistent-generation)
                 (assoc-ref (ref (ref <kahua-test-sub> 'metainfo)
                                 'source-id-map)
                            "Rev 3")))))

;;   Source-idݤäޤޱ³饹Υåѹ³饹
;;   ֹ椬ѹ뤳ȡsource-idֹؤΥޥåפ
;;   ʣꤵ뤳Ȥǧ롣
(define-class <kahua-test-sub> (<kahua-test>)
  ((woo :allocation :persistent :init-keyword :woo :init-value "W")
   (boo :allocation :persistent :init-keyword :boo :init-value "B")
   (bar :allocation :persistent :init-keyword :bar :init-value #f)
   ;; this shadows parent's quock
   (quock :allocation :persistent :init-keyword :quock :init-value #f))
  :source-id "Rev 3")

(test* "generation with source-id change (update)" '(1 1 (1 0))
       (with-clean-db (db *dbname*)
         (make <kahua-test-sub>
           :woo "3" :quick 'q3 :muick 'm3 :quock 'o3 :bar 'b3)
         (list (ref <kahua-test-sub> 'generation)
               (ref <kahua-test-sub> 'persistent-generation)
               (assoc-ref (ref (ref <kahua-test-sub> 'metainfo)
                               'source-id-map)
                          "Rev 3"))))

;;   嵭ݤäޤޱ³饹source-idѹsource-id
;;   ֹؤmany-to-manyΥޥåԥ󥰤Ƥ뤳Ȥ
;;   ǧ롣
(define-class <kahua-test-sub> (<kahua-test>)
  ((woo :allocation :persistent :init-keyword :woo :init-value "W")
   (boo :allocation :persistent :init-keyword :boo :init-value "B")
   (bar :allocation :persistent :init-keyword :bar :init-value #f)
   ;; this shadows parent's quock
   (quock :allocation :persistent :init-keyword :quock :init-value #f))
  :source-id "Rev 4")

(test* "generation with source-id change (change source-id)" '(1 1 (1 0))
       (with-clean-db (db *dbname*)
         (make <kahua-test-sub> :woo "4" :quock 'o4)
         (list (ref <kahua-test-sub> 'generation)
               (ref <kahua-test-sub> 'persistent-generation)
               (assoc-ref (ref (ref <kahua-test-sub> 'metainfo)
                               'source-id-map)
                          "Rev 4"))))

;;   Ƥα³饹뤳Ȥˤä<kahua-test-sub>μư
;;   ȥꥬѹǡ١Υ᥿ˤȿǤ뤳Ȥ
;;   ǧ롣
;;   slot change: drop muick.
(define-class <kahua-test> (<kahua-persistent-base>)
  ((quick :allocation :persistent :init-keyword :quick :init-value 'i)
   )
  :source-id "Rev 3")

(test* "generation with source-id change (change parent)" '(2 2 (2 1 0))
       (with-clean-db (db *dbname*)
         (make-kahua-collection <kahua-test-sub>)
         (list (ref <kahua-test-sub> 'generation)
               (ref <kahua-test-sub> 'persistent-generation)
               (assoc-ref (ref (ref <kahua-test-sub> 'metainfo)
                               'source-id-map)
                          "Rev 4"))))

;;   ΥƥȤΤˡ⤦ѹƤ
;;   (ƥ饹Ǻ줿åmuickҥ饹)
(define-class <kahua-test-sub> (<kahua-test>)
  ((woo   :allocation :persistent :init-keyword :woo :init-value "W")
   (boo :allocation :persistent :init-keyword :boo :init-value "B")
   (bee :allocation :persistent :init-keyword :boo :init-value 'bee)
   (muick :allocation :persistent :init-keyword :muick :init-value #f))
  :source-id "Rev 5")

(test* "generation with source-id change (change source-id again)" '(3 3 (3))
       (with-clean-db (db *dbname*)
         (make <kahua-test-sub> :woo "5")
         (list (ref <kahua-test-sub> 'generation)
               (ref <kahua-test-sub> 'persistent-generation)
               (assoc-ref (ref (ref <kahua-test-sub> 'metainfo)
                               'source-id-map)
                          "Rev 5"))))

;;----------------------------------------------------------
;; 󥹥󥹤֤ѹ˴ؤƥȡۤʤα³饹
;; 줿󥹥󥹤˥ݤˡ֤μưѴԤ
;; ȤǧʲΥȤǤϡ<kahua-test-sub>[n]n
;; <kahua-test-sub>饹Ǥ뤳Ȥɽ롣
(test-section "instance translation")

;; ƥȳˡߤα³ȥ졼ƤǧƤ
;; ³饹<kahua-test-sub>ϰʲ̤Ǥ롣
;; ([4]ϰʲΥƥ)
;;
;; generation   [0]        [1]         [2]         [3]         [4]
;; ----------------------------------------------------------------
;; p-slots     quick       quick       quick       quick
;;             muick       muick                   muick
;;             woo         woo         woo         woo         woo
;;             boo         boo         boo         boo         boo
;;             quock       quock       quock                   quock
;;                         bar         bar                     bar
;;                                                 bee         bee
;; 
;; source-id   "Rev 3"     "Rev 3"     "Rev 4"     "Rev 5"     "Rev 6"
;;             "Rev 4"     "Rev 4"
;; -------------------------------------------------------
;;
;; ߤα³饹
;;   in-memory class:  <kahua-test-sub>[3]
;;   in-db     class:  <kahua-test-sub>[3]
;; ߤα³󥹥󥹤in-db
;;   "wooboo"    [0]
;;   "woobooo"   [0]
;;   "1B"        [0]
;;   "2B"        [0]
;;   "3B"        [1]
;;   "4B"        [1]
;;   "5B"        [3]

;;   ޤ<kahua-test-sub>[0]Ǻ줿³󥹥󥹤ɤ߽Ф
;;   줬<kahua-test-sub>[3]ι˥åץǡȤƤ뤳Ȥǧ롣
(test* "translation [0]->[3]"
       '(:slots 
         ((quick . q1) (muick . m1) (woo . "1") (boo . "B") (bee . beebee))
         :hidden
         ((quock . o1))
         :instance-generation 0)
       (with-clean-db (db *dbname*)
         (let1 obj (find-kahua-instance <kahua-test-sub> "1B")
           (set! (ref obj 'bee) 'beebee)
           (list :slots (map (lambda (s) (cons s (ref obj s)))
                             '(quick muick woo boo bee))
                 :hidden (ref obj '%hidden-slot-values)
                 :instance-generation (ref obj '%persistent-generation)))))

;;   ö <kahua-test-sub> [2]ᤷ󥹥"1B"
;;   [3]Ǻ줿åquockͤ褷Ƥ뤳Ȥ
;;   ǧ롣

(define-class <kahua-test-sub> (<kahua-test>)
  ((woo   :allocation :persistent :init-keyword :woo :init-value "W")
   (boo :allocation :persistent :init-keyword :boo :init-value "B")
   (bar :allocation :persistent :init-keyword :bar :init-value #f)
   ;; this shadows parent's quock
   (quock :allocation :persistent :init-keyword :quock :init-value #f))
  :source-id "Rev 4")

(test* "translation [3]->[2]"
       '(:class-generations
         (2 3)
         :slots
         ((quick . q1) (woo . "1") (boo . "B") (quock . o1) (bar . #t))
         :hidden
         ((bee . beebee) (muick . m1))
         :instance-generation 3)
       (with-clean-db (db *dbname*)
         (let1 obj (find-kahua-instance <kahua-test-sub> "1B")
           (set! (ref obj 'bar) #t)
           (list :class-generations
                 (list (ref <kahua-test-sub> 'generation)
                       (ref <kahua-test-sub> 'persistent-generation))
                 :slots (map (lambda (s) (cons s (ref obj s)))
                             '(quick woo boo quock bar))
                 :hidden (ref obj '%hidden-slot-values)
                 :instance-generation (ref obj '%persistent-generation)))))

;;   [1]Υ󥹥"3B"ˤ⥢줬[2]˥åץǡ
;;   뤳Ȥǧ롣

(test* "translation [1]->[2]"
       '(:class-generations
         (2 3)
         :slots
         ((quick . q3) (woo . "3") (boo . "B") (quock . o3) (bar . b3))
         :instance-generation 1)
       (with-clean-db (db *dbname*)
         (let1 obj (find-kahua-instance <kahua-test-sub> "3B")
           (touch-kahua-instance! obj)
           (list :class-generations
                 (list (ref <kahua-test-sub> 'generation)
                       (ref <kahua-test-sub> 'persistent-generation))
                 :slots (map (lambda (s) (cons s (ref obj s)))
                             '(quick woo boo quock bar))
                 :instance-generation (ref obj '%persistent-generation)))))

;;   Ƥ<kahua-test-sub>[3]ᤷ󥹥"1B", "3B"
;;   줾쥢롣"1B"[2]ᤷݤ˾äå(bee)
;;   ڤӡ"3B"[2]˰ܹԤݤ˾äå (muick) 褷Ƥ
;;   Ȥǧ롣ޤƱ³󥹥󥹤ϺǤʤΤޤ
;;   (ʤ"1B"Ǥ[3], "3B"Ǥ[2])Ǥ뤳Ȥǧ롣

(define-class <kahua-test-sub> (<kahua-test>)
  ((woo   :allocation :persistent :init-keyword :woo :init-value "W")
   (boo :allocation :persistent :init-keyword :boo :init-value "B")
   (bee :allocation :persistent :init-keyword :boo :init-value 'bee)
   (muick :allocation :persistent :init-keyword :muick :init-value #f))
  :source-id "Rev 5")

(test* "translation [2]->[3]"
       '(:class-generations
         (3 3)
         :slots
         (((quick . q1) (woo . "1") (boo . "B") (muick . m1) (bee . beebee))
          ((quick . q3) (woo . "3") (boo . "B") (muick . m3) (bee . bee)))
         :instance-generation (3 2))
       (with-clean-db (db *dbname*)
         (let1 objs
             (list (find-kahua-instance <kahua-test-sub> "1B")
                   (find-kahua-instance <kahua-test-sub> "3B"))
           (for-each touch-kahua-instance! objs)
           (list :class-generations
                 (list (ref <kahua-test-sub> 'generation)
                       (ref <kahua-test-sub> 'persistent-generation))
                 :slots (map (lambda (obj)
                               (map (lambda (s) (cons s (ref obj s)))
                                    '(quick woo boo muick bee)))
                             objs)
                 :instance-generation (map (cut ref <> '%persistent-generation)
                                           objs)))))

;; ʳǤγƥ󥹥󥹤in-dbϼΤ褦ˤʤäƤ롣
;;   "wooboo"    [0]
;;   "wooobooo"  [0]
;;   "1B"        [3]
;;   "2B"        [0]
;;   "3B"        [3]
;;   "4B"        [1]
;;   "5B"        [3]

;;   ٤<kahua-test-sub>[0]ޤ᤹[0][3]
;;   ³󥹥ʣɤ߽ФƤin-memoryǤ[0]
;;   󥹥󥹤ˤʤäƤ뤳Ȥǧ롣

(define-class <kahua-test> (<kahua-persistent-base>)
  ((quick :allocation :persistent :init-keyword :quick :init-value 'i)
   (quack :init-keyword :quack :init-value 'a)
   (muick :allocation :persistent :init-keyword :muick :init-value 'm)
   (quock :allocation :virtual
          :slot-ref  (lambda (o) (ref o 'quick))
          :slot-set! (lambda (o v) #f))
   )
  :source-id "Rev 2")

(define-class <kahua-test-sub> (<kahua-test>)
  ((woo :allocation :persistent :init-keyword :woo :init-value "W")
   (boo :allocation :persistent :init-keyword :boo :init-value "B")
   ;; this shadows parent's quock
   (quock :allocation :persistent :init-keyword :quock :init-value #f))
  :source-id "Rev 3")

(test* "translation [0]->[0]"
       '(:class-generations
         (0 3)
         :slots
         (((woo . "woo") (boo . "boo") (muick . m) (quock . "quock"))
          ((woo . "wooo") (boo . "booo") (muick . m) (quock . Q)))
         :instance-generation (0 0))
       (with-clean-db (db *dbname*)
         (let1 objs
             (list (find-kahua-instance <kahua-test-sub> "wooboo")
                   (find-kahua-instance <kahua-test-sub> "wooobooo"))
           (set! (ref (cadr objs) 'quock) 'Q)
           (list :class-generations
                 (list (ref <kahua-test-sub> 'generation)
                       (ref <kahua-test-sub> 'persistent-generation))
                 :slots (map (lambda (obj)
                               (map (lambda (s) (cons s (ref obj s)))
                                    '(woo boo muick quock)))
                             objs)
                 :instance-generation (map (cut ref <> '%persistent-generation)
                                           objs)))))

(test* "translation [3]->[0]"
       '(:slots
         (((woo . "1") (boo . "B") (muick . m1) (quock . o1))
          ((woo . "3") (boo . "B") (muick . m3) (quock . o3))
          ((woo . "5") (boo . "B") (muick . #f) (quock . QQ)))
         :instance-generation (3 3 3))
       (with-clean-db (db *dbname*)
         (let1 objs
             (list (find-kahua-instance <kahua-test-sub> "1B")
                   (find-kahua-instance <kahua-test-sub> "3B")
                   (find-kahua-instance <kahua-test-sub> "5B"))
           (set! (ref (caddr objs) 'quock) 'QQ)
           (list :slots (map (lambda (obj)
                               (map (lambda (s) (cons s (ref obj s)))
                                    '(woo boo muick quock)))
                             objs)
                 :instance-generation (map (cut ref <> '%persistent-generation)
                                           objs)))))


;;   ǡ<kahua-test-sub>롣٤<kahua-test>
;;   Ѿʤ[4]Ȥʤ뤳Ȥǧ롣ޤ
;;   α³󥹥󥹤ɤ߹ߡ餬
;;   åץǡȤƤ뤳ȡ֤translationǾäå
;;   ͤƤʤȡǧ롣

(define-class <kahua-test-sub> (<kahua-persistent-base>)
  ((woo :allocation :persistent :init-keyword :woo :init-value "W")
   (boo :allocation :persistent :init-keyword :boo :init-value "B")
   (quock :allocation :persistent :init-keyword :quock :init-value #f)
   (bar :allocation :persistent :init-keyword :bar :init-value #f)
   (bee :allocation :persistent :init-keyword :boo :init-value 'bee)
   )
  :source-id "Rev 6")

(test* "translation [0]->[4]"
       '(:class-generations
         (4 4)
         :slots
         (((woo . "woo") (boo . "boo") (quock . "quock") (bar . #f) (bee . bee))
          ((woo . "wooo") (boo . "booo") (quock . Q) (bar . wooobooo) (bee . bee))
          ((woo . "2") (boo . "B") (quock . #f) (bar . b2) (bee . bee)))
         :instance-generation (0 0 0))
       (with-clean-db (db *dbname*)
         (let1 objs
             (list (find-kahua-instance <kahua-test-sub> "wooboo")
                   (find-kahua-instance <kahua-test-sub> "wooobooo")
                   (find-kahua-instance <kahua-test-sub> "2B"))
           (set! (ref (cadr objs) 'bar) 'wooobooo)
           (set! (ref (caddr objs) 'bar) 'b2)
           (list :class-generations
                 (list (ref <kahua-test-sub> 'generation)
                       (ref <kahua-test-sub> 'persistent-generation))
                 :slots (map (lambda (obj)
                               (map (lambda (s) (cons s (ref obj s)))
                                    '(woo boo quock bar bee)))
                             objs)
                 :instance-generation (map (cut ref <> '%persistent-generation)
                                           objs)))))
       

(test* "translation [1]->[4]"
       '(:slots
         ((woo . "4") (boo . "B") (quock . o4) (bar . b4) (bee . bee))
         :instance-generation 1)
       (with-clean-db (db *dbname*)
         (let1 obj (find-kahua-instance <kahua-test-sub> "4B")
           (set! (ref obj 'bar) 'b4)
           (list :slots (map (lambda (s) (cons s (ref obj s)))
                             '(woo boo quock bar bee))
                 :instance-generation (ref obj '%persistent-generation)))))

(test* "translation [3]->[4]"
       '(:slots
         (((woo . "1") (boo . "B") (quock . o1) (bar . #t) (bee . beebee))
          ((woo . "3") (boo . "B") (quock . o3) (bar . b3) (bee . bee))
          ((woo . "5") (boo . "B") (quock . QQ) (bar . #f) (bee . bee)))
         :instance-generation (3 3 3))
       (with-clean-db (db *dbname*)
         (let1 objs
             (list (find-kahua-instance <kahua-test-sub> "1B")
                   (find-kahua-instance <kahua-test-sub> "3B")
                   (find-kahua-instance <kahua-test-sub> "5B"))
           (for-each touch-kahua-instance! objs)
           (list :slots (map (lambda (obj)
                               (map (lambda (s) (cons s (ref obj s)))
                                    '(woo boo quock bar bee)))
                             objs)
                 :instance-generation (map (cut ref <> '%persistent-generation)
                                           objs)))))

;;   ǥåץǡȤ³󥹥󥹤Τѹ
;;   touch-kahua-instance! ǡֿ줿פΤΤߡ³󥹥󥹤
;;   夬Ƥ뤳Ȥǧ롣

(test* "translation (instances' persistent generations)"
       '(("1B" . 4) ("2B" . 4) ("3B" . 4) ("4B" . 4) ("5B" . 4)
         ("wooboo" . 0) ("wooobooo" . 4))
       (with-clean-db (db *dbname*)
         (sort
          (map (lambda (obj)
                 (cons (key-of obj)
                       (ref obj '%persistent-generation)))
               (make-kahua-collection <kahua-test-sub>))
          (lambda (a b)
            (string<? (car a) (car b))))))

;;----------------------------------------------------------
;; ȥ󥶥Υƥ
(test-section "transaction / default(read-only, no-sync)")

(define-class <transaction-test-1> (<kahua-persistent-base>)
  ((a :init-value 0 :init-keyword :a :allocation :persistent)))

(define-method key-of ((self <transaction-test-1>))
  "key")

(test "ref out of transaction" 1
      (lambda ()
        (let1 object (with-clean-db (db *dbname*)
                       (make <transaction-test-1> :a 1))
          (ref object 'a))))

(test "write in other transaction" #t
      (lambda ()
        (with-clean-db (db *dbname*)
          (let1 object (find-kahua-instance <transaction-test-1> "key")
            (set! (ref object 'a) 2)))
        #t))

(test "check (write in other transaction" 2
      (lambda ()
        (with-clean-db (db *dbname*)
          (let1 object (find-kahua-instance <transaction-test-1> "key")
            (ref object 'a)))))

(test "set! out of transaction" *test-error*
      (lambda ()
        (let1 object (with-clean-db (db *dbname*)
                       (make <transaction-test-1> :a 1))
          (set! (ref object 'a) 1)
          #t)))

(test-section "transaction / access denied")

(define-class <transaction-test-2> (<kahua-persistent-base>)
  ((a :init-value 0 :init-keyword :a :allocation :persistent
      :out-of-transaction :denied)))

(test "ref out of transaction" *test-error*
      (lambda ()
        (let1 object (with-clean-db (db *dbname*)
                       (make <transaction-test-2> :a 0))
          (ref object 'a))))

(test "ref in other transaction" 1
      (lambda ()
        (let1 object (with-clean-db (db *dbname*)
                       (make <transaction-test-2> :a 1))
          (with-clean-db (db *dbname*)
            (ref object 'a)))))

(test "set! out of transaction" *test-error*
      (lambda ()
        (let1 object (with-clean-db (db *dbname*)
                       (make <transaction-test-2> :a 0))
          (set! (ref object 'a) 1))))

(test-section "transaction / read-only auto-sync")

(define-class <transaction-test-3> (<kahua-persistent-base>)
  ((key :init-value #f :init-keyword :key :allocation :persistent)
   (a :init-value 0 :init-keyword :a :allocation :persistent))
  :read-syncer :auto)

(define-method key-of ((self <transaction-test-3>))
  (ref self 'key))

(define (geto key)
  (with-clean-db (db *dbname*)
    (find-kahua-instance <transaction-test-3> key)))

(test "ref out of transaction" 0
      (lambda ()
        (let1 object (with-clean-db (db *dbname*)
                       (make <transaction-test-3> :key "0" :a 0))
          (ref object 'a))))

(define (other-transaction num)
  (with-db (db *dbname*)
    (let1 object (geto "0")
      (set! (ref object 'a) num)))
  (sys-exit 0))

(test "write in other transaction" 1
      (lambda ()
        (let1 object (geto "0")
          (let1 pid (sys-fork)
            (if (= pid 0)
                (other-transaction 1)
                (begin
                  (sys-waitpid pid)
                  (with-db (db *dbname*) (ref object 'a))))))))

(test "overwrite object" 5
      (lambda ()
        (let1 object (geto "0")
          (let1 pid (sys-fork)
            (if (= pid 0)
                (other-transaction 2)
                (begin
                  (sys-waitpid pid)
                  (with-db (db *dbname*) (set! (ref object 'a) 5))
                  (with-db (db *dbname*) (ref object 'a))))))))

; (test-section "transaction / read/write auto-sync")
; (define-class <transaction-test-4> (<kahua-persistent-base>)
;   ((a :init-value 0 :init-keyword :a :allocation :persistent
;       :out-of-transaction :read/write))
;   :read-syncer  :auto
;   :write-syncer :auto)

; (define-method key-of ((self <transaction-test-4>))
;   "key")

; (define object #f)

; (test* "make" #t
;        (with-db (db *dbname*)
;          (set! object (make <transaction-test-4> :a 0))
;          #t))

; (test "write out of transaction" 1
;       (lambda () (set! (ref object 'a) 1) 1))

; ;; ȥ󥶥󳫻ϻon-memory cachedb˽񤭹ޤ
; ;; 뤳Ȥǧ롣
; (test* "read in other transaction (auto synched: 1)" 1
;        (with-db (db *dbname*)
;          (ref (find-kahua-instance <transaction-test-4> "key") 'a)))

; ;; ȥ󥶥ǽ񤭹ޤ줿ḁ̇̄ȥ󥶥
; ;; ˤɤ߽Ф뤳Ȥǧ롣
; (test* "read in other transaction (auto synched: 2)" 1
;        (with-db (db *dbname*) (ref object 'a)))

;;----------------------------------------------------------
;; unboundʥåȤΥƥ
(test-section "unbound slot")

(define-class <unbound-slot-class> (<kahua-persistent-base>)
  ((normal :allocation :persistent :init-value 'val)
   (unbound :allocation :persistent)))

(define-method key-of ((self <unbound-slot-class>))
  (x->string (ref self 'normal)))

(test* "make unbound slot instance" '(val #f)
       (with-clean-db (db *dbname*)
         (let1 obj (make <unbound-slot-class>)
           (list (ref obj 'normal)
                 (slot-bound? obj 'unbound)
                 ))))


(test* "check unbound slot" '(val #f)
       (with-clean-db (db *dbname*)
         (let1 obj (find-kahua-instance <unbound-slot-class> "val")
           (list (ref obj 'normal)
                 (slot-bound? obj 'unbound)
                 ))))

;;----------------------------------------------------------
;; ᥽åinitializepersistent-initialize methodΥå
(test-section "initialize and persistent-initialize method")

(define-class <init-A> (<kahua-persistent-base>)
  ((base1 :allocation :persistent :init-value 0)
   (base2 :allocation :persistent :init-value 0)
   (key :init-value "a" :accessor key-of)))

(define-method persistent-initialize ((obj <init-A>) initargs)
  (update! (ref obj 'base1) (cut + <> 1)))

(define-method initialize ((obj <init-A>) initargs)
  (next-method)
  (update! (ref obj 'base2) (cut + <> 1)))


(test* "make first instance" '(1 1)
       (with-clean-db (db *dbname*)
         (let1 obj (make <init-A>)
           (list (ref obj 'base1)
                 (ref obj 'base2)))))

(test* "find instance" '(1 2)
       (with-clean-db (db *dbname*)
         (let1 obj (find-kahua-instance <init-A> "a")
           (list (ref obj 'base1)
                 (ref obj 'base2)))))

;;----------------------------------------------------------
;; ³饹Υå
(test-section "persistent class redefine")

(define-class <redefine-A> (<kahua-persistent-base>)
  ((base :allocation :persistent :init-value 0)
   (key :init-value "a" :accessor key-of)))

(define-class <redefine-B> (<kahua-persistent-base>)
  ((base :allocation :persistent :init-value 1)
   (key :init-value "b" :accessor key-of)))

(define *id* #f)
(define *id2* #f)

(test* "make first instance(1)" 0
       (with-db (db *dbname*)
         (let1 obj (make <redefine-A>)
           (set! *id* (kahua-persistent-id obj))
           (ref obj 'base))))

(redefine-class! <redefine-A> <redefine-B>)

(test* "redefine instance(1)" '(#f 0)
       (with-db (db *dbname*)
	 (let* ((obj (find-kahua-instance <redefine-A> "a"))
		(base (ref obj 'base)))	; trigger instance update.
	   (set! *id2* (kahua-persistent-id obj))
	   (list (eq? *id* (kahua-persistent-id obj)) base))))

(test* "find redefined instance(1)" '(#t 0)
       (with-clean-db (db *dbname*)
		      (let1 obj (find-kahua-instance <redefine-B> "a")
			(list (eq? *id2* (kahua-persistent-id obj))
			      (ref obj 'base)))))

(define-class <redefine-C> (<kahua-persistent-base>)
  ((base :allocation :persistent :init-value 0)
   (key :init-value "c" :accessor key-of)))

(test* "make first instance(2)" 0
       (with-db (db *dbname*)
         (let1 obj (make <redefine-C>)
           (set! *id* (kahua-persistent-id obj))
           (ref obj 'base))))

(define-class <redefine-C> (<kahua-persistent-base>)
  ((base :allocation :persistent :init-value 1)
   (base2 :allocation :persistent :init-value 10)
   (key :init-value "c" :accessor key-of)))

(test* "find redefined instance(2)" '(#t 0 10)
       (with-db (db *dbname*)
                (let1 obj (find-kahua-instance <redefine-C> "c")
           (list (eq? *id* (kahua-persistent-id obj))
                 (ref obj 'base)
                 (ref obj 'base2)))))

;;----------------------------------------------------------
;; ³饹¾Υ᥿饹Ʊ˻Ȥå
;; Ѿå

(test-section "useing other metaclass")

(use gauche.mop.validator)

(define-class <valid-A> (<kahua-persistent-base> <validator-mixin>)
  ((number :allocation :persistent :init-value "0"
           :validator (lambda (obj value)
                        (if (not (string? value))
                            value
                          (string->number value))))))

(define-class <valid-B> (<validator-mixin> <kahua-persistent-base>)
  ((string :allocation :persistent :init-value "0"
           :validator (lambda (obj value)
                        (if (kahua-wrapper? value)
                            value
                          (x->string value))))))

(define-method key-of ((obj <valid-A>))
  "valid-a")

(define-method key-of ((obj <valid-B>))
  "valid-b")

(test* "make mixin instance" '(10 "(a b c)")
       (with-clean-db (db *dbname*)
         (let ((a-obj (make <valid-A>))
               (b-obj (make <valid-B>)))
           (slot-set! a-obj 'number "10")
           (slot-set! b-obj 'string '(a b c))
           (list (ref a-obj 'number)
                 (ref b-obj 'string)))))

(test* "find mixin instance" '(10 "(a b c)")
       (with-clean-db (db *dbname*)
         (let ((a-obj (find-kahua-instance <valid-A> "valid-a"))
               (b-obj (find-kahua-instance <valid-B> "valid-b")))
           (list (ref a-obj 'number)
                 (ref b-obj 'string)))))

(test-section "big date")

(define-class <big> (<kahua-persistent-base>)
  ((a :allocation :persistent)))

(define-method key-of ((obj <big>))
  "big")

(test* "make big instance" 100000
       (with-clean-db (db *dbname*)
         (let ((obj (make <big>)))
           (slot-set! obj 'a (make-string 100000 #\a))
           (string-length (ref obj 'a)))))

(test* "make big instance" 100000
       (with-clean-db (db *dbname*)
         (let ((obj (find-kahua-instance <big> "big")))
           (string-length (ref obj 'a)))))

;;----------------------------------------------------------
;; ֥Ȥκ
(test-section "object deletion")

;; Fist: before commit.
(define *key* #f)
(with-clean-db (db *dbname*)
  (let* ((obj (car (map identity (make-kahua-collection <hogehoge>))))
	 (key (key-of obj)))
    (test* "before remove-kahua-instance" #f (removed? obj) eq?)
    (test* "remove-kahua-instance" (undefined) (remove-kahua-instance obj) eq?)
    (test* "after remove-kahua-instance" #t (removed? obj) eq?)
    (test* "find-kahua-instance" #f (find-kahua-instance <hogehoge> key) eq?)
    (test* "find-kahua-instance w/ #t" #t (and-let* ((o (find-kahua-instance <hogehoge> key #t)))
					    (removed? o)) eq?)
    (test* "make-kahua-collection" '() (map identity (make-kahua-collection <hogehoge>)) eq?)
    (let1 l (map identity (make-kahua-collection <hogehoge> :include-removed-object? #t))
      (test* "make-kahua-collection w/ :include-removed-object?" 1 (length l) =)
      (test* "it\'s removed?" #t (removed? (car l)) eq?))
    (set! *key* key)
    ))

;; Second: after commit;
(with-clean-db (db *dbname*)
  (let1 key *key*
    (test* "find-kahua-instance" #f (find-kahua-instance <hogehoge> key) eq?)
    (test* "find-kahua-instance w/ #t" #t (and-let* ((o (find-kahua-instance <hogehoge> key #t)))
					    (removed? o)) eq?)
    (test* "make-kahua-collection" '() (map identity (make-kahua-collection <hogehoge>)) eq?)
    (let1 l (map identity (make-kahua-collection <hogehoge> :include-removed-object? #t))
      (test* "make-kahua-collection w/ :include-removed-object?" 1 (length l) =)
      (test* "it\'s removed?" #t (removed? (car l)) eq?)
      )))

;; Third: new object and remove it immediately
(with-clean-db (db *dbname*)
  (let* ((obj (make <hogehoge> :a 'aa))
	 (key (key-of obj)))
    (test* "before remove-kahua-instance" #f (removed? obj) eq?)
    (test* "remove-kahua-instance" (undefined) (remove-kahua-instance obj) eq?)
    (test* "after remove-kahua-instance" #t (removed? obj) eq?)
    (test* "find-kahua-instance" #f (find-kahua-instance <hogehoge> key) eq?)
    (test* "find-kahua-instance w/ #t" #t (and-let* ((o (find-kahua-instance <hogehoge> key #t)))
					    (removed? o)) eq?)
    (test* "make-kahua-collection" '() (map identity (make-kahua-collection <hogehoge>)) eq?)
    (let1 l (map identity (make-kahua-collection <hogehoge> :include-removed-object? #t))
      (test* "make-kahua-collection w/ :include-removed-object?" 2 (length l) =))
    (kahua-db-rollback db)
    (let1 l (map identity (make-kahua-collection <hogehoge> :include-removed-object? #t))
      (test* "make-kahua-collection w/ :include-removed-object?" 1 (length l) =))
    ))

;; Forth: reference to other objects
(with-clean-db (db *dbname*)
  (let* ((l (map identity (make-kahua-collection <kahua-test>)))
	 (obj (car l))
	 (key (key-of obj)))
    (test* "before remove-kahua-instance" #f (removed? (ref obj 'quick)) eq?)
    (test* "length of kahua-collection" 2 (length l) =)
    (test* "remove-kahua-instance" (undefined) (remove-kahua-instance (ref obj 'quick)) eq?)
    (test* "after remove-kahua-instance" #f (ref obj 'quick) eq?)
    (test* "length of kahua-collection" 1 (length (map identity (make-kahua-collection <kahua-test>))) =)
    ))
(with-clean-db (db *dbname*)
  (let* ((l (map identity (make-kahua-collection <kahua-test>)))
	 (obj (car l))
	 (key (key-of obj)))
    (test* "after remove-kahua-instance" #f (ref obj 'quick) eq?)
    (test* "length of kahua-collection" 1 (length (map identity (make-kahua-collection <kahua-test>))) =)
    ))

(test-end)
