;; -*- coding: euc-jp ; mode: scheme -*-
;; test kahua.developer
;; Kahua.developer ⥸塼Υƥ

;; $Id: developer.scm,v 1.2 2005/07/04 05:09:21 nobsun Exp $

(use gauche.test)
(use srfi-1)
(use file.util)
(use kahua.config)

;;---------------------------------------------------------------
;; start test
;; ȯԥΥƥȤ򳫻Ϥ롣
(test-start "developer")

;; ƥȴĶ
(define conf-file (build-path (sys-getcwd) "user.conf"))
(define conf-lock-file (string-append conf-file ".lock"))


(slot-set! (kahua-config) 'userconf-file conf-file)

(sys-system #`"rm -rf ,conf-file ,conf-lock-file")
(sys-system #`"touch ,conf-file")


;; ɥƥ
;; kahua.developer ɤǤޤΥ󥿡ե
;; ʤȤǧ롣
(use kahua.developer)
(test-module 'kahua.developer)

;; Ȱɽܡ
;; ޤͤϿƤʤΤǡꥹȤˤʤ뤳Ȥǧ롣
(test* "kahua-list-developer" '()
       (kahua-list-developer))

;;  3ʬϿ롣
;;  #t ֤Ȥǧ롣
(test* "kahua-add-developer" #t
       (every (cut eq? <> #t)
              (list (kahua-add-developer "yusei" "^Epc4q-D" '(manager))
                    (kahua-add-developer "admin" "yqX^Vj8q" '(manager))
                    (kahua-add-developer "guest" "N_HHmW6h" '()))))

;; ȤϿ롣
;; ѥɤûΤϿԤ顼뤳Ȥǧ롣
(test* "kahua-add-developer bad password"
       *test-error*
       (kahua-add-developer "anonymous" "a" '()))

;; Ͽ롣
;; ̾ûΤϿԤ顼뤳Ȥǧ롣
(test* "kahua-add-developer bad name"
       *test-error*
       (kahua-add-developer "" "anonymous" '()))

;; Ȱɽܡ
;; ٤Ͽ3֤ͤ̾Ȥǧ롣
(test* "kahua-list-developer" '("yusei" "admin" "guest")
       (kahua-list-developer))

;; Ȥ롣
;; guest  #t ֤Ȥǧ롣
(test* "kahua-delete-developer" #t
       (kahua-delete-developer "guest"))

;; Ȱɽܡ
;; guest ΤǡĤ2֤ͤ̾Ȥǧ롣
(test* "kahua-list-developer" '("yusei" "admin")
       (kahua-list-developer))

;; ȤϿ롣
;; ȤˡȤ#t ֤Ȥǧ롣
(test* "kahua-add-developer" #t
       (kahua-add-developer "anonymous" "anonymous" '()))

;; Ȱɽܡ
;; ɲäȤޤơ3֤ͤ̾Ȥǧ롣
(test* "kahua-list-developer" '("yusei" "admin" "anonymous")
       (kahua-list-developer))

;; ǧڥƥȣܡ
;; Ͽ̾ȥѥɤפΤ #t ֤Ȥǧ롣
(test* "kahua-check-developer" #t
       (kahua-check-developer "yusei" "^Epc4q-D"))

;; ǧڥƥȣܡ
;; ְ̾äƤΤ #f ֤Ȥǧ롣
(test* "kahua-check-developer the name not found" #f
       (kahua-check-developer "yus" "^Epc4q-D"))

;; ǧڥƥȣܡ
;; ѥɤְäƤΤ #f ֤Ȥǧ롣
(test* "kahua-check-developer incorrect password" #f
       (kahua-check-developer "yusei" "^Epc4"))

;; ѥѹܡ
;; ̾ѥɤΤ #t ֤Ȥǧ롣
(test* "kahua-change-developer-password" #t
       (kahua-change-developer-password "admin" "WpX^krRS"))

;; ѥѹܡ
;; ְ̾äƤΤǡ顼뤳Ȥǧ롣
(test* "kahua-change-developer-password the name not found"
       *test-error*
       (kahua-change-developer-password "adnim" "WpX^krRS"))

;; ѥѹܡ
;; ѥɤûΤǡ顼뤳Ȥǧ롣
(test* "kahua-change-developer-password password too short"
       *test-error*
       (kahua-change-developer-password "adnim" "Wp"))

(sys-system #`"rm -rf ,conf-file ,conf-lock-file")

(test-end)
