/*@@@
File:		fct.cxx
Version:	1.1
Description:	Class FCT - Field Coordinate Table
Author:		Nassib Nassar, nrn@cnidr.org
@@@*/

#include <stdlib.h>
#include <iostream.h>

#include "defs.hxx"
#include "string.hxx"
#include "vlist.hxx"
#include "fc.hxx"
#include "fct.hxx"

//#include <iostream.h>


// FCTNODE


FCTNODE::FCTNODE() : VNODE() {
}


// FCT


FCT::FCT() : VLIST() {
}


FCT& FCT::operator=(const FCT& OtherFct) {
	Clear();
	FCTNODE* p = (FCTNODE*)(OtherFct.GetNodePtr(1));
	FCTNODE* n;
	while (p) {
		n = new FCTNODE();
		n->Fc = p->Fc;
		AddNode(n);
		p = (FCTNODE*)(OtherFct.GetNextNodePtr(p));
	}
	return *this;
}


void FCT::AddEntry(const FC& FcRecord) {
	FCTNODE* NodePtr = new FCTNODE();
	NodePtr->Fc = FcRecord;
	VLIST::AddNode(NodePtr);
}

void FCT::GetEntry(const INT Index, FC* FcRecord) const {
	FCTNODE* NodePtr = (FCTNODE*)(VLIST::GetNodePtr(Index));
	if (NodePtr) {
		*FcRecord = NodePtr->Fc;
	}
}

int FctFcCompare(const void* x, const void* y) {
	return ( ((FC*)x)->GetFieldStart() - ((FC*)y)->GetFieldStart() );
}

void FCT::SortByFc() {
	SIZE_T TotalEntries = GetTotalEntries();
	FC* TablePtr = new FC[TotalEntries];
	SIZE_T x = 0;
	FCTNODE* p = (FCTNODE*)(GetNodePtr(1));
	while (p) {
		TablePtr[x++] = p->Fc;
		p = (FCTNODE*)(GetNextNodePtr(p));
	}
	qsort(TablePtr, TotalEntries, sizeof(FC), FctFcCompare);
	p = (FCTNODE*)(GetNodePtr(1));
	x = 0;
	while (p) {
		p->Fc = TablePtr[x++];
		p = (FCTNODE*)(GetNextNodePtr(p));
	}
	delete [] TablePtr;
}

void FCT::Write(PFILE fp) const {
	SIZE_T TotalEntries = GetTotalEntries();
	fprintf(fp, "%d\n", TotalEntries);
	SIZE_T x;
	for (x=1; x<=TotalEntries; x++) {
		((FCTNODE*)(VLIST::GetNodePtr(x)))->Fc.Write(fp);
	}
}

void FCT::Read(PFILE fp) {
	Clear();
	STRING s;
	FC Fc;
	s.FGet(fp, 16);
	INT n, x;
	n = s.GetInt();
	for (x=0; x<n; x++) {
		Fc.Read(fp);
		AddEntry(Fc);
	}
}

void FCT::Print(ostream& Os) const {
	FCTNODE* p = (FCTNODE*)(GetNodePtr(1));
	while (p) {
		Os << p->Fc;
		p = (FCTNODE*)(GetNextNodePtr(p));
	}
}

void FCT::SubtractOffset(const GPTYPE GpOffset) {
	FCTNODE* p = (FCTNODE*)(GetNodePtr(1));
	while (p) {
		p->Fc.SetFieldStart(p->Fc.GetFieldStart() - GpOffset);
		p->Fc.SetFieldEnd(p->Fc.GetFieldEnd() - GpOffset);
		p = (FCTNODE*)(GetNextNodePtr(p));
	}
}

ostream& operator<<(ostream& Os, const FCT& Fct) {
	Fct.Print(Os);
	return Os;
}
